/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.query.impl.sql.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalRelationship;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.query.impl.sql.Path;
import org.pentaho.metadata.query.impl.sql.graph.Arc;
import org.pentaho.metadata.query.impl.sql.graph.ConsistencyException;
import org.pentaho.metadata.query.impl.sql.graph.GraphElement;
import org.pentaho.metadata.query.impl.sql.graph.GraphElementChangeListener;
import org.pentaho.metadata.query.impl.sql.graph.GraphElementQueue;
import org.pentaho.metadata.query.impl.sql.graph.Node;
import org.pentaho.metadata.query.impl.sql.graph.PathType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MqlGraph
implements GraphElementChangeListener {
    private static final Log logger = LogFactory.getLog(MqlGraph.class);
    private List<LogicalTable> requiredTables;
    private List<Node> nodes = new ArrayList<Node>();
    private List<Arc> arcs = new ArrayList<Arc>();
    private Map<LogicalTable, Node> tableNodeMap = new HashMap<LogicalTable, Node>();
    private GraphElementQueue basicNodeQueue = new GraphElementQueue();
    private GraphElementQueue extendedNodeQueue = new GraphElementQueue();
    private LinkedList<List<GraphElement>> searchStack;
    private boolean needsReset = false;

    public MqlGraph(LogicalModel model) {
        this.build(model.getLogicalRelationships());
    }

    public Path getPath(PathType searchTechnique, List<LogicalTable> requiredTables) {
        if (this.reset(requiredTables) && this.isValid(searchTechnique)) {
            logger.debug((Object)"Path determined sucessfully");
            Path path = new Path();
            for (Arc arc : this.arcs) {
                if (arc.isRequired()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Arc selected for path: " + arc));
                    }
                    path.addRelationship(arc.getRelationship());
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Arc not used for path: Requirement Known[" + arc.isRequirementKnown() + "], Required[" + arc.isRequired() + "]"));
            }
            if (logger.isDebugEnabled()) {
                for (Node n : this.nodes) {
                    logger.debug((Object)("Node selection state: Requirement Known[" + n.isRequirementKnown() + "], Required[" + n.isRequired() + "]"));
                }
            }
            if (path.size() > 0) {
                return path;
            }
        }
        return null;
    }

    private boolean reset(List<LogicalTable> requiredTables) {
        try {
            this.requiredTables = requiredTables;
            if (this.needsReset) {
                if (this.searchStack != null) {
                    this.searchStack.clear();
                }
                for (Node n : this.nodes) {
                    n.clearRequirement();
                }
                for (Arc a : this.arcs) {
                    a.clearRequirement();
                }
            } else {
                this.needsReset = true;
            }
            for (Node n : this.nodes) {
                if (!requiredTables.contains(n.getTable())) continue;
                n.setRequirement(true);
            }
            return true;
        }
        catch (ConsistencyException cx) {
            logger.debug((Object)"failed to reset", (Throwable)cx);
            return false;
        }
    }

    private boolean isValid(PathType searchTechnique) {
        this.extendedNodeQueue.clear();
        this.basicNodeQueue.clear();
        this.basicNodeQueue.addAll(this.nodes);
        try {
            if (searchTechnique == PathType.ALL) {
                for (Node n : this.nodes) {
                    n.setRequirement(true);
                }
                for (Arc a : this.arcs) {
                    a.setRequirement(true);
                }
            }
            this.propagate();
            this.search(searchTechnique);
            return true;
        }
        catch (ConsistencyException cx) {
            logger.debug((Object)"failed to validate", (Throwable)cx);
            return false;
        }
    }

    private void search(PathType searchTechnique) throws ConsistencyException {
        Solution bestKnown = this.searchForNextSolution(searchTechnique, null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("initial solution found - Rating[" + bestKnown.getRating() + "]"));
        }
        if (searchTechnique == PathType.SHORTEST || searchTechnique == PathType.LOWEST_SCORE) {
            try {
                Solution lastSolution = bestKnown;
                while (lastSolution != null) {
                    logger.debug((Object)"continuing search for more solutions from last one located");
                    lastSolution = this.searchForNextSolution(searchTechnique, lastSolution);
                    if (lastSolution != null && logger.isDebugEnabled()) {
                        logger.debug((Object)("Next solution result: " + this.toBitPath(lastSolution.searchPath) + " - partial[" + lastSolution.isPartial() + "]"));
                    }
                    if (lastSolution == null || lastSolution.isPartial()) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("new solution located - Rating[" + lastSolution.getRating() + "]"));
                    }
                    if (lastSolution.getRating() >= bestKnown.getRating()) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"New solution is better than previously best known, continuing from it");
                    }
                    bestKnown = lastSolution;
                }
            }
            catch (ConsistencyException cx) {
                logger.debug((Object)"failed while looking for more solutions", (Throwable)cx);
            }
            logger.debug((Object)"returning to best known solution");
            this.reset(this.requiredTables);
            this.propagate();
            Iterator<Arc> arcIter = bestKnown.getSearchArcs().iterator();
            for (SearchDirection direction : bestKnown.getSearchPath()) {
                Arc arc = arcIter.next();
                if (this.attemptArcAssignment(arc, direction)) continue;
                throw new ConsistencyException(arc);
            }
        }
    }

    private Solution searchForNextSolution(PathType searchTechnique, Solution prevSolution) throws ConsistencyException {
        SearchDirection secondDirection;
        SearchDirection firstDirection;
        if (searchTechnique == PathType.ANY_RELEVANT) {
            firstDirection = SearchDirection.RIGHT;
            secondDirection = SearchDirection.LEFT;
        } else {
            firstDirection = SearchDirection.LEFT;
            secondDirection = SearchDirection.RIGHT;
        }
        LinkedList<SearchDirection> searchPath = new LinkedList<SearchDirection>();
        LinkedList<Arc> searchArcs = new LinkedList<Arc>();
        if (prevSolution != null) {
            boolean prevContainsFirstDirection = false;
            for (SearchDirection direction : prevSolution.searchPath) {
                if (direction != firstDirection) continue;
                prevContainsFirstDirection = true;
                break;
            }
            if (!prevContainsFirstDirection) {
                return null;
            }
            ListIterator pathIter = prevSolution.searchPath.listIterator(prevSolution.searchPath.size());
            boolean foundSecondDir = false;
            while (pathIter.hasPrevious() && !foundSecondDir) {
                int rating;
                SearchDirection direction;
                this.reset(this.requiredTables);
                this.propagate();
                searchPath.clear();
                searchArcs.clear();
                while (pathIter.hasPrevious() && (direction = (SearchDirection)((Object)pathIter.previous())) != firstDirection) {
                }
                Iterator<Arc> arcIter = prevSolution.getSearchArcs().iterator();
                if (pathIter.hasPrevious()) {
                    Iterator<SearchDirection> redoIter = prevSolution.getSearchPath().iterator();
                    int lastIdx = pathIter.previousIndex();
                    for (int idx = 0; idx <= lastIdx; ++idx) {
                        SearchDirection direction2 = redoIter.next();
                        Arc arc = arcIter.next();
                        if (!this.attemptArcAssignment(arc, direction2)) {
                            throw new ConsistencyException(arc);
                        }
                        searchPath.add(direction2);
                        searchArcs.add(arc);
                    }
                }
                if ((rating = this.getRatingForCurrentState(searchTechnique)) >= prevSolution.getRating()) {
                    return new Solution(this.arcs, rating, searchPath, searchArcs, true);
                }
                Arc arc = arcIter.next();
                if (!this.attemptArcAssignment(arc, secondDirection)) continue;
                searchPath.add(secondDirection);
                searchArcs.add(arc);
                rating = this.getRatingForCurrentState(searchTechnique);
                if (rating >= prevSolution.getRating()) {
                    return new Solution(this.arcs, rating, searchPath, searchArcs, true);
                }
                foundSecondDir = true;
            }
            if (searchPath.size() == 0) {
                return null;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"-- Graph State Before Search --");
            this.dumpStateToLog();
        }
        int rating = -1;
        for (Arc a : this.arcs) {
            if (a.isRequirementKnown()) continue;
            if (this.attemptArcAssignment(a, firstDirection)) {
                searchPath.add(firstDirection);
            } else if (this.attemptArcAssignment(a, secondDirection)) {
                searchPath.add(secondDirection);
            } else {
                throw new ConsistencyException(a);
            }
            searchArcs.add(a);
            if (prevSolution == null || (rating = this.getRatingForCurrentState(searchTechnique)) < prevSolution.getRating()) continue;
            return new Solution(this.arcs, rating, searchPath, searchArcs, true);
        }
        if (rating < 0) {
            rating = this.getRatingForCurrentState(searchTechnique);
        }
        return new Solution(this.arcs, rating, searchPath, searchArcs, false);
    }

    private List<Integer> toBitPath(List<SearchDirection> searchPath) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (SearchDirection direction : searchPath) {
            if (direction == SearchDirection.LEFT) {
                result.add(0);
                continue;
            }
            result.add(1);
        }
        return result;
    }

    private void dumpStateToLog() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"-------------------------------------------------");
            for (Arc arc : this.arcs) {
                if (arc.isRequired()) {
                    logger.debug((Object)(arc + "-> Yes"));
                    continue;
                }
                if (arc.isNotRequired()) {
                    logger.debug((Object)(arc + "-> No"));
                    continue;
                }
                logger.debug((Object)(arc + "-> ?"));
            }
            for (Node n : this.nodes) {
                if (n.isRequired()) {
                    logger.debug((Object)(n + "-> Yes"));
                    continue;
                }
                if (n.isNotRequired()) {
                    logger.debug((Object)(n + "-> No"));
                    continue;
                }
                logger.debug((Object)(n + "-> ?"));
            }
            logger.debug((Object)"=================================================");
        }
    }

    private int getRatingForCurrentState(PathType searchTechnique) {
        int rating = 0;
        switch (searchTechnique) {
            case SHORTEST: {
                for (Node n : this.nodes) {
                    if (!n.isRequired()) continue;
                    ++rating;
                }
                break;
            }
            case LOWEST_SCORE: {
                for (Node n : this.nodes) {
                    if (!n.isRequired()) continue;
                    Integer relSize = (Integer)n.getTable().getProperty("relative_size");
                    rating += relSize != null ? relSize + 1 : 1;
                }
                break;
            }
            default: {
                return 0;
            }
        }
        return rating;
    }

    private boolean attemptArcAssignment(Arc arc, SearchDirection direction) {
        this.pushSearchStack();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Attempting move - Direction[" + (Object)((Object)direction) + "], Arc[" + arc + "]"));
            }
            arc.setRequirement(direction != SearchDirection.LEFT);
            this.propagate();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Move succeeded - State after move");
                this.dumpStateToLog();
            }
            return true;
        }
        catch (ConsistencyException cx) {
            logger.debug((Object)"Move failed");
            this.popSearchStack();
            return false;
        }
    }

    private void pushSearchStack() {
        if (this.searchStack == null) {
            this.searchStack = new LinkedList();
        }
        this.searchStack.add(new ArrayList());
    }

    private void popSearchStack() {
        List<GraphElement> alteredElements = this.searchStack.removeLast();
        for (GraphElement element : alteredElements) {
            element.clearRequirement();
        }
    }

    private void resetSearchStack() {
        while (this.searchStack.size() > 0) {
            this.popSearchStack();
        }
    }

    private void propagate() throws ConsistencyException {
        logger.debug((Object)"Beginning propagation");
        for (Node n : this.nodes) {
            n.prune();
        }
        while (this.basicNodeQueue.size() > 0 || this.extendedNodeQueue.size() > 0) {
            List<Arc> sourceArcs;
            Node source;
            if (this.basicNodeQueue.size() > 0) {
                source = (Node)this.basicNodeQueue.remove();
                if (!source.isRequirementKnown()) continue;
                sourceArcs = source.getArcs();
                for (Arc arc : sourceArcs) {
                    Node target;
                    Node node = target = arc.getLeft() == source ? arc.getRight() : arc.getLeft();
                    if (!source.isNotRequired()) continue;
                    arc.setRequirement(false);
                    target.prune();
                }
                continue;
            }
            source = (Node)this.extendedNodeQueue.remove();
            sourceArcs = source.getArcs();
            for (Arc arc : sourceArcs) {
                arc.propagate(source);
            }
        }
        LinkedList<Node> requiredNodes = new LinkedList<Node>();
        for (Node n : this.nodes) {
            if (!n.isRequired()) continue;
            requiredNodes.add(n);
        }
        if (requiredNodes.size() > 1) {
            LinkedList<Node> targetList = new LinkedList<Node>(requiredNodes);
            Node start = (Node)requiredNodes.remove(0);
            if (!start.canReachAllNodes(targetList)) {
                logger.debug((Object)"Arc propagation completed, but not all targets could be reached from first node");
                throw new ConsistencyException(start);
            }
        }
        logger.debug((Object)"Propagation completed successfully");
    }

    @Override
    public void graphElementChanged(GraphElement element) {
        List<GraphElement> searchDelta;
        List<GraphElement> list = searchDelta = this.searchStack != null && this.searchStack.size() > 0 ? this.searchStack.getLast() : null;
        if (searchDelta != null) {
            searchDelta.add(element);
        }
        if (element instanceof Node) {
            Node n = (Node)element;
            this.basicNodeQueue.add(n);
            if (n.getArcs().size() > 1) {
                this.extendedNodeQueue.add(n);
            }
        }
    }

    private void build(List<LogicalRelationship> relationships) {
        for (LogicalRelationship relationship : relationships) {
            Node left = this.getNodeForTable(relationship.getFromTable());
            Node right = this.getNodeForTable(relationship.getToTable());
            Arc arc = this.createArc(left, right, relationship);
        }
    }

    private Node getNodeForTable(LogicalTable table) {
        Node n = this.tableNodeMap.get(table);
        if (n == null) {
            n = new Node(this.nodes.size(), table, this);
            this.nodes.add(n);
            this.tableNodeMap.put(table, n);
        }
        return n;
    }

    private Arc createArc(Node left, Node right, LogicalRelationship relationship) {
        Arc arc = new Arc(left, right, relationship, this);
        this.arcs.add(arc);
        logger.trace((Object)("Created " + arc));
        left.addArc(arc);
        right.addArc(arc);
        return arc;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Solution {
        private int rating;
        private List<SearchDirection> searchPath;
        private List<Arc> searchArcs;
        private List<Boolean> solutionValues;
        private boolean partial;

        Solution(List<Arc> arcs, int rating, List<SearchDirection> searchPath, List<Arc> searchArcs, boolean partial) {
            this.rating = rating;
            this.searchPath = searchPath;
            this.searchArcs = searchArcs;
            this.partial = partial;
            this.solutionValues = new LinkedList<Boolean>();
            for (Arc a : arcs) {
                this.solutionValues.add(a.isRequired());
            }
        }

        public int getRating() {
            return this.rating;
        }

        public List<Boolean> getSolutionValues() {
            return this.solutionValues;
        }

        public List<SearchDirection> getSearchPath() {
            return this.searchPath;
        }

        public List<Arc> getSearchArcs() {
            return this.searchArcs;
        }

        public boolean isPartial() {
            return this.partial;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SearchDirection {
        LEFT,
        RIGHT;

    }
}

