/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.query.model.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.steps.textfileinput.TextFileInput;
import org.pentaho.metadata.messages.Messages;
import org.pentaho.metadata.query.model.util.QueryXmlHelper;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvDataReader {
    private static final Log logger = LogFactory.getLog(QueryXmlHelper.class);
    private static int DEFAULT_ROW_LIMIT = 5;
    private static String DEFAULT_DELIMETER = ",";
    private static String DEFAULT_ENCLOSURE = "/";
    private String fileLocation;
    private boolean headerPresent;
    private String enclosure;
    private String delimiter;
    private int rowLimit;
    private List<String> header;
    private List<List<String>> data;
    private int columnCount;

    public CsvDataReader(String fileLocation, boolean headerPresent, String delimiter, String enclosure, int rowLimit) {
        this.fileLocation = fileLocation;
        this.headerPresent = headerPresent;
        this.delimiter = delimiter;
        this.enclosure = enclosure;
        this.rowLimit = rowLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> loadData() {
        String line = null;
        ArrayList<List<String>> dataSample = new ArrayList<List<String>>(this.rowLimit);
        InputStreamReader reader = null;
        try {
            InputStream inputStream = KettleVFS.getInputStream((String)this.fileLocation);
            reader = new InputStreamReader(inputStream);
            StringBuilder stringBuilder = new StringBuilder(1000);
            line = TextFileInput.getLine(null, (InputStreamReader)reader, (int)2, (StringBuilder)stringBuilder);
            for (int row = 0; line != null && row < this.rowLimit; ++row) {
                CSVTokenizer csvt = new CSVTokenizer(line, this.delimiter, this.enclosure, false);
                ArrayList<String> rowData = new ArrayList<String>();
                int count = 0;
                while (csvt.hasMoreTokens()) {
                    rowData.add(csvt.nextToken());
                    ++count;
                }
                if (this.columnCount < count) {
                    this.columnCount = count;
                }
                if (this.headerPresent && row == 0) {
                    this.header = rowData;
                } else {
                    dataSample.add(rowData);
                }
                line = TextFileInput.getLine(null, (InputStreamReader)reader, (int)2, (StringBuilder)stringBuilder);
            }
        }
        catch (Exception e) {
            logger.error((Object)Messages.getString("CsvDataReader.ERROR_0001_Failed", new Object[0]), (Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
        this.data = dataSample;
        return dataSample;
    }

    public List<String> getHeader() {
        return this.header;
    }

    public List<String> getColumnData(int columnNumber) {
        ArrayList<String> dataSample = new ArrayList<String>(this.rowLimit);
        for (List<String> row : this.data) {
            if (row.size() <= columnNumber) continue;
            dataSample.add(row.get(columnNumber));
        }
        return dataSample;
    }

    public int getColumnCount() {
        return this.columnCount;
    }
}

