/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.query.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.query.model.util.DataTypeDetector;
import org.pentaho.metadata.query.model.util.FormatterHits;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvDataTypeEvaluator {
    List<String> columnValues;

    public CsvDataTypeEvaluator() {
    }

    public CsvDataTypeEvaluator(List<String> columnValues) {
        this.columnValues = columnValues;
    }

    public DataType evaluateDataType(List<String> columnValues) {
        CountItemsList<DataType> columnTypes = new CountItemsList<DataType>();
        for (String value : columnValues) {
            DataType type = DataTypeDetector.getDataType(value);
            if (type == DataType.STRING) {
                return DataType.STRING;
            }
            columnTypes.add(type);
        }
        return (DataType)((Object)columnTypes.getItemOfMaxCount());
    }

    public List<String> getColumnValues() {
        return this.columnValues;
    }

    public void setColumnValues(List<String> columnValues) {
        this.columnValues = columnValues;
    }

    public static String getBestDateFormat(List<String> dateSamples) {
        String[] formats = DataTypeDetector.COMMON_DATE_FORMATS;
        ArrayList<FormatterHits> formatters = new ArrayList<FormatterHits>(formats.length);
        for (String format : formats) {
            formatters.add(new FormatterHits(format));
        }
        for (String sample : dateSamples) {
            for (FormatterHits fh : formatters) {
                try {
                    fh.getFormatter().parseDateTime(sample);
                    fh.increment();
                }
                catch (IllegalArgumentException e) {}
            }
        }
        Collections.sort(formatters);
        if (((FormatterHits)formatters.get(0)).getHits() > 0) {
            return ((FormatterHits)formatters.get(0)).getFormat();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CountItemsList<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = 1923899528642995386L;
        private Map<E, Integer> count = new HashMap<E, Integer>();

        private CountItemsList() {
        }

        @Override
        public boolean add(E element) {
            if (!this.count.containsKey(element)) {
                this.count.put(element, 1);
            } else {
                this.count.put(element, this.count.get(element) + 1);
            }
            return super.add(element);
        }

        public int getCount(E element) {
            if (!this.count.containsKey(element)) {
                return 0;
            }
            return this.count.get(element);
        }

        public E getItemOfMaxCount() {
            E returnElement = null;
            Integer currentMax = -1;
            Set<Map.Entry<E, Integer>> countEntrySet = this.count.entrySet();
            for (Map.Entry<E, Integer> entry : this.count.entrySet()) {
                if (entry.getValue() <= currentMax) continue;
                currentMax = entry.getValue();
                returnElement = entry.getKey();
            }
            return returnElement;
        }
    }
}

