/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.pentaho.metadata.registry.Entity;
import org.pentaho.metadata.registry.Link;
import org.pentaho.metadata.registry.SimpleRegistry;

public class SimpleFileRegistry
extends SimpleRegistry {
    private String filePath;

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    protected void load() throws InvalidPropertiesFormatException, IOException {
        this.clear();
        File file = new File(this.filePath);
        if (file.exists()) {
            FileInputStream in = new FileInputStream(file);
            Properties props = new Properties();
            props.loadFromXML(in);
            int idx = 0;
            ArrayList<Link> links = new ArrayList<Link>();
            while (true) {
                String sub = (String)props.get("link-" + idx + "-subId");
                String subType = (String)props.get("link-" + idx + "-subType");
                String obj = (String)props.get("link-" + idx + "-objId");
                String objType = (String)props.get("link-" + idx + "-objType");
                String verb = (String)props.get("link-" + idx + "-verb");
                if (sub == null || obj == null || verb == null) break;
                Link link = new Link(sub, subType, verb, obj, objType);
                links.add(link);
                ++idx;
            }
            this.setLinks(links);
            idx = 0;
            while (true) {
                String id = (String)props.get("entity-" + idx + "-id");
                String title = (String)props.get("entity-" + idx + "-title");
                String typeId = (String)props.get("entity-" + idx + "-type");
                if (id == null || typeId == null) break;
                Entity entity = new Entity(id, title, typeId);
                this.addEntity(entity);
                int idx2 = 0;
                while (true) {
                    String key = (String)props.get("entity-" + idx + "-attrkey-" + idx2);
                    String value = (String)props.get("entity-" + idx + "-attrvalue-" + idx2);
                    if (key == null || value == null) break;
                    entity.setAttribute(key, StringEscapeUtils.unescapeJava((String)value));
                    ++idx2;
                }
                ++idx;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws Exception {
        List<Link> links = this.getLinks();
        Properties props = new Properties();
        int idx = 0;
        for (Link link : links) {
            props.put("link-" + idx + "-subId", link.getSubjectId());
            props.put("link-" + idx + "-subType", link.getSubjectTypeId());
            props.put("link-" + idx + "-verb", link.getVerbId());
            props.put("link-" + idx + "-objId", link.getObjectId());
            props.put("link-" + idx + "-objType", link.getObjectTypeId());
            ++idx;
        }
        idx = 0;
        Map<String, Map<String, Entity>> entities = this.getEntities();
        for (Map.Entry<String, Map<String, Entity>> entry : entities.entrySet()) {
            Map<String, Entity> typeMap = entry.getValue();
            Set<Map.Entry<String, Entity>> typeSet = typeMap.entrySet();
            for (Map.Entry<String, Entity> typeEntry : typeSet) {
                Entity entity = typeEntry.getValue();
                props.put("entity-" + idx + "-id", entity.getId());
                props.put("entity-" + idx + "-type", entity.getTypeId());
                if (entity.getTitle() != null) {
                    props.put("entity-" + idx + "-title", entity.getTitle());
                } else {
                    props.put("entity-" + idx + "-title", entity.getId());
                }
                Map<String, String> attrMap = entity.getAttributes();
                int idx2 = 0;
                for (Map.Entry<String, String> attrEntry : attrMap.entrySet()) {
                    String key = attrEntry.getKey();
                    String value = attrEntry.getValue();
                    props.put("entity-" + idx + "-attrkey-" + idx2, key);
                    props.put("entity-" + idx + "-attrvalue-" + idx2, StringEscapeUtils.escapeJava((String)value));
                    ++idx2;
                }
                ++idx;
            }
        }
        File file = new File(this.filePath);
        FileOutputStream out = new FileOutputStream(file);
        try {
            props.storeToXML(out, null);
        }
        finally {
            ((OutputStream)out).close();
        }
    }
}

