/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pentaho.metadata.registry.Entity;
import org.pentaho.metadata.registry.Link;
import org.pentaho.metadata.registry.Namespace;
import org.pentaho.metadata.registry.RegistryBase;
import org.pentaho.metadata.registry.Type;
import org.pentaho.metadata.registry.TypeLink;
import org.pentaho.metadata.registry.Verb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleRegistry
extends RegistryBase {
    private List<Namespace> namespaces = new ArrayList<Namespace>();
    private List<Type> types = new ArrayList<Type>();
    private Map<String, Map<String, Entity>> entities = new HashMap<String, Map<String, Entity>>();
    private List<Verb> verbs = new ArrayList<Verb>();
    private List<Link> links = new ArrayList<Link>();
    private List<TypeLink> typeLinks = new ArrayList<TypeLink>();

    protected abstract void load() throws Exception;

    @Override
    public void init() throws Exception {
        this.namespaces = new ArrayList<Namespace>();
        this.types = new ArrayList<Type>();
        this.entities = new HashMap<String, Map<String, Entity>>();
        this.verbs = new ArrayList<Verb>();
        this.links = new ArrayList<Link>();
        this.typeLinks = new ArrayList<TypeLink>();
        super.init();
        this.load();
    }

    protected Map<String, Map<String, Entity>> getEntities() {
        return this.entities;
    }

    protected void setEntities(Map<String, Map<String, Entity>> entities) {
        this.entities = entities;
    }

    @Override
    public void clear() {
        this.entities = new HashMap<String, Map<String, Entity>>();
        this.links = new ArrayList<Link>();
    }

    @Override
    public List<Entity> getEntitiesOfType(String typeId, String match, boolean exactMatch) {
        ArrayList<Entity> results = new ArrayList<Entity>();
        for (Map.Entry<String, Map<String, Entity>> entry : this.entities.entrySet()) {
            Map<String, Entity> typeMap = entry.getValue();
            Entity entity = typeMap.get(typeId);
            if (entity == null) continue;
            if (match == null) {
                results.add(entity);
                continue;
            }
            if (exactMatch && entity.getId().equals(match)) {
                results.add(entity);
                continue;
            }
            if (!entity.getId().contains(match)) continue;
            results.add(entity);
        }
        return results;
    }

    @Override
    public List<Link> findObjectLinks(String subjectId, Set<String> verbIds, Set<String> typeIds) {
        ArrayList<Link> results = new ArrayList<Link>();
        for (Link link : this.links) {
            if (!link.getSubjectId().equalsIgnoreCase(subjectId) || verbIds != null && !verbIds.contains(link.getVerbId()) || typeIds != null && !typeIds.contains(link.getObjectTypeId())) continue;
            results.add(link);
        }
        return results;
    }

    @Override
    public List<Link> findSubjectLinks(String objectId, Set<String> verbIds, Set<String> typeIds) {
        ArrayList<Link> results = new ArrayList<Link>();
        for (Link link : this.links) {
            if (!link.getObjectId().equalsIgnoreCase(objectId) || verbIds != null && !verbIds.contains(link.getVerbId()) || typeIds != null && !typeIds.contains(link.getSubjectTypeId())) continue;
            results.add(link);
        }
        return results;
    }

    @Override
    public List<Link> findDirectLinks(String entityId, Set<String> typeIds) {
        List<Link> results = this.findObjectLinks(entityId, null, typeIds);
        List<Link> results2 = this.findSubjectLinks(entityId, null, typeIds);
        for (Link link : results2) {
            results.add(link);
        }
        return results;
    }

    @Override
    public List<Entity> findAllLinkedEntities(String entityId, Set<String> typeIds) {
        ArrayList<Entity> found = new ArrayList<Entity>();
        HashSet<String> foundIds = new HashSet<String>();
        List<Link> targets = this.findDirectLinks(entityId, (String)null);
        HashSet<String> done = new HashSet<String>();
        done.add(entityId);
        foundIds.add(entityId);
        this.findAllLinks(typeIds, found, foundIds, targets, done);
        return found;
    }

    protected void findAllLinks(Set<String> typeIds, List<Entity> found, Set<String> foundIds, List<Link> targets, Set<String> done) {
        for (Link target : targets) {
            done.add(target.getObjectId());
            done.add(target.getSubjectId());
            if (!foundIds.contains(target.getObjectId()) && (typeIds == null || typeIds.contains(target.getObjectTypeId()))) {
                found.add(this.getEntity(target.getObjectId(), target.getObjectTypeId()));
                foundIds.add(target.getObjectId());
            }
            if (foundIds.contains(target.getSubjectId()) || typeIds != null && !typeIds.contains(target.getSubjectTypeId())) continue;
            found.add(this.getEntity(target.getSubjectId(), target.getSubjectTypeId()));
            foundIds.add(target.getSubjectId());
        }
        ArrayList<Link> newTargets = new ArrayList<Link>();
        for (Link target : targets) {
            List<Link> results = this.findDirectLinks(target.getObjectId(), (String)null);
            for (Link link : results) {
                if (done.contains(link.getObjectId()) && done.contains(link.getSubjectId())) continue;
                newTargets.add(link);
            }
            results = this.findDirectLinks(target.getSubjectId(), (String)null);
            for (Link link : results) {
                if (done.contains(link.getObjectId()) && done.contains(link.getSubjectId())) continue;
                newTargets.add(link);
            }
        }
        if (newTargets.size() == 0) {
            return;
        }
        this.findAllLinks(typeIds, found, foundIds, newTargets, done);
    }

    @Override
    public void addLink(Link link) {
        this.links.add(link);
    }

    @Override
    public boolean removeLink(Link link) {
        if (this.links.contains(link)) {
            this.links.remove(link);
            return true;
        }
        return false;
    }

    @Override
    public List<Link> getLinks() {
        return this.links;
    }

    protected void setLinks(List<Link> links) {
        this.links = links;
    }

    @Override
    public List<Verb> getVerbs() {
        return this.verbs;
    }

    @Override
    public void setVerbs(List<Verb> verbs) {
        this.verbs = verbs;
    }

    @Override
    public List<Namespace> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public void addNamespace(Namespace namespace) {
        this.namespaces.add(namespace);
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void setTypes(List<Type> types) {
        this.types = types;
    }

    @Override
    public void setNamespaces(List<Namespace> namespaces) {
        this.namespaces = namespaces;
    }

    @Override
    public void addType(Type type) {
        this.types.add(type);
    }

    @Override
    public void addEntity(Entity entity) {
        Map<String, Entity> typeMap = this.entities.get(entity.getId());
        if (typeMap == null) {
            typeMap = new HashMap<String, Entity>();
            this.entities.put(entity.getId(), typeMap);
        }
        typeMap.put(entity.getTypeId(), entity);
    }

    @Override
    public boolean removeEntity(Entity entity) {
        Map<String, Entity> typeMap = this.entities.get(entity.getId());
        if (typeMap == null || typeMap.get(entity.getTypeId()) == null) {
            return false;
        }
        typeMap.remove(entity.getTypeId());
        if (typeMap.size() == 0) {
            this.entities.remove(entity.getId());
        }
        return true;
    }

    @Override
    public Entity getEntity(String id, String typeId) {
        Map<String, Entity> typeMap = this.entities.get(id);
        if (typeMap == null) {
            return null;
        }
        return typeMap.get(typeId);
    }

    @Override
    public List<Entity> getEntities(String id) {
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        Map<String, Entity> typeMap = this.entities.get(id);
        if (typeMap != null) {
            Set<Map.Entry<String, Entity>> entries = typeMap.entrySet();
            for (Map.Entry<String, Entity> entry : entries) {
                Entity entity = entry.getValue();
                entityList.add(entity);
            }
        }
        return entityList;
    }

    @Override
    public void addVerb(Verb verb) {
        this.verbs.add(verb);
    }

    @Override
    public void addTypeLink(TypeLink link) {
        this.typeLinks.add(link);
    }

    @Override
    public List<TypeLink> getTypeLinks() {
        return this.typeLinks;
    }
}

