/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.util;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Props;
import org.pentaho.metadata.messages.LocaleHelper;
import org.pentaho.metadata.model.Category;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.InlineEtlPhysicalColumn;
import org.pentaho.metadata.model.InlineEtlPhysicalModel;
import org.pentaho.metadata.model.InlineEtlPhysicalTable;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.concept.Concept;
import org.pentaho.metadata.model.concept.security.Security;
import org.pentaho.metadata.model.concept.security.SecurityOwner;
import org.pentaho.metadata.model.concept.types.LocaleType;
import org.pentaho.metadata.model.concept.types.LocalizedString;
import org.pentaho.metadata.query.model.util.CsvDataReader;
import org.pentaho.metadata.query.model.util.CsvDataTypeEvaluator;
import org.pentaho.pms.util.Settings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InlineEtlModelGenerator {
    public static final int ROW_LIMIT = 5;
    private String modelName;
    private String fileLocation;
    private String fileName;
    private boolean headerPresent;
    private String delimiter;
    private String enclosure;
    boolean securityEnabled;
    int defaultAcls;
    List<String> users;
    List<String> roles;
    String createdBy;

    public InlineEtlModelGenerator() {
        if (!Props.isInitialized()) {
            Props.init((int)0);
        }
    }

    public InlineEtlModelGenerator(String modelName, String fileLocation, String fileName, boolean headerPresent, String delimiter, String enclosure, boolean securityEnabled, List<String> users, List<String> roles, int defaultAcls, String createdBy) {
        this();
        this.modelName = modelName;
        this.fileLocation = fileLocation;
        this.fileName = fileName;
        this.headerPresent = headerPresent;
        this.delimiter = delimiter;
        this.enclosure = enclosure;
        this.securityEnabled = securityEnabled;
        this.users = users;
        this.roles = roles;
        this.createdBy = createdBy;
        this.defaultAcls = defaultAcls;
    }

    public Domain generate() throws Exception {
        return this.generate(this.modelName, this.fileLocation, this.fileName, this.headerPresent, this.delimiter, this.enclosure, this.securityEnabled, this.users, this.roles, this.defaultAcls, this.createdBy);
    }

    public Domain generate(String modelName, String fileLocation, String fileName, boolean headerPresent, String delimiter, String enclosure, boolean securityEnabled, List<String> users, List<String> roles, int defaultAcls, String createdBy) throws Exception {
        int i;
        CsvDataReader csvDataReader = new CsvDataReader(fileLocation + fileName, headerPresent, delimiter, enclosure, 5);
        CsvDataTypeEvaluator dataTypeConverter = new CsvDataTypeEvaluator();
        csvDataReader.loadData();
        String[] fieldNames = new String[csvDataReader.getColumnCount()];
        DecimalFormat df = new DecimalFormat("000");
        for (i = 0; i < fieldNames.length; ++i) {
            fieldNames[i] = "Field_" + df.format(i);
        }
        if (headerPresent) {
            for (i = 0; i < csvDataReader.getHeader().size(); ++i) {
                fieldNames[i] = csvDataReader.getHeader().get(i);
            }
        }
        LocaleType locale = new LocaleType(LocaleHelper.getLocale().toString(), LocaleHelper.getLocale().getDisplayName());
        InlineEtlPhysicalModel model = new InlineEtlPhysicalModel();
        String modelID = Settings.getBusinessModelIDPrefix() + modelName;
        model.setId(modelID);
        model.setName(new LocalizedString(locale.getCode(), modelName));
        model.setFileLocation(fileName);
        model.setHeaderPresent(headerPresent);
        model.setEnclosure(enclosure);
        model.setDelimiter(delimiter);
        InlineEtlPhysicalTable table = new InlineEtlPhysicalTable(model);
        table.setId("INLINE_ETL_1");
        model.getPhysicalTables().add(table);
        LogicalModel logicalModel = new LogicalModel();
        logicalModel.setPhysicalModel(model);
        logicalModel.setId("MODEL_1");
        logicalModel.setName(new LocalizedString(locale.getCode(), modelName));
        Category mainCategory = new Category(logicalModel);
        String categoryID = Settings.getBusinessCategoryIDPrefix() + modelName;
        mainCategory.setId(categoryID);
        mainCategory.setName(new LocalizedString(locale.getCode(), modelName));
        LogicalTable logicalTable = new LogicalTable(logicalModel, table);
        logicalTable.setId("LOGICAL_TABLE_1");
        for (int i2 = 0; i2 < fieldNames.length; ++i2) {
            fieldNames[i2] = Const.trim((String)fieldNames[i2]);
            InlineEtlPhysicalColumn column = new InlineEtlPhysicalColumn();
            column.setTable(table);
            column.setId("PC_" + i2);
            column.setFieldName(fieldNames[i2]);
            column.setName(new LocalizedString(locale.getCode(), fieldNames[i2]));
            column.setDataType(dataTypeConverter.evaluateDataType(csvDataReader.getColumnData(i2)));
            table.getPhysicalColumns().add(column);
            LogicalColumn logicalColumn = new LogicalColumn();
            String columnID = Settings.getBusinessColumnIDPrefix();
            logicalColumn.setId(columnID + i2 + "_" + fieldNames[i2].replaceAll("\\s", "_").replaceAll("[^A-Za-z0-9_]", ""));
            logicalColumn.setPhysicalColumn(column);
            logicalColumn.setLogicalTable(logicalTable);
            logicalTable.addLogicalColumn(logicalColumn);
            mainCategory.addLogicalColumn(logicalColumn);
        }
        logicalModel.getLogicalTables().add(logicalTable);
        logicalModel.getCategories().add(mainCategory);
        Domain domain = new Domain();
        domain.addPhysicalModel(model);
        if (this.getCreatedBy() != null) {
            domain.setProperty("created_by", createdBy);
        }
        if (this.isSecurityEnabled()) {
            SecurityOwner owner;
            Security security = new Security();
            for (String user : users) {
                owner = new SecurityOwner(SecurityOwner.OwnerType.USER, user);
                security.putOwnerRights(owner, defaultAcls);
            }
            for (String role : roles) {
                owner = new SecurityOwner(SecurityOwner.OwnerType.ROLE, role);
                security.putOwnerRights(owner, defaultAcls);
            }
            logicalModel.setProperty(Concept.SECURITY_PROPERTY, security);
        }
        ArrayList<LocaleType> locales = new ArrayList<LocaleType>();
        locales.add(locale);
        domain.setLocales(locales);
        domain.addLogicalModel(logicalModel);
        domain.setId(modelName);
        return domain;
    }

    public void setSecurityEnabled(boolean securityEnabled) {
        this.securityEnabled = securityEnabled;
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public void setUsers(List<String> users) {
        this.users = users;
    }

    public List<String> getUsers() {
        return this.users;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setDefaultAcls(int defaultAcls) {
        this.defaultAcls = defaultAcls;
    }

    public int getDefaultAcls() {
        return this.defaultAcls;
    }
}

