/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.metadata.messages.Messages;
import org.pentaho.metadata.model.concept.security.RowLevelSecurity;
import org.pentaho.metadata.model.concept.security.Security;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metadata.model.concept.types.Alignment;
import org.pentaho.metadata.model.concept.types.Color;
import org.pentaho.metadata.model.concept.types.ColumnWidth;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.model.concept.types.FieldType;
import org.pentaho.metadata.model.concept.types.Font;
import org.pentaho.metadata.model.concept.types.LocalizedString;
import org.pentaho.metadata.model.concept.types.TableType;
import org.pentaho.metadata.model.concept.types.TargetColumnType;
import org.pentaho.metadata.model.concept.types.TargetTableType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTypeRegistry {
    List<Class> propertyTypes = new ArrayList<Class>();
    Map<String, Class> propertyTypeMap = new HashMap<String, Class>();
    List<Class> unmodifiablePropertyTypes = Collections.unmodifiableList(this.propertyTypes);

    public PropertyTypeRegistry() {
        this.addPropertyType(String.class);
        this.addPropertyType(LocalizedString.class);
        this.addPropertyType(DataType.class);
        this.addPropertyType(TargetTableType.class);
        this.addPropertyType(TargetColumnType.class);
        this.addPropertyType(AggregationType.class);
        this.addPropertyType(List.class);
        this.addPropertyType(Alignment.class);
        this.addPropertyType(Color.class);
        this.addPropertyType(ColumnWidth.class);
        this.addPropertyType(FieldType.class);
        this.addPropertyType(Font.class);
        this.addPropertyType(TableType.class);
        this.addPropertyType(RowLevelSecurity.class);
        this.addPropertyType(Security.class);
        this.addPropertyType(Double.class);
        this.addPropertyType(Boolean.class);
        this.addPropertyType(Date.class);
        this.addPropertyType(URL.class);
    }

    public void addPropertyType(Class clazz) {
        this.propertyTypes.add(clazz);
        this.propertyTypeMap.put(clazz.getCanonicalName(), clazz);
    }

    public List<Class> getPropertyTypes() {
        return this.unmodifiablePropertyTypes;
    }

    public String getPropertyTypeDescription(Class clazz) {
        return Messages.getString("PropertyDescription." + clazz.getCanonicalName(), new Object[0]);
    }

    public Class getPropertyType(String type) {
        return this.propertyTypeMap.get(type);
    }
}

