/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.util;

import java.util.List;
import org.pentaho.metadata.model.Category;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.SqlPhysicalColumn;
import org.pentaho.metadata.model.SqlPhysicalTable;
import org.pentaho.metadata.model.concept.Concept;
import org.pentaho.metadata.model.concept.IConcept;
import org.pentaho.pms.util.Settings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final String CR = System.getProperty("line.separator");

    public static String getCategoryIdPrefix() {
        return "c_";
    }

    public static String getLogicalColumnIdPrefix() {
        return "lc_";
    }

    public static String getLogicalModelIdPrefix() {
        return "lm_";
    }

    public static String getPhysicalTableIdPrefix() {
        return "pt_";
    }

    public static String getPhysicalColumnIdPrefix() {
        return "pc_";
    }

    public static final String toId(String name) {
        if (name == null) {
            return name;
        }
        name = name.replaceAll("[ .,:(){}\\[\\]]", "_");
        name = name.replaceAll("[\"`']", "");
        name = name.replaceAll("[*]", "_TIMES_");
        name = name.replaceAll("[/]", "_DIVIDED_BY_");
        name = name.replaceAll("[+]", "_PLUS_");
        name = name.replaceAll("[-]", "_HYPHEN_");
        name = name.replaceAll("_+", "_");
        return name;
    }

    public static final String NVL(String source, String def) {
        if (source == null || source.length() == 0) {
            return def;
        }
        return source;
    }

    public static final String uniquify(String id, List<? extends IConcept> concepts) {
        boolean gotNew = false;
        boolean found = false;
        int conceptNr = 1;
        String newId = id;
        while (!gotNew) {
            for (IConcept iConcept : concepts) {
                if (!iConcept.getId().equalsIgnoreCase(newId)) continue;
                found = true;
                break;
            }
            if (found) {
                newId = id + "_" + ++conceptNr;
                found = false;
                continue;
            }
            gotNew = true;
        }
        return newId;
    }

    public static final String proposeSqlBasedLogicalTableId(String locale, LogicalTable businessTable, SqlPhysicalTable physicalTable) {
        String baseID = Util.toId(businessTable.getName(locale));
        String namePart = Util.toId(Util.NVL(physicalTable.getName(locale), physicalTable.getTargetTable()));
        String id = Settings.getBusinessTableIDPrefix() + baseID + "_" + namePart;
        if (Settings.isAnIdUppercase()) {
            id = id.toUpperCase();
        }
        return id;
    }

    public static final String proposeSqlBasedLogicalTableId(String locale, LogicalTable businessTable, SqlPhysicalTable physicalTable, List<LogicalTable> tables) {
        String id = Util.proposeSqlBasedLogicalTableId(locale, businessTable, physicalTable);
        return Util.proposeUnique(id, tables);
    }

    public static final String proposeSqlBasedLogicalColumnId(String locale, LogicalTable businessTable, SqlPhysicalColumn physicalColumn) {
        String baseID = Util.toId(businessTable.getName(locale));
        String namePart = Util.toId(Util.NVL(physicalColumn.getName(locale), physicalColumn.getTargetColumn()));
        String id = Util.getLogicalColumnIdPrefix() + baseID + "_" + namePart;
        return id.toUpperCase();
    }

    public static final String proposeSqlBasedLogicalColumnId(String locale, LogicalTable table, SqlPhysicalColumn physicalColumn, List<LogicalColumn> columns) {
        String id = Util.proposeSqlBasedLogicalColumnId(locale, table, physicalColumn);
        return Util.proposeUnique(id, columns);
    }

    private static final String proposeUnique(String id, List<? extends Concept> list) {
        boolean gotNew = false;
        boolean found = false;
        int num = 1;
        String newId = id;
        while (!gotNew) {
            for (Concept concept : list) {
                if (!concept.getId().equalsIgnoreCase(newId)) continue;
                found = true;
                break;
            }
            if (found) {
                newId = id + "_" + ++num;
                found = false;
                continue;
            }
            gotNew = true;
        }
        return newId;
    }

    public static final String proposeSqlBasedCategoryId(String locale, LogicalTable table, Category category) {
        String baseID = table != null ? Util.toId((String)table.getProperty("target_table")) : "";
        String namePart = category != null && category.getName(locale) != null ? "_" + Util.toId(category.getName(locale)) : "";
        String id = Util.getCategoryIdPrefix() + baseID + namePart;
        return id.toUpperCase();
    }

    public static final String proposeSqlBasedCategoryId(String locale, LogicalTable table, Category category, List<Category> categories) {
        String id = Util.proposeSqlBasedCategoryId(locale, table, category);
        return Util.proposeUnique(id, categories);
    }
}

