/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.factory;

import java.math.BigDecimal;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.pms.core.CWM;
import org.pentaho.pms.cwm.pentaho.meta.behavioral.CwmEvent;
import org.pentaho.pms.cwm.pentaho.meta.behavioral.CwmParameter;
import org.pentaho.pms.cwm.pentaho.meta.businessinformation.CwmDescription;
import org.pentaho.pms.cwm.pentaho.meta.core.CwmAttribute;
import org.pentaho.pms.cwm.pentaho.meta.core.CwmClass;
import org.pentaho.pms.cwm.pentaho.meta.core.CwmModelElement;
import org.pentaho.pms.cwm.pentaho.meta.core.CwmNamespace;
import org.pentaho.pms.cwm.pentaho.meta.core.CwmTaggedValue;
import org.pentaho.pms.cwm.pentaho.meta.instance.CwmExtent;
import org.pentaho.pms.cwm.pentaho.meta.keysindexes.CwmKeyRelationship;
import org.pentaho.pms.cwm.pentaho.meta.multidimensional.CwmDimension;
import org.pentaho.pms.cwm.pentaho.meta.multidimensional.CwmDimensionedObject;
import org.pentaho.pms.cwm.pentaho.meta.multidimensional.CwmSchema;
import org.pentaho.pms.cwm.pentaho.meta.olap.CwmCube;
import org.pentaho.pms.cwm.pentaho.meta.olap.CwmCubeDimensionAssociation;
import org.pentaho.pms.cwm.pentaho.meta.olap.CwmHierarchyLevelAssociation;
import org.pentaho.pms.cwm.pentaho.meta.olap.CwmLevel;
import org.pentaho.pms.cwm.pentaho.meta.olap.CwmLevelBasedHierarchy;
import org.pentaho.pms.cwm.pentaho.meta.olap.CwmMeasure;
import org.pentaho.pms.cwm.pentaho.meta.relational.CwmCatalog;
import org.pentaho.pms.cwm.pentaho.meta.relational.CwmColumn;
import org.pentaho.pms.cwm.pentaho.meta.relational.CwmTable;
import org.pentaho.pms.factory.CwmSchemaFactoryException;
import org.pentaho.pms.factory.CwmSchemaFactoryInterface;
import org.pentaho.pms.locale.LocaleInterface;
import org.pentaho.pms.locale.LocaleMeta;
import org.pentaho.pms.locale.Locales;
import org.pentaho.pms.messages.Messages;
import org.pentaho.pms.schema.BusinessCategory;
import org.pentaho.pms.schema.BusinessColumn;
import org.pentaho.pms.schema.BusinessModel;
import org.pentaho.pms.schema.BusinessTable;
import org.pentaho.pms.schema.PhysicalColumn;
import org.pentaho.pms.schema.PhysicalTable;
import org.pentaho.pms.schema.RelationshipMeta;
import org.pentaho.pms.schema.SchemaMeta;
import org.pentaho.pms.schema.concept.Concept;
import org.pentaho.pms.schema.concept.ConceptInterface;
import org.pentaho.pms.schema.concept.ConceptPropertyInterface;
import org.pentaho.pms.schema.concept.ConceptUtilityBase;
import org.pentaho.pms.schema.concept.ConceptUtilityInterface;
import org.pentaho.pms.schema.concept.types.ConceptPropertyBase;
import org.pentaho.pms.schema.concept.types.ConceptPropertyType;
import org.pentaho.pms.schema.concept.types.aggregation.AggregationSettings;
import org.pentaho.pms.schema.concept.types.aggregation.ConceptPropertyAggregation;
import org.pentaho.pms.schema.concept.types.aggregation.ConceptPropertyAggregationList;
import org.pentaho.pms.schema.concept.types.alignment.AlignmentSettings;
import org.pentaho.pms.schema.concept.types.alignment.ConceptPropertyAlignment;
import org.pentaho.pms.schema.concept.types.bool.ConceptPropertyBoolean;
import org.pentaho.pms.schema.concept.types.color.ColorSettings;
import org.pentaho.pms.schema.concept.types.color.ConceptPropertyColor;
import org.pentaho.pms.schema.concept.types.columnwidth.ColumnWidth;
import org.pentaho.pms.schema.concept.types.columnwidth.ConceptPropertyColumnWidth;
import org.pentaho.pms.schema.concept.types.datatype.ConceptPropertyDataType;
import org.pentaho.pms.schema.concept.types.datatype.DataTypeSettings;
import org.pentaho.pms.schema.concept.types.date.ConceptPropertyDate;
import org.pentaho.pms.schema.concept.types.fieldtype.ConceptPropertyFieldType;
import org.pentaho.pms.schema.concept.types.fieldtype.FieldTypeSettings;
import org.pentaho.pms.schema.concept.types.font.ConceptPropertyFont;
import org.pentaho.pms.schema.concept.types.font.FontSettings;
import org.pentaho.pms.schema.concept.types.localstring.LocalizedStringSettings;
import org.pentaho.pms.schema.concept.types.number.ConceptPropertyNumber;
import org.pentaho.pms.schema.concept.types.rowlevelsecurity.ConceptPropertyRowLevelSecurity;
import org.pentaho.pms.schema.concept.types.security.ConceptPropertySecurity;
import org.pentaho.pms.schema.concept.types.string.ConceptPropertyString;
import org.pentaho.pms.schema.concept.types.tabletype.ConceptPropertyTableType;
import org.pentaho.pms.schema.concept.types.tabletype.TableTypeSettings;
import org.pentaho.pms.schema.concept.types.url.ConceptPropertyURL;
import org.pentaho.pms.schema.olap.OlapCube;
import org.pentaho.pms.schema.olap.OlapDimension;
import org.pentaho.pms.schema.olap.OlapDimensionUsage;
import org.pentaho.pms.schema.olap.OlapHierarchy;
import org.pentaho.pms.schema.olap.OlapHierarchyLevel;
import org.pentaho.pms.schema.olap.OlapMeasure;
import org.pentaho.pms.schema.security.RowLevelSecurity;
import org.pentaho.pms.schema.security.Security;
import org.pentaho.pms.schema.security.SecurityReference;
import org.pentaho.pms.schema.security.SecurityService;
import org.pentaho.pms.util.Const;
import org.pentaho.pms.util.ObjectAlreadyExistsException;

public class CwmSchemaFactory
implements CwmSchemaFactoryInterface {
    private static final Log logger = LogFactory.getLog(CwmSchemaFactory.class);

    public void storeSchemaMeta(CWM cwm, SchemaMeta schemaMeta) throws Exception {
        this.storeSchemaMeta(cwm, schemaMeta, null);
    }

    public void storeSchemaMeta(CWM cwm, SchemaMeta schemaMeta, ProgressMonitorListener monitor) throws Exception {
        if (!this.hasAccess(5, null)) {
            throw new CwmSchemaFactoryException(Messages.getString("CwmSchemaFactory.ERROR_0001_SCHEMA_ADMIN_ACCESS_DENIED"));
        }
        try {
            int i;
            cwm.beginTransaction();
            if (monitor != null) {
                monitor.subTask(Messages.getString("CwmSchemaFactory.INFO_STORING_SECURITY_INFO"));
            }
            this.storeSecurityService(cwm, schemaMeta.getSecurityReference().getSecurityService());
            if (monitor != null) {
                monitor.worked(1);
            }
            if (monitor != null) {
                monitor.subTask(Messages.getString("CwmSchemaFactory.INFO_STORING_DATABASES"));
            }
            for (i = 0; i < schemaMeta.nrDatabases(); ++i) {
                DatabaseMeta databaseMeta = schemaMeta.getDatabase(i);
                this.storeDatabaseMeta(cwm, databaseMeta);
                if (monitor == null) continue;
                monitor.worked(1);
            }
            if (monitor != null) {
                monitor.subTask(Messages.getString("CwmSchemaFactory.INFO_STORING_CONCEPTS"));
            }
            for (i = 0; i < schemaMeta.nrConcepts(); ++i) {
                ConceptInterface concept = schemaMeta.getConcept(i);
                this.storeModelConcept(cwm, concept);
                if (monitor == null) continue;
                monitor.worked(1);
            }
            if (monitor != null) {
                monitor.subTask(Messages.getString("CwmSchemaFactory.INFO_STORING_PHYSICAL_TABLES"));
            }
            for (i = 0; i < schemaMeta.nrTables(); ++i) {
                PhysicalTable physicalTable = schemaMeta.getTable(i);
                this.storePhysicalTable(cwm, physicalTable);
                if (monitor == null) continue;
                monitor.worked(1);
            }
            if (monitor != null) {
                monitor.subTask(Messages.getString("CwmSchemaFactory.INFO_STORING_BUSINESS_MODELS"));
            }
            for (i = 0; i < schemaMeta.nrBusinessModels(); ++i) {
                BusinessModel businessModel = schemaMeta.getModel(i);
                this.storeBusinessModel(cwm, businessModel);
                if (monitor == null) continue;
                monitor.worked(1);
            }
            if (monitor != null) {
                monitor.subTask(Messages.getString("CwmSchemaFactory.INFO_STORING_LOCALES"));
            }
            Locales locales = schemaMeta.getLocales();
            for (int i2 = 0; i2 < locales.nrLocales(); ++i2) {
                LocaleInterface locale = locales.getLocale(i2);
                this.storeLocale(cwm, locale);
                if (monitor == null) continue;
                monitor.worked(1);
            }
            cwm.endTransaction();
            if (monitor != null) {
                monitor.subTask(Messages.getString("CwmSchemaFactory.INFO_FINISHED"));
            }
        }
        catch (Exception e) {
            cwm.rollback();
            throw e;
        }
    }

    public SchemaMeta getSchemaMeta(CWM cwm) {
        SecurityReference securityReference;
        SchemaMeta schemaMeta = new SchemaMeta();
        SecurityService securityService = this.getSecurityService(cwm);
        try {
            securityReference = new SecurityReference(securityService);
        }
        catch (Exception e) {
            securityReference = new SecurityReference();
            securityReference.setSecurityService(securityService);
        }
        schemaMeta.setSecurityReference(securityReference);
        schemaMeta.setDomainName(cwm.getDomainName());
        CwmCatalog[] catalogs = cwm.getCatalogs();
        for (int i = 0; i < catalogs.length; ++i) {
            CwmCatalog catalog = catalogs[i];
            DatabaseMeta databaseMeta = this.getDatabaseMeta(cwm, catalog);
            try {
                schemaMeta.addDatabase(databaseMeta);
                continue;
            }
            catch (ObjectAlreadyExistsException e) {
                // empty catch block
            }
        }
        CwmClass[] cwmClasses = cwm.getClasses();
        for (int repeat = 0; repeat < 2; ++repeat) {
            for (int i = 0; i < cwmClasses.length; ++i) {
                CwmClass cwmClass = cwmClasses[i];
                ConceptInterface concept = this.getModelConcept(cwm, cwmClass, schemaMeta);
                ConceptInterface verify = schemaMeta.findConcept(concept.getName());
                if (verify == null) {
                    try {
                        schemaMeta.addConcept(concept);
                    }
                    catch (ObjectAlreadyExistsException e) {}
                    continue;
                }
                verify.setParentInterface(concept.getParentInterface());
            }
        }
        CwmTable[] cwmTables = cwm.getTables();
        for (int i = 0; i < cwmTables.length; ++i) {
            CwmTable cwmTable = cwmTables[i];
            PhysicalTable physicalTable = this.getPhysicalTable(cwm, cwmTable, schemaMeta);
            try {
                schemaMeta.addTable(physicalTable);
                continue;
            }
            catch (ObjectAlreadyExistsException e) {
                // empty catch block
            }
        }
        CwmSchema[] cwmSchemas = cwm.getSchemas();
        for (int i = 0; i < cwmSchemas.length; ++i) {
            CwmSchema cwmSchema = cwmSchemas[i];
            BusinessModel businessModel = this.getBusinessModel(cwm, cwmSchema, schemaMeta);
            if (!this.hasAccess(0, businessModel)) continue;
            try {
                schemaMeta.addModel(businessModel);
                continue;
            }
            catch (ObjectAlreadyExistsException e) {
                // empty catch block
            }
        }
        CwmParameter[] cwmParameters = cwm.getParameters();
        Locales locales = schemaMeta.getLocales();
        locales.getLocaleList().clear();
        for (int i = 0; i < cwmParameters.length; ++i) {
            CwmParameter cwmParameter = cwmParameters[i];
            LocaleInterface locale = this.getLocale(cwm, cwmParameter);
            locales.addLocale(locale);
        }
        locales.sortLocales();
        schemaMeta.clearChanged();
        if (schemaMeta.nrBusinessModels() == 1) {
            schemaMeta.setActiveModel(schemaMeta.getModel(0));
        }
        if (cwm.isReversingOrder()) {
            Collections.reverse(schemaMeta.getTables().getList());
            Collections.reverse(schemaMeta.getBusinessModels().getList());
            Collections.reverse(schemaMeta.getConcepts().getList());
        }
        return schemaMeta;
    }

    public void storeSecurityService(CWM cwm, SecurityService securityService) {
        if (!this.hasAccess(5, null)) {
            throw new CwmSchemaFactoryException(Messages.getString("CwmSchemaFactory.ERROR_0001_SCHEMA_ADMIN_ACCESS_DENIED"));
        }
        CwmEvent cwmEvent = cwm.createEvent("SECURITY_SERVICE");
        cwm.addTaggedValue((CwmModelElement)cwmEvent, "SECURITY_SERVICE_URL", securityService.getServiceURL());
        cwm.addTaggedValue((CwmModelElement)cwmEvent, "SECURITY_DETAILS_NAME", securityService.getServiceName());
        cwm.addTaggedValue((CwmModelElement)cwmEvent, "SECURITY_DETAIL_NAME", securityService.getDetailNameParameter());
        cwm.addTaggedValue((CwmModelElement)cwmEvent, "SECURITY_DETAIL_TYPE", securityService.getServiceTypeDesc());
        cwm.addTaggedValue((CwmModelElement)cwmEvent, "SECURITY_USERNAME", securityService.getUsername());
        cwm.addTaggedValue((CwmModelElement)cwmEvent, "SECURITY_PASSWORD", securityService.getPassword());
        cwm.addTaggedValue((CwmModelElement)cwmEvent, "SECURITY_PROXY_HOST", securityService.getProxyHostname());
        cwm.addTaggedValue((CwmModelElement)cwmEvent, "SECURITY_PROXY_PORT", securityService.getProxyPort());
        cwm.addTaggedValue((CwmModelElement)cwmEvent, "SECURITY_NON_PROXY_HOSTS", securityService.getNonProxyHosts());
        cwm.addTaggedValue((CwmModelElement)cwmEvent, "SECURITY_FILENAME", securityService.getFilename());
        cwm.addTaggedValue((CwmModelElement)cwmEvent, "SECURITY_URL", securityService.getURL(null));
    }

    public SecurityService getSecurityService(CWM cwm) {
        SecurityService securityService = new SecurityService();
        CwmEvent cwmEvent = cwm.getFirstEventWithName("SECURITY_SERVICE");
        if (cwmEvent != null) {
            securityService.setServiceURL(cwm.getFirstTaggedValue((CwmModelElement)cwmEvent, "SECURITY_SERVICE_URL"));
            securityService.setServiceName(cwm.getFirstTaggedValue((CwmModelElement)cwmEvent, "SECURITY_DETAILS_NAME"));
            securityService.setDetailNameParameter(cwm.getFirstTaggedValue((CwmModelElement)cwmEvent, "SECURITY_DETAIL_NAME"));
            securityService.setDetailServiceType(SecurityService.getServiceType(cwm.getFirstTaggedValue((CwmModelElement)cwmEvent, "SECURITY_DETAIL_TYPE")));
            securityService.setUsername(cwm.getFirstTaggedValue((CwmModelElement)cwmEvent, "SECURITY_USERNAME"));
            securityService.setPassword(cwm.getFirstTaggedValue((CwmModelElement)cwmEvent, "SECURITY_PASSWORD"));
            securityService.setProxyHostname(cwm.getFirstTaggedValue((CwmModelElement)cwmEvent, "SECURITY_PROXY_HOST"));
            securityService.setProxyPort(cwm.getFirstTaggedValue((CwmModelElement)cwmEvent, "SECURITY_PROXY_PORT"));
            securityService.setNonProxyHosts(cwm.getFirstTaggedValue((CwmModelElement)cwmEvent, "SECURITY_NON_PROXY_HOSTS"));
            securityService.setFilename(cwm.getFirstTaggedValue((CwmModelElement)cwmEvent, "SECURITY_FILENAME"));
        }
        return securityService;
    }

    public CwmTable storePhysicalTable(CWM cwm, PhysicalTable physicalTable) {
        if (!this.hasAccess(5, null)) {
            throw new CwmSchemaFactoryException(Messages.getString("CwmSchemaFactory.ERROR_0001_SCHEMA_ADMIN_ACCESS_DENIED"));
        }
        CwmTable cwmTable = cwm.createTable(physicalTable.getId());
        this.storeConceptProperties(cwm, (CwmModelElement)cwmTable, physicalTable.getConcept());
        if (physicalTable.getDatabaseMeta() != null) {
            cwm.addTaggedValue((CwmModelElement)cwmTable, "TABLE_TARGET_DATABASE_NAME", physicalTable.getDatabaseMeta().getName());
        }
        for (int i = 0; i < physicalTable.nrPhysicalColumns(); ++i) {
            PhysicalColumn physicalColumn = physicalTable.getPhysicalColumn(i);
            this.storePhysicalColumn(cwm, cwmTable, physicalColumn);
        }
        return cwmTable;
    }

    public PhysicalTable getPhysicalTable(CWM cwm, CwmTable cwmTable, SchemaMeta schemaMeta) {
        PhysicalTable physicalTable = new PhysicalTable(cwmTable.getName());
        physicalTable.addIDChangedListener(ConceptUtilityBase.createIDChangedListener(schemaMeta.getTables()));
        String databaseName = cwm.getFirstTaggedValue((CwmModelElement)cwmTable, "TABLE_TARGET_DATABASE_NAME");
        physicalTable.setDatabaseMeta(schemaMeta.findDatabase(databaseName));
        this.getConceptProperties(cwm, (CwmModelElement)cwmTable, physicalTable.getConcept(), schemaMeta);
        Collection columnsCollection = cwmTable.getOwnedElement();
        if (columnsCollection != null) {
            CwmColumn[] columns = columnsCollection.toArray(new CwmColumn[columnsCollection.size()]);
            for (int c = 0; c < columns.length; ++c) {
                CwmColumn column = columns[c];
                PhysicalColumn physicalColumn = this.getPhysicalColumn(cwm, column, physicalTable, schemaMeta);
                try {
                    physicalTable.addPhysicalColumn(physicalColumn);
                    continue;
                }
                catch (ObjectAlreadyExistsException e) {
                    // empty catch block
                }
            }
        }
        if (cwm.isReversingOrder()) {
            Collections.reverse(physicalTable.getPhysicalColumns().getList());
        }
        return physicalTable;
    }

    public void storePhysicalColumn(CWM cwm, CwmTable cwmTable, PhysicalColumn physicalColumn) {
        if (!this.hasAccess(5, null)) {
            throw new CwmSchemaFactoryException(Messages.getString("CwmSchemaFactory.ERROR_0001_SCHEMA_ADMIN_ACCESS_DENIED"));
        }
        CwmColumn column = cwm.createColumn(physicalColumn.getId());
        this.storeConceptProperties(cwm, (CwmModelElement)column, physicalColumn.getConcept());
        Collection c = cwmTable.getOwnedElement();
        c.add(column);
    }

    public PhysicalColumn getPhysicalColumn(CWM cwm, CwmColumn column, PhysicalTable physicalTable, SchemaMeta schemaMeta) {
        PhysicalColumn physicalColumn = new PhysicalColumn(column.getName());
        physicalColumn.addIDChangedListener(ConceptUtilityBase.createIDChangedListener(physicalTable.getPhysicalColumns()));
        this.getConceptProperties(cwm, (CwmModelElement)column, physicalColumn.getConcept(), schemaMeta);
        physicalColumn.setTable(physicalTable);
        return physicalColumn;
    }

    public void storeDatabaseMeta(CWM cwm, DatabaseMeta databaseMeta) {
        if (!this.hasAccess(5, null)) {
            throw new CwmSchemaFactoryException(Messages.getString("CwmSchemaFactory.ERROR_0001_SCHEMA_ADMIN_ACCESS_DENIED"));
        }
        CwmCatalog catalog = cwm.createCatalog(databaseMeta.getName());
        catalog.setName(databaseMeta.getName());
        cwm.addTaggedValue((CwmModelElement)catalog, "DATABASE_SERVER", databaseMeta.getHostname());
        cwm.addTaggedValue((CwmModelElement)catalog, "DATABASE_TYPE", databaseMeta.getDatabaseTypeDesc());
        cwm.addTaggedValue((CwmModelElement)catalog, "DATABASE_ACCESS", databaseMeta.getAccessTypeDesc());
        cwm.addTaggedValue((CwmModelElement)catalog, "DATABASE_DATABASE", databaseMeta.getDatabaseName());
        cwm.addTaggedValue((CwmModelElement)catalog, "DATABASE_PORT", databaseMeta.getDatabasePortNumberString());
        cwm.addTaggedValue((CwmModelElement)catalog, "DATABASE_USERNAME", databaseMeta.getUsername());
        cwm.addTaggedValue((CwmModelElement)catalog, "DATABASE_PASSWORD", databaseMeta.getPassword());
        cwm.addTaggedValue((CwmModelElement)catalog, "DATABASE_SERVERNAME", databaseMeta.getServername());
        cwm.addTaggedValue((CwmModelElement)catalog, "DATABASE_DATA_TABLESPACE", databaseMeta.getDataTablespace());
        cwm.addTaggedValue((CwmModelElement)catalog, "DATABASE_INDEX_TABLESPACE", databaseMeta.getIndexTablespace());
        ArrayList<Object> list = new ArrayList<Object>(databaseMeta.getAttributes().keySet());
        for (String string : list) {
            String attribute = (String)databaseMeta.getAttributes().get(string);
            if (Const.isEmpty(attribute)) continue;
            cwm.addTaggedValue((CwmModelElement)catalog, "DATABASE_ATTRIBUTE_PREFIX_" + string, attribute);
        }
        try {
            cwm.addTaggedValue((CwmModelElement)catalog, "DATABASE_JDBC_URL", databaseMeta.getURL());
        }
        catch (KettleDatabaseException e) {
            cwm.addTaggedValue((CwmModelElement)catalog, "DATABASE_JDBC_URL", Messages.getString("CwmSchemaFactory.ERROR_0002_INVALID_DATA"));
        }
    }

    public DatabaseMeta getDatabaseMeta(CWM cwm, CwmCatalog catalog) {
        DatabaseMeta databaseMeta = new DatabaseMeta();
        databaseMeta.setName(catalog.getName());
        databaseMeta.setHostname(cwm.getFirstTaggedValue((CwmModelElement)catalog, "DATABASE_SERVER"));
        databaseMeta.setDatabaseType(cwm.getFirstTaggedValue((CwmModelElement)catalog, "DATABASE_TYPE"));
        databaseMeta.setAccessType(DatabaseMeta.getAccessType((String)cwm.getFirstTaggedValue((CwmModelElement)catalog, "DATABASE_ACCESS")));
        databaseMeta.setDBName(cwm.getFirstTaggedValue((CwmModelElement)catalog, "DATABASE_DATABASE"));
        databaseMeta.setDBPort(cwm.getFirstTaggedValue((CwmModelElement)catalog, "DATABASE_PORT"));
        databaseMeta.setUsername(cwm.getFirstTaggedValue((CwmModelElement)catalog, "DATABASE_USERNAME"));
        databaseMeta.setPassword(cwm.getFirstTaggedValue((CwmModelElement)catalog, "DATABASE_PASSWORD"));
        databaseMeta.setServername(cwm.getFirstTaggedValue((CwmModelElement)catalog, "DATABASE_SERVERNAME"));
        databaseMeta.setDataTablespace(cwm.getFirstTaggedValue((CwmModelElement)catalog, "DATABASE_DATA_TABLESPACE"));
        databaseMeta.setIndexTablespace(cwm.getFirstTaggedValue((CwmModelElement)catalog, "DATABASE_INDEX_TABLESPACE"));
        CwmTaggedValue[] taggedValue = cwm.getTaggedValues((CwmModelElement)catalog);
        for (int i = 0; i < taggedValue.length; ++i) {
            if (!taggedValue[i].getTag().startsWith("DATABASE_ATTRIBUTE_PREFIX_")) continue;
            String key = taggedValue[i].getTag().substring("DATABASE_ATTRIBUTE_PREFIX_".length());
            String attribute = taggedValue[i].getValue();
            databaseMeta.getAttributes().put(key, attribute);
        }
        return databaseMeta;
    }

    public void storeBusinessModel(CWM cwm, BusinessModel businessModel) {
        int i;
        if (!this.hasAccess(5, null)) {
            throw new CwmSchemaFactoryException(Messages.getString("CwmSchemaFactory.ERROR_0001_SCHEMA_ADMIN_ACCESS_DENIED"));
        }
        CwmSchema cwmSchema = cwm.createSchema(businessModel.getId());
        this.storeConceptProperties(cwm, (CwmModelElement)cwmSchema, businessModel.getConcept());
        for (i = 0; i < businessModel.nrBusinessTables(); ++i) {
            BusinessTable businessTable = businessModel.getBusinessTable(i);
            this.storeBusinessTable(cwm, cwmSchema, businessTable);
        }
        for (i = 0; i < businessModel.nrNotes(); ++i) {
            NotePadMeta notePadMeta = businessModel.getNote(i);
            this.storeNotePadMeta(cwm, cwmSchema, notePadMeta);
        }
        for (i = 0; i < businessModel.nrRelationships(); ++i) {
            RelationshipMeta relationshipMeta = businessModel.getRelationship(i);
            this.storeRelationshipMeta(cwm, relationshipMeta, cwmSchema);
        }
        for (i = 0; i < businessModel.getRootCategory().nrBusinessCategories(); ++i) {
            BusinessCategory businessCategory = businessModel.getRootCategory().getBusinessCategory(i);
            this.storeBusinessCategory(cwm, businessCategory, null, cwmSchema);
        }
        org.pentaho.pms.cwm.pentaho.meta.olap.CwmSchema cwmOlapSchema = cwm.createOlapSchema(businessModel.getId());
        List<OlapDimension> dimensions = businessModel.getOlapDimensions();
        for (int i2 = 0; i2 < dimensions.size(); ++i2) {
            OlapDimension dimension = dimensions.get(i2);
            this.storeOlapDimension(cwm, cwmOlapSchema, dimension);
        }
        List<OlapCube> cubes = businessModel.getOlapCubes();
        for (int i3 = 0; i3 < cubes.size(); ++i3) {
            OlapCube cube = cubes.get(i3);
            this.storeOlapCube(cwm, cwmOlapSchema, cube);
        }
    }

    public BusinessModel getBusinessModel(CWM cwm, CwmSchema cwmSchema, SchemaMeta schemaMeta) {
        BusinessModel businessModel = new BusinessModel(cwmSchema.getName());
        businessModel.addIDChangedListener(ConceptUtilityBase.createIDChangedListener(schemaMeta.getBusinessModels()));
        this.getConceptProperties(cwm, (CwmModelElement)cwmSchema, businessModel.getConcept(), schemaMeta);
        CwmDimension[] CwmDimensions = cwm.getDimensions(cwmSchema);
        for (int i = 0; i < CwmDimensions.length; ++i) {
            CwmDimension cwmDimension = CwmDimensions[i];
            BusinessTable businessTable = this.getBusinessTable(cwm, cwmDimension, schemaMeta, businessModel);
            if (!this.hasAccess(0, businessTable)) continue;
            try {
                businessModel.addBusinessTable(businessTable);
                continue;
            }
            catch (ObjectAlreadyExistsException e) {
                // empty catch block
            }
        }
        CwmDescription[] cwmDescriptions = cwm.getDescription((CwmModelElement)cwmSchema);
        for (int i = 0; i < cwmDescriptions.length; ++i) {
            CwmDescription cwmDescription = cwmDescriptions[i];
            if (!"NOTEPAD".equals(cwmDescription.getType())) continue;
            NotePadMeta notePadMeta = this.getNotePadMeta(cwm, cwmDescription);
            businessModel.addNote(notePadMeta);
        }
        CwmKeyRelationship[] cwmKeyRelationships = cwm.getRelationships(cwmSchema);
        for (int i = 0; i < cwmKeyRelationships.length; ++i) {
            CwmKeyRelationship cwmKeyRelationship = cwmKeyRelationships[i];
            RelationshipMeta relationshipMeta = this.getRelationshipMeta(cwm, cwmKeyRelationship, businessModel);
            businessModel.addRelationship(relationshipMeta);
        }
        CwmExtent[] cwmExtents = cwm.getRootExtents(cwmSchema);
        for (int i = 0; i < cwmExtents.length; ++i) {
            CwmExtent cwmExtent = cwmExtents[i];
            BusinessCategory businessCategory = this.getBusinessCategory(cwm, cwmExtent, businessModel, schemaMeta);
            if (!this.hasAccess(0, businessCategory)) continue;
            try {
                businessModel.getRootCategory().addBusinessCategory(businessCategory);
                continue;
            }
            catch (ObjectAlreadyExistsException e) {
                // empty catch block
            }
        }
        org.pentaho.pms.cwm.pentaho.meta.olap.CwmSchema cwmOlapSchema = cwm.findOlapSchema(cwmSchema.getName());
        if (cwmOlapSchema != null) {
            Collection cwmOlapDimensions = cwmOlapSchema.getDimension();
            for (org.pentaho.pms.cwm.pentaho.meta.olap.CwmDimension cwmOlapDimension : cwmOlapDimensions) {
                OlapDimension olapDimension = this.getOlapDimension(cwm, cwmOlapDimension, businessModel);
                businessModel.getOlapDimensions().add(0, olapDimension);
            }
            Collection cwmOlapCubes = cwmOlapSchema.getCube();
            for (CwmCube cwmCube : cwmOlapCubes) {
                OlapCube olapCube = this.getOlapCube(cwm, cwmCube, businessModel);
                businessModel.getOlapCubes().add(olapCube);
            }
        }
        if (cwm.isReversingOrder()) {
            Collections.reverse(businessModel.getBusinessTables().getList());
            Collections.reverse(businessModel.getRootCategory().getBusinessCategories().getList());
        }
        return businessModel;
    }

    public void storeBusinessTable(CWM cwm, CwmSchema cwmSchema, BusinessTable businessTable) {
        if (!this.hasAccess(5, null)) {
            throw new CwmSchemaFactoryException(Messages.getString("CwmSchemaFactory.ERROR_0001_SCHEMA_ADMIN_ACCESS_DENIED"));
        }
        CwmDimension cwmDimension = cwm.createDimension(cwmSchema, businessTable.getId());
        String physicalTablename = businessTable.getPhysicalTable().getId();
        Collection cg = cwmDimension.getTaggedValue();
        cg.add(cwm.createTaggedValue("BUSINESS_TABLE_PHYSICAL_TABLE_NAME", physicalTablename));
        cwm.setPosition((CwmModelElement)cwmDimension, businessTable.getLocation().x, businessTable.getLocation().y);
        cwm.addTaggedValue((CwmModelElement)cwmDimension, "TABLE_IS_DRAWN", businessTable.isDrawn() ? "Y" : "N");
        this.storeConceptProperties(cwm, (CwmModelElement)cwmDimension, businessTable.getConcept());
        for (int i = 0; i < businessTable.nrBusinessColumns(); ++i) {
            BusinessColumn businessColumn = businessTable.getBusinessColumn(i);
            this.storeBusinessColumn(cwm, cwmSchema, cwmDimension, businessColumn);
        }
    }

    public BusinessTable getBusinessTable(CWM cwm, CwmDimension cwmDimension, SchemaMeta schemaMeta, BusinessModel businessModel) {
        BusinessTable businessTable = new BusinessTable(cwmDimension.getName());
        businessTable.addIDChangedListener(ConceptUtilityBase.createIDChangedListener(businessModel.getBusinessTables()));
        this.getConceptProperties(cwm, (CwmModelElement)cwmDimension, businessTable.getConcept(), schemaMeta);
        businessTable.getConcept().setSecurityParentInterface(businessModel.getConcept());
        String physicalTableName = cwm.getFirstTaggedValue((CwmModelElement)cwmDimension, "BUSINESS_TABLE_PHYSICAL_TABLE_NAME");
        PhysicalTable physicalTable = schemaMeta.findPhysicalTable(physicalTableName);
        businessTable.setPhysicalTable(physicalTable);
        int x = cwm.getPositionX((CwmModelElement)cwmDimension);
        int y = cwm.getPositionY((CwmModelElement)cwmDimension);
        businessTable.setLocation(x, y);
        boolean drawn = !"N".equalsIgnoreCase(cwm.getFirstTaggedValue((CwmModelElement)cwmDimension, "TABLE_IS_DRAWN"));
        businessTable.setDrawn(drawn);
        List cwmDimensionedObjects = cwmDimension.getDimensionedObject();
        for (int i = 0; i < cwmDimensionedObjects.size(); ++i) {
            CwmDimensionedObject cwmDimensionedObject = (CwmDimensionedObject)cwmDimensionedObjects.get(i);
            BusinessColumn businessColumn = this.getBusinessColumn(cwm, cwmDimensionedObject, physicalTable, businessTable, schemaMeta);
            if (!this.hasAccess(0, businessColumn)) continue;
            try {
                businessTable.addBusinessColumn(businessColumn);
                continue;
            }
            catch (ObjectAlreadyExistsException e) {
                // empty catch block
            }
        }
        return businessTable;
    }

    public void storeBusinessColumn(CWM cwm, CwmSchema cwmSchema, CwmDimension cwmDimension, BusinessColumn businessColumn) {
        if (!this.hasAccess(5, null)) {
            throw new CwmSchemaFactoryException(Messages.getString("CwmSchemaFactory.ERROR_0001_SCHEMA_ADMIN_ACCESS_DENIED"));
        }
        CwmDimensionedObject cwmDimensionedObject = cwm.createDimensionedObject(businessColumn.getId());
        cwmDimensionedObject.setSchema(cwmSchema);
        Collection c = cwmDimensionedObject.getTaggedValue();
        if (businessColumn.getPhysicalColumn() == null) {
            logger.error((Object)Messages.getErrorString("CwmSchemaFactory.ERROR_0004_MISSING_PHYSICAL_COLUMN", businessColumn.getBusinessTable().getId(), businessColumn.getId()));
            businessColumn.setPhysicalColumn(businessColumn.getBusinessTable().getPhysicalTable().getPhysicalColumn(0));
        }
        String physicalColumnName = businessColumn.getPhysicalColumn().getId();
        c.add(cwm.createTaggedValue("BUSINESS_COLUMN_PHYSICAL_COLUMN_NAME", physicalColumnName));
        String businessTableName = businessColumn.getBusinessTable().getId();
        c.add(cwm.createTaggedValue("BUSINESS_COLUMN_BUSINESS_TABLE", businessTableName));
        this.storeConceptProperties(cwm, (CwmModelElement)cwmDimensionedObject, businessColumn.getConcept());
        List cd = cwmDimension.getDimensionedObject();
        cd.add(cwmDimensionedObject);
    }

    public BusinessColumn getBusinessColumn(CWM cwm, CwmDimensionedObject cwmDimensionedObject, PhysicalTable physicalTable, BusinessTable businessTable, SchemaMeta schemaMeta) {
        BusinessColumn businessColumn = new BusinessColumn(cwmDimensionedObject.getName());
        businessColumn.addIDChangedListener(ConceptUtilityBase.createIDChangedListener(businessTable.getBusinessColumns()));
        businessColumn.setBusinessTable(businessTable);
        Concept concept = new Concept();
        this.getConceptProperties(cwm, (CwmModelElement)cwmDimensionedObject, concept, schemaMeta);
        businessColumn.setConcept(concept);
        businessColumn.getConcept().setSecurityParentInterface(businessTable.getConcept());
        String physicalColumnName = cwm.getFirstTaggedValue((CwmModelElement)cwmDimensionedObject, "BUSINESS_COLUMN_PHYSICAL_COLUMN_NAME");
        PhysicalColumn physicalColumn = physicalTable.findPhysicalColumn(physicalColumnName);
        if (physicalColumn == null) {
            logger.error((Object)Messages.getErrorString("CwmSchemaFactory.ERROR_0003_XMI_CORRUPT_MISSING_PHYSICAL_TABLE", physicalColumnName, businessColumn.getBusinessTable().getId(), businessColumn.getId()));
            businessColumn.setPhysicalColumn(physicalTable.getPhysicalColumn(0));
        } else {
            businessColumn.setPhysicalColumn(physicalColumn);
        }
        return businessColumn;
    }

    public void storeRelationshipMeta(CWM cwm, RelationshipMeta relationshipMeta, CwmSchema cwmSchema) {
        if (!this.hasAccess(5, null)) {
            throw new CwmSchemaFactoryException(Messages.getString("CwmSchemaFactory.ERROR_0001_SCHEMA_ADMIN_ACCESS_DENIED"));
        }
        CwmKeyRelationship relationship = cwm.createRelationship();
        Collection pairs = relationship.getTaggedValue();
        if (relationshipMeta.getTableFrom() != null) {
            pairs.add(cwm.createTaggedValue("RELATIONSHIP_TABLENAME_PARENT", relationshipMeta.getTableFrom().getId()));
        }
        if (relationshipMeta.getTableTo() != null) {
            pairs.add(cwm.createTaggedValue("RELATIONSHIP_TABLENAME_CHILD", relationshipMeta.getTableTo().getId()));
        }
        if (relationshipMeta.isComplex()) {
            pairs.add(cwm.createTaggedValue("RELATIONSHIP_IS_COMPLEX", "Y"));
            if (!Const.isEmpty(relationshipMeta.getComplexJoin())) {
                pairs.add(cwm.createTaggedValue("RELATIONSHIP_COMPLEX_JOIN", relationshipMeta.getComplexJoin()));
            }
        } else {
            if (relationshipMeta.getFieldFrom() != null) {
                pairs.add(cwm.createTaggedValue("RELATIONSHIP_FIELDNAME_PARENT", relationshipMeta.getFieldFrom().getId()));
            }
            if (relationshipMeta.getFieldTo() != null) {
                pairs.add(cwm.createTaggedValue("RELATIONSHIP_FIELDNAME_CHILD", relationshipMeta.getFieldTo().getId()));
            }
        }
        pairs.add(cwm.createTaggedValue("RELATIONSHIP_TYPE", relationshipMeta.getTypeDesc()));
        pairs.add(cwm.createTaggedValue("RELATIONSHIP_JOIN_ORDER_KEY", relationshipMeta.getJoinOrderKey()));
        pairs.add(cwm.createTaggedValue("RELATIONSHIP_DESCRIPTION", relationshipMeta.getDescription()));
        Collection cr = cwmSchema.getOwnedElement();
        cr.add(relationship);
    }

    public RelationshipMeta getRelationshipMeta(CWM cwm, CwmKeyRelationship relationship, BusinessModel businessModel) {
        RelationshipMeta relationshipMeta = new RelationshipMeta();
        String parentTable = CWM.findFirstTaggedValue(relationship.getTaggedValue(), "RELATIONSHIP_TABLENAME_PARENT");
        String childTable = CWM.findFirstTaggedValue(relationship.getTaggedValue(), "RELATIONSHIP_TABLENAME_CHILD");
        relationshipMeta.setTableFrom(businessModel.findBusinessTable(parentTable));
        relationshipMeta.setTableTo(businessModel.findBusinessTable(childTable));
        boolean complex = "Y".equalsIgnoreCase(CWM.findFirstTaggedValue(relationship.getTaggedValue(), "RELATIONSHIP_IS_COMPLEX"));
        relationshipMeta.setComplex(complex);
        if (complex) {
            String complexJoin = CWM.findFirstTaggedValue(relationship.getTaggedValue(), "RELATIONSHIP_COMPLEX_JOIN");
            relationshipMeta.setComplexJoin(complexJoin);
        } else {
            String parentField = CWM.findFirstTaggedValue(relationship.getTaggedValue(), "RELATIONSHIP_FIELDNAME_PARENT");
            String childField = CWM.findFirstTaggedValue(relationship.getTaggedValue(), "RELATIONSHIP_FIELDNAME_CHILD");
            if (relationshipMeta.getTableFrom() != null) {
                BusinessTable tableFrom = relationshipMeta.getTableFrom();
                BusinessColumn fieldFrom = tableFrom.findBusinessColumn(parentField);
                relationshipMeta.setFieldFrom(fieldFrom);
            }
            if (relationshipMeta.getTableTo() != null) {
                BusinessTable tableTo = relationshipMeta.getTableTo();
                BusinessColumn fieldTo = tableTo.findBusinessColumn(childField);
                relationshipMeta.setFieldTo(fieldTo);
            }
        }
        String relType = CWM.findFirstTaggedValue(relationship.getTaggedValue(), "RELATIONSHIP_TYPE");
        relationshipMeta.setType(relType);
        String joinOrderKey = CWM.findFirstTaggedValue(relationship.getTaggedValue(), "RELATIONSHIP_JOIN_ORDER_KEY");
        relationshipMeta.setJoinOrderKey(joinOrderKey);
        String description = CWM.findFirstTaggedValue(relationship.getTaggedValue(), "RELATIONSHIP_DESCRIPTION");
        relationshipMeta.setDescription(description);
        return relationshipMeta;
    }

    public void storeNotePadMeta(CWM cwm, CwmSchema cwmSchema, NotePadMeta notePadMeta) {
        if (!this.hasAccess(5, null)) {
            throw new CwmSchemaFactoryException(Messages.getString("CwmSchemaFactory.ERROR_0001_SCHEMA_ADMIN_ACCESS_DENIED"));
        }
        CwmDescription cwmDescription = cwm.createDescription(notePadMeta.getNote());
        cwmDescription.setType("NOTEPAD");
        cwm.setPosition((CwmModelElement)cwmDescription, notePadMeta.getLocation().x, notePadMeta.getLocation().y);
        cwm.setWidth((CwmModelElement)cwmDescription, notePadMeta.getWidth());
        cwm.setHeight((CwmModelElement)cwmDescription, notePadMeta.getHeight());
        cwm.setDescription((CwmModelElement)cwmSchema, cwmDescription);
    }

    public NotePadMeta getNotePadMeta(CWM cwm, CwmDescription cwmDescription) {
        NotePadMeta notePadMeta = new NotePadMeta();
        notePadMeta.setNote(cwmDescription.getBody());
        notePadMeta.setLocation(cwm.getPositionX((CwmModelElement)cwmDescription), cwm.getPositionY((CwmModelElement)cwmDescription));
        notePadMeta.setWidth(cwm.getPositionWidth((CwmModelElement)cwmDescription));
        notePadMeta.setHeight(cwm.getPositionHeight((CwmModelElement)cwmDescription));
        return notePadMeta;
    }

    public CwmExtent storeBusinessCategory(CWM cwm, BusinessCategory businessCategory, CwmExtent parent, CwmSchema cwmSchema) {
        int i;
        if (!this.hasAccess(5, null)) {
            throw new CwmSchemaFactoryException(Messages.getString("CwmSchemaFactory.ERROR_0001_SCHEMA_ADMIN_ACCESS_DENIED"));
        }
        CwmExtent cwmExtent = cwm.createExtent(businessCategory.getId());
        cwmExtent.setNamespace((CwmNamespace)cwmSchema);
        String isRoot = parent == null ? "Y" : "N";
        Collection cat = cwmExtent.getTaggedValue();
        cat.add(cwm.createTaggedValue("BUSINESS_CATEGORY_ROOT", isRoot));
        this.storeConceptProperties(cwm, (CwmModelElement)cwmExtent, businessCategory.getConcept());
        for (i = 0; i < businessCategory.nrBusinessColumns(); ++i) {
            BusinessColumn businessColumn = businessCategory.getBusinessColumn(i);
            CwmAttribute cwmAttribute = cwm.createAttribute(businessColumn.getId());
            Collection ct = cwmAttribute.getTaggedValue();
            ct.add(cwm.createTaggedValue("BUSINESS_CATEGORY_TYPE", "Column"));
            Collection ca = cwmExtent.getOwnedElement();
            ca.add(cwmAttribute);
        }
        for (i = 0; i < businessCategory.nrBusinessCategories(); ++i) {
            CwmExtent childCwmExtent = this.storeBusinessCategory(cwm, businessCategory.getBusinessCategory(i), cwmExtent, cwmSchema);
            Collection cac = childCwmExtent.getTaggedValue();
            cac.add(cwm.createTaggedValue("BUSINESS_CATEGORY_TYPE", "Column"));
            Collection cao = cwmExtent.getOwnedElement();
            cao.add(childCwmExtent);
        }
        return cwmExtent;
    }

    public BusinessCategory getBusinessCategory(CWM cwm, CwmExtent cwmExtent, BusinessModel businessModel, SchemaMeta schemaMeta) {
        BusinessCategory businessCategory = new BusinessCategory(cwmExtent.getName());
        businessCategory.addIDChangedListener(ConceptUtilityBase.createIDChangedListener(businessModel.getRootCategory().getBusinessCategories()));
        Concept concept = new Concept();
        this.getConceptProperties(cwm, (CwmModelElement)cwmExtent, concept, schemaMeta);
        businessCategory.setConcept(concept);
        businessCategory.getConcept().setSecurityParentInterface(businessModel.getConcept());
        Collection elements = cwmExtent.getOwnedElement();
        for (CwmModelElement element : elements) {
            CwmExtent childCwmExtent;
            BusinessCategory childBusinessCategory;
            String type = CWM.findFirstTaggedValue(element.getTaggedValue(), "BUSINESS_CATEGORY_TYPE");
            if (type.equals("Column")) {
                CwmAttribute cwmAttribute = (CwmAttribute)element;
                BusinessColumn businessColumn = businessModel.findBusinessColumn(cwmAttribute.getName());
                if (businessColumn == null || !this.hasAccess(0, businessColumn)) continue;
                try {
                    businessCategory.addBusinessColumn(businessColumn);
                }
                catch (ObjectAlreadyExistsException e) {}
                continue;
            }
            if (!type.equals("Category") || !this.hasAccess(0, childBusinessCategory = this.getBusinessCategory(cwm, childCwmExtent = (CwmExtent)element, businessModel, schemaMeta))) continue;
            try {
                businessCategory.addBusinessCategory(childBusinessCategory);
            }
            catch (ObjectAlreadyExistsException e) {}
        }
        if (cwm.isReversingOrder()) {
            Collections.reverse(businessCategory.getBusinessCategories().getList());
            Collections.reverse(businessCategory.getBusinessColumns().getList());
        }
        return businessCategory;
    }

    public void storeLocale(CWM cwm, LocaleInterface locale) {
        if (!this.hasAccess(5, null)) {
            throw new CwmSchemaFactoryException(Messages.getString("CwmSchemaFactory.ERROR_0001_SCHEMA_ADMIN_ACCESS_DENIED"));
        }
        CwmParameter cwmParameter = cwm.createParameter(locale.getCode());
        if (!Const.isEmpty(locale.getDescription())) {
            cwm.addTaggedValue((CwmModelElement)cwmParameter, "LOCALE_DESCRIPTION", locale.getDescription());
        }
        cwm.addTaggedValue((CwmModelElement)cwmParameter, "LOCALE_ORDER", Integer.toString(locale.getOrder()));
        cwm.addTaggedValue((CwmModelElement)cwmParameter, "LOCALE_IS_DEFAULT", locale.isActive() ? "Y" : "N");
    }

    public LocaleInterface getLocale(CWM cwm, CwmParameter cwmParameter) {
        LocaleMeta locale = new LocaleMeta();
        locale.setCode(cwmParameter.getName());
        String description = cwm.getFirstTaggedValue((CwmModelElement)cwmParameter, "LOCALE_DESCRIPTION");
        if (!Const.isEmpty(description)) {
            locale.setDescription(description);
        }
        String strOrder = cwm.getFirstTaggedValue((CwmModelElement)cwmParameter, "LOCALE_ORDER");
        locale.setOrder(Const.toInt(strOrder, -1));
        boolean active = "Y".equalsIgnoreCase(cwm.getFirstTaggedValue((CwmModelElement)cwmParameter, "LOCALE_IS_DEFAULT"));
        locale.setActive(active);
        return locale;
    }

    public void storeModelConcept(CWM cwm, ConceptInterface concept) {
        if (!this.hasAccess(5, null)) {
            throw new CwmSchemaFactoryException(Messages.getString("CwmSchemaFactory.ERROR_0001_SCHEMA_ADMIN_ACCESS_DENIED"));
        }
        CwmClass cwmClass = cwm.createClass(concept.getName());
        this.storeConceptProperties(cwm, (CwmModelElement)cwmClass, concept);
    }

    public ConceptInterface getModelConcept(CWM cwm, CwmClass cwmClass, SchemaMeta schemaMeta) {
        Concept concept = new Concept(cwmClass.getName());
        this.getConceptProperties(cwm, (CwmModelElement)cwmClass, concept, schemaMeta);
        return concept;
    }

    public void storeConceptProperties(CWM cwm, CwmModelElement modelElement, ConceptInterface concept) {
        if (!this.hasAccess(5, null)) {
            throw new CwmSchemaFactoryException(Messages.getString("CwmSchemaFactory.ERROR_0001_SCHEMA_ADMIN_ACCESS_DENIED"));
        }
        if (concept.getParentInterface() != null) {
            cwm.addTaggedValue(modelElement, "CONCEPT_PARENT_NAME", concept.getParentInterface().getName());
        }
        String[] ids = concept.getChildPropertyIDs();
        for (int i = 0; i < ids.length; ++i) {
            ConceptPropertyInterface property = concept.getProperty(ids[i]);
            if (property.getValue() != null) {
                String string;
                Object value;
                CwmDescription description;
                CwmDescription description2;
                if (property.getType().equals(ConceptPropertyType.LOCALIZED_STRING)) {
                    LocalizedStringSettings stringSettings = (LocalizedStringSettings)property.getValue();
                    String[] locales = stringSettings.getLocales();
                    for (int j = 0; j < locales.length; ++j) {
                        description2 = cwm.createDescription(stringSettings.getString(locales[j]));
                        description2.setLanguage(locales[j]);
                        description2.setName(property.getId());
                        description2.setType(property.getType().getCode());
                        cwm.setDescription(modelElement, description2);
                    }
                    continue;
                }
                if (property.getType().equals(ConceptPropertyType.STRING)) {
                    String string2 = (String)property.getValue();
                    description = cwm.createDescription(string2);
                    description.setName(property.getId());
                    description.setType(property.getType().getCode());
                    cwm.setDescription(modelElement, description);
                    continue;
                }
                if (property.getType().equals(ConceptPropertyType.BOOLEAN)) {
                    value = (Boolean)property.getValue();
                    description = cwm.createDescription(((Boolean)value).booleanValue() ? "Y" : "N");
                    description.setName(property.getId());
                    description.setType(property.getType().getCode());
                    cwm.setDescription(modelElement, description);
                    continue;
                }
                if (property.getType().equals(ConceptPropertyType.DATE)) {
                    value = (Date)property.getValue();
                    SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd'T'HH:mm:ss");
                    String string3 = "";
                    if (value != null) {
                        string3 = df.format((Date)value);
                    }
                    description2 = cwm.createDescription(string3);
                    description2.setName(property.getId());
                    description2.setType(property.getType().getCode());
                    cwm.setDescription(modelElement, description2);
                    continue;
                }
                if (property.getType().equals(ConceptPropertyType.TABLETYPE)) {
                    value = (TableTypeSettings)property.getValue();
                    string = "";
                    if (value != null) {
                        string = ((TableTypeSettings)value).getCode();
                    }
                    CwmDescription description3 = cwm.createDescription(string);
                    description3.setName(property.getId());
                    description3.setType(property.getType().getCode());
                    cwm.setDescription(modelElement, description3);
                    continue;
                }
                if (property.getType().equals(ConceptPropertyType.FIELDTYPE)) {
                    value = (FieldTypeSettings)property.getValue();
                    string = "";
                    if (value != null) {
                        string = ((FieldTypeSettings)value).getCode();
                    }
                    CwmDescription description4 = cwm.createDescription(string);
                    description4.setName(property.getId());
                    description4.setType(property.getType().getCode());
                    cwm.setDescription(modelElement, description4);
                    continue;
                }
                if (property.getType().equals(ConceptPropertyType.AGGREGATION)) {
                    value = (AggregationSettings)property.getValue();
                    string = "";
                    if (value != null) {
                        string = ((AggregationSettings)value).getCode();
                    }
                    CwmDescription description5 = cwm.createDescription(string);
                    description5.setName(property.getId());
                    description5.setType(property.getType().getCode());
                    cwm.setDescription(modelElement, description5);
                    continue;
                }
                if (property.getType().equals(ConceptPropertyType.AGGREGATION_LIST)) {
                    value = (ConceptPropertyAggregationList)property;
                    description = cwm.createDescription(((ConceptPropertyAggregationList)value).toXML());
                    description.setName(property.getId());
                    description.setType(property.getType().getCode());
                    cwm.setDescription(modelElement, description);
                    continue;
                }
                if (property.getType().equals(ConceptPropertyType.NUMBER)) {
                    value = (BigDecimal)property.getValue();
                    string = "";
                    if (value != null) {
                        string = ((BigDecimal)value).toString();
                    }
                    CwmDescription description6 = cwm.createDescription(string);
                    description6.setName(property.getId());
                    description6.setType(property.getType().getCode());
                    cwm.setDescription(modelElement, description6);
                    continue;
                }
                if (property.getType().equals(ConceptPropertyType.COLOR)) {
                    value = (ColorSettings)property.getValue();
                    string = "";
                    if (value != null) {
                        string = ((ColorSettings)value).toString();
                    }
                    CwmDescription description7 = cwm.createDescription(string);
                    description7.setName(property.getId());
                    description7.setType(property.getType().getCode());
                    cwm.setDescription(modelElement, description7);
                    continue;
                }
                if (property.getType().equals(ConceptPropertyType.DATATYPE)) {
                    value = (DataTypeSettings)property.getValue();
                    string = "";
                    if (value != null) {
                        string = ((DataTypeSettings)value).toString();
                    }
                    CwmDescription description8 = cwm.createDescription(string);
                    description8.setName(property.getId());
                    description8.setType(property.getType().getCode());
                    cwm.setDescription(modelElement, description8);
                    continue;
                }
                if (property.getType().equals(ConceptPropertyType.FONT)) {
                    value = (FontSettings)property.getValue();
                    string = "";
                    if (value != null) {
                        string = ((FontSettings)value).toString();
                    }
                    CwmDescription description9 = cwm.createDescription(string);
                    description9.setName(property.getId());
                    description9.setType(property.getType().getCode());
                    cwm.setDescription(modelElement, description9);
                    continue;
                }
                if (property.getType().equals(ConceptPropertyType.URL)) {
                    value = (URL)property.getValue();
                    string = "";
                    if (value != null) {
                        string = ((URL)value).toString();
                    }
                    CwmDescription description10 = cwm.createDescription(string);
                    description10.setName(property.getId());
                    description10.setType(property.getType().getCode());
                    cwm.setDescription(modelElement, description10);
                    continue;
                }
                if (property.getType().equals(ConceptPropertyType.SECURITY)) {
                    value = (Security)property.getValue();
                    string = "";
                    if (value != null) {
                        string = ((Security)value).toXML();
                    }
                    CwmDescription description11 = cwm.createDescription(string);
                    description11.setName(property.getId());
                    description11.setType(property.getType().getCode());
                    cwm.setDescription(modelElement, description11);
                    continue;
                }
                if (property.getType().equals(ConceptPropertyType.ROW_LEVEL_SECURITY)) {
                    value = (RowLevelSecurity)property.getValue();
                    string = "";
                    if (value != null) {
                        string = ((RowLevelSecurity)value).toXML();
                    }
                    CwmDescription description12 = cwm.createDescription(string);
                    description12.setName(property.getId());
                    description12.setType(property.getType().getCode());
                    cwm.setDescription(modelElement, description12);
                    continue;
                }
                if (property.getType().equals(ConceptPropertyType.ALIGNMENT)) {
                    value = (AlignmentSettings)property.getValue();
                    string = "";
                    if (value != null) {
                        string = ((AlignmentSettings)value).toString();
                    }
                    CwmDescription description13 = cwm.createDescription(string);
                    description13.setName(property.getId());
                    description13.setType(property.getType().getCode());
                    cwm.setDescription(modelElement, description13);
                    continue;
                }
                if (property.getType().equals(ConceptPropertyType.COLUMN_WIDTH)) {
                    value = property.getValue();
                    string = "";
                    if (value != null) {
                        string = value.toString();
                    }
                    CwmDescription description14 = cwm.createDescription(string);
                    description14.setName(property.getId());
                    description14.setType(property.getType().getCode());
                    cwm.setDescription(modelElement, description14);
                    continue;
                }
                throw new RuntimeException("Unrecognized concept property type: " + property.getType());
            }
            logger.error((Object)Messages.getString("CwmSchemaFactory.ERROR_PROPERTY_VALUE_IS_NULL", property.getType().toString()));
        }
    }

    public void getConceptProperties(CWM cwm, CwmModelElement modelElement, ConceptInterface concept, SchemaMeta schemaMeta) {
        ConceptInterface parentInterface;
        String parentName = cwm.getFirstTaggedValue(modelElement, "CONCEPT_PARENT_NAME");
        if (parentName != null && (parentInterface = schemaMeta.findConcept(parentName)) != null) {
            concept.setParentInterface(parentInterface);
        }
        CwmDescription[] descriptions = cwm.getDescription(modelElement);
        for (int i = 0; i < descriptions.length; ++i) {
            ConceptPropertyBase property;
            ConceptPropertyBase property2;
            CwmDescription description = descriptions[i];
            String locale = description.getLanguage();
            String value = description.getBody();
            String type = description.getType();
            String name = description.getName();
            if (type == null || "NOTEPAD".equals(type)) continue;
            if (type.equals(ConceptPropertyType.LOCALIZED_STRING.getCode())) {
                if (Const.isEmpty(name) || Const.isEmpty(value) || Const.isEmpty(locale)) continue;
                concept.addLocalizedProperty(name, locale, value);
                continue;
            }
            if (type.equals(ConceptPropertyType.STRING.getCode())) {
                if (Const.isEmpty(name) || Const.isEmpty(value)) continue;
                ConceptPropertyString conceptPropertyString = new ConceptPropertyString(name, value);
                concept.addProperty(conceptPropertyString);
                continue;
            }
            if (type.equals(ConceptPropertyType.BOOLEAN.getCode())) {
                if (Const.isEmpty(name) || Const.isEmpty(value)) continue;
                ConceptPropertyBoolean conceptPropertyBoolean = new ConceptPropertyBoolean(name, new Boolean("Y".equalsIgnoreCase(value)));
                concept.addProperty(conceptPropertyBoolean);
                continue;
            }
            if (type.equals(ConceptPropertyType.DATE.getCode())) {
                if (Const.isEmpty(name) || Const.isEmpty(value)) continue;
                SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd'T'HH:mm:ss");
                try {
                    ConceptPropertyDate conceptPropertyDate = new ConceptPropertyDate(name, df.parse(value));
                    concept.addProperty(conceptPropertyDate);
                }
                catch (ParseException e) {
                    logger.error((Object)Messages.getString("CwmSchemaFactory.ERROR_FAILED_TO_PARSE_DATE", value), (Throwable)e);
                }
                continue;
            }
            if (type.equals(ConceptPropertyType.TABLETYPE.getCode())) {
                if (Const.isEmpty(name) || Const.isEmpty(value)) continue;
                property2 = new ConceptPropertyTableType(name, TableTypeSettings.getType(value));
                concept.addProperty(property2);
                continue;
            }
            if (type.equals(ConceptPropertyType.FIELDTYPE.getCode())) {
                if (Const.isEmpty(name) || Const.isEmpty(value)) continue;
                property2 = new ConceptPropertyFieldType(name, FieldTypeSettings.getType(value));
                concept.addProperty(property2);
                continue;
            }
            if (type.equals(ConceptPropertyType.AGGREGATION.getCode())) {
                if (Const.isEmpty(name) || Const.isEmpty(value)) continue;
                property2 = new ConceptPropertyAggregation(name, AggregationSettings.getType(value));
                concept.addProperty(property2);
                continue;
            }
            if (type.equals(ConceptPropertyType.AGGREGATION_LIST.getCode())) {
                if (Const.isEmpty(name) || Const.isEmpty(value)) continue;
                try {
                    List<AggregationSettings> list = ConceptPropertyAggregationList.fromXML(value);
                    property = new ConceptPropertyAggregationList(name, list);
                    concept.addProperty(property);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                continue;
            }
            if (type.equals(ConceptPropertyType.NUMBER.getCode())) {
                if (Const.isEmpty(name) || Const.isEmpty(value)) continue;
                property2 = new ConceptPropertyNumber(name, new BigDecimal(value));
                concept.addProperty(property2);
                continue;
            }
            if (type.equals(ConceptPropertyType.COLOR.getCode())) {
                if (Const.isEmpty(name) || Const.isEmpty(value)) continue;
                ColorSettings colorSettings = ColorSettings.fromString(value);
                if (colorSettings != null) {
                    property = new ConceptPropertyColor(name, colorSettings);
                    concept.addProperty(property);
                    continue;
                }
                logger.error((Object)Messages.getString("CwmSchemaFactory.ERROR_FAILED_TO_PARSE_COLOR", value));
                continue;
            }
            if (type.equals(ConceptPropertyType.DATATYPE.getCode())) {
                if (Const.isEmpty(name) || Const.isEmpty(value)) continue;
                DataTypeSettings dataType = DataTypeSettings.fromString(value);
                if (dataType != null) {
                    property = new ConceptPropertyDataType(name, dataType);
                    concept.addProperty(property);
                    continue;
                }
                logger.error((Object)Messages.getString("CwmSchemaFactory.ERROR_FAILED_TO_PARSE_DATA_TYPE", value));
                continue;
            }
            if (type.equals(ConceptPropertyType.FONT.getCode())) {
                if (Const.isEmpty(name) || Const.isEmpty(value)) continue;
                FontSettings fontSettings = FontSettings.fromString(value);
                if (fontSettings != null) {
                    property = new ConceptPropertyFont(name, fontSettings);
                    concept.addProperty(property);
                    continue;
                }
                logger.error((Object)Messages.getString("CwmSchemaFactory.ERROR_FAILED_TO_PARSE_FONT", value));
                continue;
            }
            if (type.equals(ConceptPropertyType.URL.getCode())) {
                if (Const.isEmpty(name) || Const.isEmpty(value)) continue;
                try {
                    URL url = new URL(value);
                    property = new ConceptPropertyURL(name, url);
                    concept.addProperty(property);
                }
                catch (Exception e) {
                    logger.error((Object)Messages.getString("CwmSchemaFactory.ERROR_MALFORMED_URL", value), (Throwable)e);
                }
                continue;
            }
            if (type.equals(ConceptPropertyType.SECURITY.getCode())) {
                if (Const.isEmpty(name) || Const.isEmpty(value)) continue;
                try {
                    Security security = Security.fromXML(value);
                    property = new ConceptPropertySecurity(name, security);
                    concept.addProperty(property);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                continue;
            }
            if (type.equals(ConceptPropertyType.ROW_LEVEL_SECURITY.getCode())) {
                if (Const.isEmpty(name) || Const.isEmpty(value)) continue;
                try {
                    RowLevelSecurity rowLevelSecurity = RowLevelSecurity.fromXML(value);
                    property = new ConceptPropertyRowLevelSecurity(name, rowLevelSecurity);
                    concept.addProperty(property);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                continue;
            }
            if (type.equals(ConceptPropertyType.ALIGNMENT.getCode())) {
                if (Const.isEmpty(name) || Const.isEmpty(value)) continue;
                AlignmentSettings alignment = AlignmentSettings.fromString(value);
                if (alignment != null) {
                    property = new ConceptPropertyAlignment(name, alignment);
                    concept.addProperty(property);
                    continue;
                }
                logger.error((Object)Messages.getString("CwmSchemaFactory.ERROR_UNRECOGNIZED_ALIGNMENT_SETTING", value));
                continue;
            }
            if (type.equals(ConceptPropertyType.COLUMN_WIDTH.getCode())) {
                if (Const.isEmpty(name) || Const.isEmpty(value)) continue;
                ColumnWidth colWidth = ColumnWidth.fromString(value);
                if (colWidth != null) {
                    property = new ConceptPropertyColumnWidth(name, colWidth);
                    concept.addProperty(property);
                    continue;
                }
                logger.error((Object)Messages.getString("CwmSchemaFactory.ERROR_UNRECOGNIZED_COLUMN_WIDTH", value));
                continue;
            }
            logger.error((Object)Messages.getString("CwmSchemaFactory.ERROR_UNRECOGNIZED_TYPE", type));
        }
    }

    private void storeOlapCube(CWM cwm, org.pentaho.pms.cwm.pentaho.meta.olap.CwmSchema cwmOlapSchema, OlapCube cube) {
        CwmCube cwmOlapCube = cwm.createOlapCube(cube.getName());
        cwmOlapCube.setSchema(cwmOlapSchema);
        cwm.addTaggedValue((CwmModelElement)cwmOlapCube, "CUBE_BUSINESS_TABLE", cube.getBusinessTable().getId());
        List<OlapDimensionUsage> usages = cube.getOlapDimensionUsages();
        for (int i = 0; i < usages.size(); ++i) {
            OlapDimensionUsage usage = usages.get(i);
            org.pentaho.pms.cwm.pentaho.meta.olap.CwmDimension cwmOlapDimension = null;
            Collection dimensions = cwmOlapSchema.getDimension();
            Iterator iter = dimensions.iterator();
            while (iter.hasNext() && cwmOlapDimension == null) {
                org.pentaho.pms.cwm.pentaho.meta.olap.CwmDimension lookup = (org.pentaho.pms.cwm.pentaho.meta.olap.CwmDimension)iter.next();
                if (!lookup.getName().equals(usage.getName())) continue;
                cwmOlapDimension = lookup;
            }
            if (cwmOlapDimension == null) continue;
            CwmCubeDimensionAssociation cwmCubeDimensionAssociation = cwm.createCubeDimensionAssocation(usage.getName());
            cwmCubeDimensionAssociation.setCube(cwmOlapCube);
            cwmCubeDimensionAssociation.setDimension(cwmOlapDimension);
            Collection cu = cwmOlapCube.getCubeDimensionAssociation();
            cu.add(cwmCubeDimensionAssociation);
        }
        List<OlapMeasure> measures = cube.getOlapMeasures();
        for (int i = 0; i < measures.size(); ++i) {
            OlapMeasure olapMeasure = measures.get(i);
            CwmMeasure cwmMeasure = cwm.createMeasure(olapMeasure.getName());
            cwm.addTaggedValue((CwmModelElement)cwmMeasure, "MEASURE_BUSINESS_COLUMN", olapMeasure.getBusinessColumn().getId());
            Collection cu = cwmOlapCube.getOwnedElement();
            cu.add(cwmMeasure);
        }
        Collection cu = cwmOlapSchema.getCube();
        cu.add(cwmOlapCube);
    }

    private OlapCube getOlapCube(CWM cwm, CwmCube cwmCube, BusinessModel businessModel) {
        OlapCube olapCube = new OlapCube();
        olapCube.setName(cwmCube.getName());
        olapCube.setBusinessTable(businessModel.findBusinessTable(cwm.getFirstTaggedValue((CwmModelElement)cwmCube, "CUBE_BUSINESS_TABLE")));
        Collection associations = cwmCube.getCubeDimensionAssociation();
        for (CwmCubeDimensionAssociation association : associations) {
            org.pentaho.pms.cwm.pentaho.meta.olap.CwmDimension cwmOlapDimension = association.getDimension();
            OlapDimension olapDimension = null;
            List<OlapDimension> olapDimensions = businessModel.getOlapDimensions();
            Iterator<OlapDimension> iterator = olapDimensions.iterator();
            while (iterator.hasNext() && olapDimension == null) {
                OlapDimension lookup = iterator.next();
                if (!lookup.getName().equals(cwmOlapDimension.getName())) continue;
                olapDimension = lookup;
            }
            if (olapDimension == null) continue;
            OlapDimensionUsage usage = new OlapDimensionUsage(association.getName(), olapDimension);
            olapCube.getOlapDimensionUsages().add(usage);
        }
        Collection ownedElements = cwmCube.getOwnedElement();
        for (CwmMeasure cwmMeasure : ownedElements) {
            OlapMeasure olapMeasure = new OlapMeasure();
            olapMeasure.setName(cwmMeasure.getName());
            BusinessColumn businessColumn = businessModel.findBusinessColumn(cwm.getFirstTaggedValue((CwmModelElement)cwmMeasure, "MEASURE_BUSINESS_COLUMN"));
            olapMeasure.setBusinessColumn(businessColumn);
            olapCube.getOlapMeasures().add(olapMeasure);
        }
        return olapCube;
    }

    public void storeOlapDimension(CWM cwm, org.pentaho.pms.cwm.pentaho.meta.olap.CwmSchema cwmOlapSchema, OlapDimension olapDimension) {
        org.pentaho.pms.cwm.pentaho.meta.olap.CwmDimension cwmOlapDimension = cwm.createOlapDimension(olapDimension.getName());
        cwmOlapDimension.setTime(olapDimension.isTimeDimension());
        List<OlapHierarchy> hierarchies = olapDimension.getHierarchies();
        for (int i = 0; i < hierarchies.size(); ++i) {
            OlapHierarchy olapHierarchy = hierarchies.get(i);
            this.storeOlapHierachy(cwm, olapHierarchy, cwmOlapDimension);
        }
        Collection cd = cwmOlapSchema.getDimension();
        cd.add(cwmOlapDimension);
    }

    public OlapDimension getOlapDimension(CWM cwm, org.pentaho.pms.cwm.pentaho.meta.olap.CwmDimension cwmOlapDimension, BusinessModel businessModel) {
        OlapDimension olapDimension = new OlapDimension();
        olapDimension.setName(cwmOlapDimension.getName());
        olapDimension.setTimeDimension(cwmOlapDimension.isTime());
        Collection cwmHierarchies = cwmOlapDimension.getHierarchy();
        for (CwmLevelBasedHierarchy cwmHierarchy : cwmHierarchies) {
            OlapHierarchy olapHierarchy = this.getOlapHierarchy(cwm, cwmHierarchy, olapDimension, businessModel);
            olapDimension.getHierarchies().add(olapHierarchy);
        }
        return olapDimension;
    }

    public void storeOlapHierachy(CWM cwm, OlapHierarchy olapHierarchy, org.pentaho.pms.cwm.pentaho.meta.olap.CwmDimension cwmOlapDimension) {
        CwmLevelBasedHierarchy cwmHierarchy = cwm.createLevelBasedHierarchy(olapHierarchy.getName());
        cwmHierarchy.setDimension(cwmOlapDimension);
        cwm.addTaggedValue((CwmModelElement)cwmHierarchy, "HIERARCHY_BUSINESS_TABLE", olapHierarchy.getBusinessTable().getId());
        if (olapHierarchy.getPrimaryKey() != null) {
            cwm.addTaggedValue((CwmModelElement)cwmHierarchy, "HIERARCHY_PRIMARY_KEY", olapHierarchy.getPrimaryKey().getId());
        }
        cwm.addTaggedValue((CwmModelElement)cwmHierarchy, "HIERARCHY_HAVING_ALL", olapHierarchy.isHavingAll() ? "Y" : "N");
        List<OlapHierarchyLevel> levels = olapHierarchy.getHierarchyLevels();
        for (int i = 0; i < levels.size(); ++i) {
            OlapHierarchyLevel level = levels.get(i);
            this.storeOlapHierarchyLevel(cwm, level, cwmHierarchy, cwmOlapDimension);
        }
        Collection ch = cwmOlapDimension.getHierarchy();
        ch.add(cwmHierarchy);
    }

    public OlapHierarchy getOlapHierarchy(CWM cwm, CwmLevelBasedHierarchy cwmHierarchy, OlapDimension olapDimension, BusinessModel businessModel) {
        OlapHierarchy olapHierarchy = new OlapHierarchy(olapDimension);
        olapHierarchy.setName(cwmHierarchy.getName());
        olapHierarchy.setBusinessTable(businessModel.findBusinessTable(cwm.getFirstTaggedValue((CwmModelElement)cwmHierarchy, "HIERARCHY_BUSINESS_TABLE")));
        olapHierarchy.setPrimaryKey(businessModel.findBusinessColumn(cwm.getFirstTaggedValue((CwmModelElement)cwmHierarchy, "HIERARCHY_PRIMARY_KEY")));
        olapHierarchy.setHavingAll("Y".equalsIgnoreCase(cwm.getFirstTaggedValue((CwmModelElement)cwmHierarchy, "HIERARCHY_HAVING_ALL")));
        List associations = cwmHierarchy.getHierarchyLevelAssociation();
        for (CwmHierarchyLevelAssociation association : associations) {
            OlapHierarchyLevel olapLevel = this.getOlapHierarchyLevel(cwm, olapHierarchy, association, businessModel);
            olapHierarchy.getHierarchyLevels().add(olapLevel);
        }
        return olapHierarchy;
    }

    public void storeOlapHierarchyLevel(CWM cwm, OlapHierarchyLevel level, CwmLevelBasedHierarchy cwmLevelBasedHierarchy, org.pentaho.pms.cwm.pentaho.meta.olap.CwmDimension cwmOlapDimension) {
        CwmLevel cwmLevel = cwm.createLevel(level.getName());
        cwmLevel.setDimension(cwmOlapDimension);
        CwmHierarchyLevelAssociation cwmHierarchyLevelAssociation = cwm.createHierarchyLevelAssociation(level.getName());
        cwmHierarchyLevelAssociation.setCurrentLevel(cwmLevel);
        List ch = cwmLevelBasedHierarchy.getHierarchyLevelAssociation();
        ch.add(cwmHierarchyLevelAssociation);
        cwm.addTaggedValue((CwmModelElement)cwmLevel, "HIERARCHY_LEVEL_UNIQUE_MEMBERS", level.isHavingUniqueMembers() ? "Y" : "N");
        cwm.addTaggedValue((CwmModelElement)cwmLevel, "HIERARCHY_LEVEL_REFERENCE_COLUMN", level.getReferenceColumn().getId());
        List<BusinessColumn> columns = level.getBusinessColumns();
        for (int i = columns.size() - 1; i >= 0; --i) {
            BusinessColumn businessColumn = columns.get(i);
            CwmDimensionedObject cwmDimensionedObject = cwm.createDimensionedObject(businessColumn.getId());
            Collection c = cwmLevel.getOwnedElement();
            c.add(cwmDimensionedObject);
        }
    }

    public OlapHierarchyLevel getOlapHierarchyLevel(CWM cwm, OlapHierarchy olapHierarchy, CwmHierarchyLevelAssociation association, BusinessModel businessModel) {
        OlapHierarchyLevel olapLevel = new OlapHierarchyLevel(olapHierarchy);
        olapLevel.setName(association.getName());
        CwmLevel cwmLevel = association.getCurrentLevel();
        olapLevel.setHavingUniqueMembers("Y".equalsIgnoreCase(cwm.getFirstTaggedValue((CwmModelElement)cwmLevel, "HIERARCHY_LEVEL_UNIQUE_MEMBERS")));
        olapLevel.setReferenceColumn(businessModel.findBusinessColumn(cwm.getFirstTaggedValue((CwmModelElement)cwmLevel, "HIERARCHY_LEVEL_REFERENCE_COLUMN")));
        Collection ownedElements = cwmLevel.getOwnedElement();
        for (CwmDimensionedObject cwmDimensionedObject : ownedElements) {
            BusinessColumn column = businessModel.findBusinessColumn(cwmDimensionedObject.getName());
            olapLevel.getBusinessColumns().add(column);
        }
        return olapLevel;
    }

    public boolean hasAccess(int accessType, ConceptUtilityInterface aclHolder) {
        return true;
    }

    public String generateRowLevelSecurityConstraint(BusinessModel businessModel) {
        return null;
    }
}

