/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.locale;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.di.core.changed.ChangedFlag;
import org.pentaho.pms.locale.LocaleInterface;
import org.pentaho.pms.locale.LocaleMeta;
import org.pentaho.pms.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Locales
extends ChangedFlag {
    public static final String EN_US = "en_US";
    private List<LocaleInterface> localeList = new ArrayList<LocaleInterface>();

    public Locales() {
        this.setDefault();
    }

    public void setDefault() {
        LocaleMeta locale = new LocaleMeta(EN_US, Messages.getString("Locales.USER_LOCALE_DESCRIPTION"), 1, true);
        this.addLocale(locale);
    }

    public List getLocaleList() {
        return this.localeList;
    }

    public void setLocaleList(List<LocaleInterface> locales) {
        this.localeList = locales;
    }

    public int nrLocales() {
        return this.localeList.size();
    }

    public LocaleInterface getLocale(int i) {
        return this.localeList.get(i);
    }

    public void removeLocale(int i) {
        this.localeList.remove(i);
        this.setChanged(true);
    }

    public void addLocale(LocaleInterface locale) {
        this.localeList.add(locale);
        this.setChanged(true);
    }

    public void addLocale(int index, LocaleInterface locale) {
        this.localeList.add(index, locale);
        this.setChanged(true);
    }

    public int indexOfLocale(LocaleInterface locale) {
        return this.localeList.indexOf(locale);
    }

    public void setLocale(int idx, LocaleInterface locale) {
        this.localeList.set(idx, locale);
        this.setChanged(true);
    }

    public String getActiveLocale() {
        for (int i = 0; i < this.nrLocales(); ++i) {
            if (!this.getLocale(i).isActive()) continue;
            return this.getLocale(i).getCode();
        }
        return EN_US;
    }

    public void setActiveLocale(String activeLocale) {
        for (int i = 0; i < this.nrLocales(); ++i) {
            LocaleInterface locale = this.getLocale(i);
            locale.setActive(locale.getCode().equalsIgnoreCase(activeLocale));
        }
    }

    public void clearChanged() {
        this.setChanged(false);
    }

    public String[] getLocaleCodes() {
        String[] codes = new String[this.localeList.size()];
        for (int i = 0; i < codes.length; ++i) {
            codes[i] = this.getLocale(i).getCode();
        }
        return codes;
    }

    public void sortLocales() {
        Collections.sort(this.localeList);
    }
}

