/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.messages.Messages;
import org.pentaho.pms.mql.PMSFormulaContext;
import org.pentaho.pms.mql.SQLAndTables;
import org.pentaho.pms.mql.SQLGenerator;
import org.pentaho.pms.mql.Selection;
import org.pentaho.pms.mql.dialect.FormulaTraversalInterface;
import org.pentaho.pms.mql.dialect.SQLDialectFactory;
import org.pentaho.pms.mql.dialect.SQLDialectInterface;
import org.pentaho.pms.mql.dialect.SQLFunctionGeneratorInterface;
import org.pentaho.pms.mql.dialect.SQLOperatorGeneratorInterface;
import org.pentaho.pms.schema.BusinessCategory;
import org.pentaho.pms.schema.BusinessColumn;
import org.pentaho.pms.schema.BusinessModel;
import org.pentaho.pms.schema.BusinessTable;
import org.pentaho.pms.schema.concept.types.aggregation.AggregationSettings;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.lvalues.ContextLookup;
import org.pentaho.reporting.libraries.formula.lvalues.FormulaFunction;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.PrefixTerm;
import org.pentaho.reporting.libraries.formula.lvalues.StaticValue;
import org.pentaho.reporting.libraries.formula.lvalues.Term;
import org.pentaho.reporting.libraries.formula.operators.InfixOperator;
import org.pentaho.reporting.libraries.formula.parser.ParseException;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMSFormula
implements FormulaTraversalInterface {
    private static final Log logger = LogFactory.getLog(PMSFormula.class);
    private List<BusinessTable> tables;
    private BusinessModel model = null;
    private DatabaseMeta databaseMeta = null;
    private Formula formulaObject = null;
    private Map<String, Selection> businessColumnMap = new HashMap<String, Selection>();
    private Map<BusinessTable, String> tableAliases;
    private List<Selection> businessColumnList = new ArrayList<Selection>();
    private PMSFormulaContext formulaContext = PMSFormulaContext.getInstance();
    private SQLDialectInterface sqlDialect = null;
    private boolean isValidated = false;
    private boolean allowAggregateFunctions = false;
    private boolean hasAggregateFunction = false;
    private String formulaString;

    public PMSFormula(BusinessModel model, DatabaseMeta databaseMeta, String formulaString, Map<BusinessTable, String> tableAliases) throws PentahoMetadataException {
        this.model = model;
        this.formulaString = formulaString;
        this.databaseMeta = databaseMeta;
        this.tableAliases = tableAliases;
        this.tables = new ArrayList<BusinessTable>();
        if (model == null) {
            throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0001_NO_BUSINESS_MODEL_PROVIDED"));
        }
        if (databaseMeta == null) {
            throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0002_NO_DATABASE_META_PROVIDED"));
        }
        this.sqlDialect = SQLDialectFactory.getSQLDialect(databaseMeta);
        if (this.sqlDialect == null) {
            throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0018_DATABASE_DIALECT_NOT_FOUND", databaseMeta.getDatabaseTypeDesc()));
        }
        if (formulaString == null) {
            throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0003_NO_FORMULA_STRING_PROVIDED"));
        }
    }

    public PMSFormula(BusinessModel model, BusinessTable table, DatabaseMeta databaseMeta, String formulaString, Map<BusinessTable, String> tableAliases) throws PentahoMetadataException {
        this.model = model;
        this.formulaString = formulaString;
        this.databaseMeta = databaseMeta;
        this.tableAliases = tableAliases;
        this.tables = new ArrayList<BusinessTable>();
        this.tables.add(table);
        if (model == null) {
            throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0001_NO_BUSINESS_MODEL_PROVIDED"));
        }
        if (databaseMeta == null) {
            throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0002_NO_DATABASE_META_PROVIDED"));
        }
        if (table == null) {
            throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0004_NO_BUSINESS_TABLE_PROVIDED"));
        }
        this.sqlDialect = SQLDialectFactory.getSQLDialect(databaseMeta);
        if (this.sqlDialect == null) {
            throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0017_DATABASE_DIALECT_NOT_FOUND", databaseMeta.getDatabaseTypeDesc()));
        }
        if (formulaString == null) {
            throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0003_NO_FORMULA_STRING_PROVIDED"));
        }
    }

    public PMSFormula(BusinessModel model, String formulaString, Map<BusinessTable, String> tableAliases) throws PentahoMetadataException {
        this.model = model;
        this.formulaString = formulaString;
        this.tableAliases = tableAliases;
        this.tables = new ArrayList<BusinessTable>();
        if (model == null) {
            throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0001_NO_BUSINESS_MODEL_PROVIDED"));
        }
        if (model.nrBusinessTables() > 0) {
            this.databaseMeta = model.getBusinessTable(0).getPhysicalTable().getDatabaseMeta();
        }
        if (this.databaseMeta == null) {
            throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0002_NO_DATABASE_META_PROVIDED"));
        }
        this.sqlDialect = SQLDialectFactory.getSQLDialect(this.databaseMeta);
        if (this.sqlDialect == null) {
            throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0017_DATABASE_DIALECT_NOT_FOUND", this.databaseMeta.getDatabaseTypeDesc()));
        }
        if (formulaString == null) {
            throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0003_NO_FORMULA_STRING_PROVIDED"));
        }
    }

    public PMSFormula(BusinessModel model, BusinessTable table, String formulaString, Map<BusinessTable, String> tableAliases) throws PentahoMetadataException {
        this(model, formulaString, tableAliases);
        this.tables.add(table);
        if (table == null) {
            throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0004_NO_BUSINESS_TABLE_PROVIDED"));
        }
    }

    public void setTableAliases(Map<BusinessTable, String> tableAliases) {
        this.tableAliases = tableAliases;
    }

    protected DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public List<BusinessTable> getBusinessTables() {
        return this.tables;
    }

    protected BusinessModel getBusinessModel() {
        return this.model;
    }

    protected Map getBusinessColumnMap() {
        return this.businessColumnMap;
    }

    @Override
    public Object getParameterValue(ContextLookup lookup) throws PentahoMetadataException {
        throw new UnsupportedOperationException();
    }

    public void parseAndValidate() throws PentahoMetadataException {
        if (!this.isValidated) {
            try {
                this.formulaObject = new Formula(this.formulaString);
                this.formulaObject.initialize((FormulaContext)this.formulaContext);
                LValue val = this.formulaObject.getRootReference();
                this.validateAndResolveObjectModel(val);
                this.isValidated = true;
            }
            catch (ParseException e) {
                logger.error((Object)"an exception occurred", (Throwable)e);
                throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0005_FAILED_TO_PARSE_FORMULA", this.formulaString));
            }
            catch (EvaluationException e) {
                logger.error((Object)"an exception occurred", (Throwable)e);
                throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0006_FAILED_TO_EVALUATE_FORMULA", this.formulaString));
            }
            catch (Throwable e) {
                if (e instanceof PentahoMetadataException) {
                    throw (PentahoMetadataException)e;
                }
                logger.error((Object)"an exception occurred", e);
                throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0007_UNKNOWN_ERROR", this.formulaString));
            }
        }
    }

    protected void addField(String fieldName) throws PentahoMetadataException {
        if (fieldName == null) {
            throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0008_FIELDNAME_NULL", this.formulaString));
        }
        if (!this.businessColumnMap.containsKey(fieldName)) {
            String aggregation;
            if (fieldName.indexOf(".") < 0) {
                if (this.tables == null) {
                    throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0009_FIELDNAME_ERROR_NO_BUSINESS_TABLE", fieldName));
                }
                for (BusinessTable businessTable : this.tables) {
                    for (BusinessColumn businessColumn : businessTable.getBusinessColumns()) {
                        if (businessColumn.isExact() || !fieldName.equals(businessColumn.getFormula())) continue;
                        return;
                    }
                }
                throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0010_FIELDNAME_ERROR_COLUMN_NOT_FOUND", fieldName, fieldName, PMSFormula.toString(this.getBusinessTableIDs())));
            }
            String[] tblcol = fieldName.split("\\.");
            if (tblcol.length != 2 && tblcol.length != 3) {
                throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0011_INVALID_FIELDNAME", fieldName));
            }
            BusinessColumn column = null;
            BusinessTable businessTable = null;
            for (BusinessTable table : this.tables) {
                if (!table.getId().equalsIgnoreCase(tblcol[0])) continue;
                businessTable = table;
                break;
            }
            if (businessTable != null) {
                column = businessTable.findBusinessColumn(tblcol[1]);
                if (column == null) {
                    throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0019_FIELDNAME_ERROR_CAT_COLUMN_NOT_FOUND", fieldName, tblcol[0], tblcol[1]));
                }
            } else {
                BusinessTable bizTable = this.model.findBusinessTable(tblcol[0]);
                if (bizTable == null) {
                    BusinessCategory businessCategory = this.model.getRootCategory().findBusinessCategory(tblcol[0]);
                    if (businessCategory == null) {
                        throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0012_FIELDNAME_ERROR_PARENT_NOT_FOUND", fieldName, tblcol[0]));
                    }
                    column = businessCategory.findBusinessColumn(tblcol[1]);
                    if (column == null) {
                        throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0010_FIELDNAME_ERROR_COLUMN_NOT_FOUND", fieldName, tblcol[1], tblcol[0]));
                    }
                } else {
                    column = bizTable.findBusinessColumn(tblcol[1]);
                    if (column == null) {
                        throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0010_FIELDNAME_ERROR_COLUMN_NOT_FOUND", fieldName, tblcol[1], tblcol[0]));
                    }
                    this.tables.add(bizTable);
                }
            }
            AggregationSettings aggsetting = null;
            if (tblcol.length == 3 && (aggregation = tblcol[2]) != null) {
                AggregationSettings setting = AggregationSettings.getType(aggregation);
                if (column.getAggregationType() == setting || column.getAggregationList() != null && column.getAggregationList().contains(setting)) {
                    aggsetting = setting;
                }
            }
            Selection selection = new Selection(column, aggsetting);
            this.businessColumnMap.put(fieldName, selection);
            this.businessColumnList.add(selection);
        }
    }

    public static String toString(Object[] arr) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateAndResolveObjectModel(Object val) throws PentahoMetadataException {
        if (val instanceof Term) {
            Term t = (Term)val;
            this.validateAndResolveObjectModel(t.getHeadValue());
            for (int i = 0; i < t.getOperators().length; ++i) {
                this.validateAndResolveObjectModel(t.getOperators()[i]);
                this.validateAndResolveObjectModel(t.getOperands()[i]);
            }
            return;
        } else if (val instanceof ContextLookup) {
            ContextLookup l = (ContextLookup)val;
            this.addField(l.getName());
            return;
        } else {
            if (val instanceof StaticValue) {
                return;
            }
            if (val instanceof FormulaFunction) {
                FormulaFunction f = (FormulaFunction)val;
                if (!this.sqlDialect.isSupportedFunction(f.getFunctionName())) throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0014_FUNCTION_NOT_SUPPORTED", f.getFunctionName()));
                SQLFunctionGeneratorInterface gen = this.sqlDialect.getFunctionSQLGenerator(f.getFunctionName());
                gen.validateFunction(f);
                if (!this.allowAggregateFunctions && this.tables == null && this.sqlDialect.isAggregateFunction(f.getFunctionName())) {
                    throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0013_AGGREGATE_USAGE_ERROR", f.getFunctionName(), this.formulaString));
                }
                if (this.sqlDialect.isAggregateFunction(f.getFunctionName())) {
                    this.hasAggregateFunction = true;
                }
                if (f.getChildValues() == null || f.getChildValues().length <= 0) return;
                this.validateAndResolveObjectModel(f.getChildValues()[0]);
                for (int i = 1; i < f.getChildValues().length; ++i) {
                    this.validateAndResolveObjectModel(f.getChildValues()[i]);
                }
                return;
            } else {
                if (val instanceof InfixOperator) {
                    if (!this.sqlDialect.isSupportedInfixOperator(val.toString())) throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0021_OPERATOR_NOT_SUPPORTED", val.toString()));
                    return;
                }
                if (!(val instanceof PrefixTerm)) throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0016_CLASS_TYPE_NOT_SUPPORTED", val.getClass().toString()));
                return;
            }
        }
    }

    public boolean requiresParens(Object parent, Object val) {
        boolean parentMatch = false;
        if (parent instanceof Term) {
            parentMatch = true;
        } else if (parent instanceof FormulaFunction) {
            FormulaFunction parentFunction = (FormulaFunction)parent;
            SQLFunctionGeneratorInterface parentGen = this.sqlDialect.getFunctionSQLGenerator(parentFunction.getFunctionName());
            boolean bl = parentMatch = parentGen.getType() == 0;
        }
        if (!parentMatch) {
            return false;
        }
        if (val instanceof InfixOperator) {
            return true;
        }
        if (val instanceof FormulaFunction) {
            FormulaFunction f = (FormulaFunction)val;
            SQLFunctionGeneratorInterface gen = this.sqlDialect.getFunctionSQLGenerator(f.getFunctionName());
            return gen.getType() == 0;
        }
        return false;
    }

    @Override
    public void generateSQL(Object parent, Object val, StringBuffer sb, String locale) throws PentahoMetadataException {
        if (val instanceof Term) {
            boolean addParens;
            Term t = (Term)val;
            boolean bl = addParens = t.getOperators().length > 1 || this.requiresParens(parent, t.getOperators()[0]);
            if (addParens) {
                sb.append("(");
            }
            this.generateSQL(t, t.getHeadValue(), sb, locale);
            for (int i = 0; i < t.getOperators().length; ++i) {
                this.generateSQL(t, t.getOperators()[i], sb, locale);
                this.generateSQL(t, t.getOperands()[i], sb, locale);
            }
            if (addParens) {
                sb.append(")");
            }
        } else if (val instanceof ContextLookup) {
            ContextLookup l = (ContextLookup)val;
            this.renderContextLookup(sb, l.getName(), locale);
        } else if (val instanceof StaticValue) {
            StaticValue v = (StaticValue)val;
            if (v.getValueType() instanceof TextType) {
                sb.append(this.sqlDialect.quoteStringLiteral(v.getValue()));
            } else {
                sb.append(v.getValue());
            }
        } else if (val instanceof FormulaFunction) {
            FormulaFunction f = (FormulaFunction)val;
            SQLFunctionGeneratorInterface gen = this.sqlDialect.getFunctionSQLGenerator(f.getFunctionName());
            boolean addParens = this.requiresParens(parent, f);
            if (addParens) {
                sb.append("(");
            }
            gen.generateFunctionSQL(this, sb, locale, f);
            if (addParens) {
                sb.append(")");
            }
        } else if (val instanceof InfixOperator) {
            if (this.sqlDialect.isSupportedInfixOperator(val.toString())) {
                SQLOperatorGeneratorInterface gen = this.sqlDialect.getInfixOperatorSQLGenerator(val.toString());
                sb.append(" " + gen.getOperatorSQL() + " ");
            }
        } else if (val instanceof PrefixTerm) {
            PrefixTerm v = (PrefixTerm)val;
            sb.append(v.toString());
        } else {
            throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0016_CLASS_TYPE_NOT_SUPPORTED", val.getClass().toString()));
        }
    }

    protected void renderContextLookup(StringBuffer sb, String contextName, String locale) {
        Selection column = this.businessColumnMap.get(contextName);
        if (column == null) {
            String tableColumn = "";
            sb.append(" ");
            BusinessTable businessTable = this.findBusinessTableForContextName(contextName, locale);
            if (businessTable != null) {
                String tableAlias = null;
                tableAlias = this.tableAliases != null ? this.tableAliases.get(businessTable) : businessTable.getId();
                sb.append(this.databaseMeta.quoteField(tableAlias));
                sb.append(".");
            }
            sb.append(this.databaseMeta.quoteField(contextName));
            sb.append(" ");
        } else {
            sb.append(" ");
            SQLAndTables sqlAndTables = SQLGenerator.getBusinessColumnSQL(this.model, column, this.tableAliases, this.databaseMeta, locale);
            sb.append(sqlAndTables.getSql());
            sb.append(" ");
            for (BusinessTable businessTable : sqlAndTables.getUsedTables()) {
                if (this.tables.contains(businessTable)) continue;
                this.tables.add(businessTable);
            }
        }
    }

    public String generateSQL(String locale) throws PentahoMetadataException {
        if (!this.isValidated) {
            throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0017_STATE_ERROR_NOT_VALIDATED"));
        }
        StringBuffer sb = new StringBuffer();
        this.generateSQL(null, this.formulaObject.getRootReference(), sb, locale);
        return sb.toString();
    }

    public List<Selection> getBusinessColumns() {
        return this.businessColumnList;
    }

    public String[] getBusinessTableIDs() {
        String[] names = new String[this.tables.size()];
        for (int i = 0; i < this.tables.size(); ++i) {
            names[i] = this.tables.get(i).getId();
        }
        return names;
    }

    public boolean hasAggregateFunction() {
        return this.hasAggregateFunction;
    }

    public void setAllowAggregateFunctions(boolean allowAggregateFunctions) {
        this.allowAggregateFunctions = allowAggregateFunctions;
    }

    protected BusinessTable findBusinessTableForContextName(String contextName, String locale) {
        BusinessTable businessTable = null;
        for (BusinessTable table : this.getBusinessTables()) {
            BusinessColumn c = table.findBusinessColumn(contextName);
            if (c == null) {
                c = table.findBusinessColumn(locale, contextName);
            }
            for (BusinessColumn col : table.getBusinessColumns()) {
                if (col.getFormula() == null || !col.getFormula().equals(contextName)) continue;
                c = col;
                break;
            }
            if (c == null) continue;
            businessTable = c.getBusinessTable();
        }
        return businessTable;
    }
}

