/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql.dialect;

import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.mql.dialect.DefaultSQLDialect;
import org.pentaho.pms.mql.dialect.DefaultSQLFunctionGenerator;
import org.pentaho.pms.mql.dialect.FormulaTraversalInterface;
import org.pentaho.pms.mql.dialect.SQLQueryModel;
import org.pentaho.reporting.libraries.formula.lvalues.FormulaFunction;

public class DB2Dialect
extends DefaultSQLDialect {
    public DB2Dialect() {
        super("DB2");
        this.supportedFunctions.put("NOW", new DefaultSQLFunctionGenerator(1, "( CURRENT DATE )", 0){

            public void generateFunctionSQL(FormulaTraversalInterface formula, StringBuffer sb, String locale, FormulaFunction f) throws PentahoMetadataException {
                sb.append(this.sql);
            }
        });
        this.supportedFunctions.put("TRUE", new DefaultSQLFunctionGenerator(1, "TRUE()", 0){

            public void generateFunctionSQL(FormulaTraversalInterface formula, StringBuffer sb, String locale, FormulaFunction f) throws PentahoMetadataException {
                sb.append("1");
            }
        });
        this.supportedFunctions.put("FALSE", new DefaultSQLFunctionGenerator(1, "FALSE()", 0){

            public void generateFunctionSQL(FormulaTraversalInterface formula, StringBuffer sb, String locale, FormulaFunction f) throws PentahoMetadataException {
                sb.append("0");
            }
        });
    }

    public String getDateSQL(int year, int month, int day) {
        return "DATE(" + this.quoteStringLiteral(year + "-" + this.displayAsTwoOrMoreDigits(month) + "-" + this.displayAsTwoOrMoreDigits(day)) + ")";
    }

    public String getDateSQL(int year, int month, int day, int hour, int minute, int second, int milli) {
        return "TIMESTAMP(" + this.quoteStringLiteral("" + year + this.displayAsTwoOrMoreDigits(month) + this.displayAsTwoOrMoreDigits(day) + this.displayAsTwoOrMoreDigits(hour) + this.displayAsTwoOrMoreDigits(minute) + this.displayAsTwoOrMoreDigits(second)) + ")";
    }

    public int getMaxTableNameLength() {
        return 30;
    }

    protected String getStringConcatOperator() {
        return "||";
    }

    protected void generatePostOrderBy(SQLQueryModel query, StringBuilder sql) {
        if (query.getLimit() >= 0) {
            sql.append(" FETCH FIRST ");
            sql.append(query.getLimit());
            sql.append(" ROWS ONLY ");
        }
    }

    protected void generateSelectPredicate(SQLQueryModel query, StringBuilder sql) {
        this.generateDistinct(query, sql);
    }
}

