/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql.dialect;

import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.mql.dialect.DefaultSQLDialect;
import org.pentaho.pms.mql.dialect.DefaultSQLFunctionGenerator;
import org.pentaho.pms.mql.dialect.FormulaTraversalInterface;
import org.pentaho.pms.mql.dialect.SQLQueryModel;
import org.pentaho.reporting.libraries.formula.lvalues.FormulaFunction;

public class MSSQLDialect
extends DefaultSQLDialect {
    private static final String TOP_KEYWORD = "TOP";

    public MSSQLDialect() {
        this("MSSQL");
    }

    protected MSSQLDialect(String databaseType) {
        super(databaseType);
        this.supportedFunctions.put("NOW", new DefaultSQLFunctionGenerator(1, "GETDATE()", 0){

            public void generateFunctionSQL(FormulaTraversalInterface formula, StringBuffer sb, String locale, FormulaFunction f) throws PentahoMetadataException {
                sb.append(this.sql);
            }
        });
        this.supportedFunctions.put("TRUE", new DefaultSQLFunctionGenerator(1, "TRUE()", 0){

            public void generateFunctionSQL(FormulaTraversalInterface formula, StringBuffer sb, String locale, FormulaFunction f) throws PentahoMetadataException {
                sb.append("(1=1)");
            }
        });
        this.supportedFunctions.put("FALSE", new DefaultSQLFunctionGenerator(1, "FALSE()", 0){

            public void generateFunctionSQL(FormulaTraversalInterface formula, StringBuffer sb, String locale, FormulaFunction f) throws PentahoMetadataException {
                sb.append("(0=1)");
            }
        });
    }

    public String getDateSQL(int year, int month, int day) {
        return this.quoteStringLiteral(year + this.displayAsTwoOrMoreDigits(month) + this.displayAsTwoOrMoreDigits(day));
    }

    public int getMaxTableNameLength() {
        return 128;
    }

    public boolean supportsNLSLiteral() {
        return true;
    }

    protected String getStringConcatOperator() {
        return "+";
    }

    protected void generateSelectPredicate(SQLQueryModel query, StringBuilder sql) {
        this.generateTopAfterDistinct(query, sql, TOP_KEYWORD);
    }
}

