/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql.dialect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.pms.mql.dialect.JoinType;
import org.pentaho.pms.mql.dialect.SQLJoin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLQueryModel {
    private boolean delayOuterJoinConditions = false;
    private boolean distinct = true;
    private int limit = -1;
    private List<SQLSelection> selections = new ArrayList<SQLSelection>();
    private List<SQLSelection> ulSelections = Collections.unmodifiableList(this.selections);
    private List<SQLTable> tables = new ArrayList<SQLTable>();
    private List<SQLTable> ulTables = Collections.unmodifiableList(this.tables);
    private List<SQLWhereFormula> whereFormulas = new ArrayList<SQLWhereFormula>();
    private List<SQLWhereFormula> ulWhereFormulas = Collections.unmodifiableList(this.whereFormulas);
    private List<SQLJoin> joins = new ArrayList<SQLJoin>();
    private List<SQLJoin> ulJoins = Collections.unmodifiableList(this.joins);
    private List<SQLSelection> groupbys = new ArrayList<SQLSelection>();
    private List<SQLSelection> ulGroupbys = Collections.unmodifiableList(this.groupbys);
    private List<SQLWhereFormula> havings = new ArrayList<SQLWhereFormula>();
    private List<SQLWhereFormula> ulHavings = Collections.unmodifiableList(this.havings);
    private List<SQLOrderBy> orderbys = new ArrayList<SQLOrderBy>();
    private List<SQLOrderBy> ulOrderbys = Collections.unmodifiableList(this.orderbys);
    private SQLWhereFormula securityConstraint = null;

    public boolean getDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public List<SQLSelection> getSelections() {
        return this.ulSelections;
    }

    public void addSelection(String formula, String alias) {
        this.selections.add(new SQLSelection(formula, alias));
    }

    public List<SQLTable> getTables() {
        return this.ulTables;
    }

    public void addTable(String tableName, String alias) {
        this.tables.add(new SQLTable(tableName, alias));
    }

    public List<SQLWhereFormula> getWhereFormulas() {
        return this.ulWhereFormulas;
    }

    public void addWhereFormula(String formula, String operation) {
        this.whereFormulas.add(new SQLWhereFormula(formula, operation, false));
    }

    public void addWhereFormula(String formula, String operation, String[] involvedTables) {
        this.whereFormulas.add(new SQLWhereFormula(formula, operation, involvedTables, false));
    }

    public List<SQLSelection> getGroupBys() {
        return this.ulGroupbys;
    }

    public void addGroupBy(String formula, String alias) {
        this.groupbys.add(new SQLSelection(formula, alias));
    }

    public List<SQLWhereFormula> getHavings() {
        return this.ulHavings;
    }

    public void setSecurityConstraint(String formula, boolean having) {
        this.securityConstraint = new SQLWhereFormula(formula, "AND", having);
    }

    public SQLWhereFormula getSecurityConstraint() {
        return this.securityConstraint;
    }

    public void addHavingFormula(String formula, String operation) {
        this.havings.add(new SQLWhereFormula(formula, operation, true));
    }

    public void addHavingFormula(String formula, String operation, String[] involvedTables) {
        this.havings.add(new SQLWhereFormula(formula, operation, involvedTables, true));
    }

    public List<SQLOrderBy> getOrderBys() {
        return this.ulOrderbys;
    }

    public void addOrderBy(String formula, String alias, OrderType order) {
        this.orderbys.add(new SQLOrderBy(new SQLSelection(formula, alias), order));
    }

    public List<SQLJoin> getJoins() {
        return this.ulJoins;
    }

    public void addJoin(String leftTablename, String leftTableAlias, String rightTablename, String rightTableAlias, JoinType joinType, String formula, String joinOrderKey) {
        SQLWhereFormula sqlWhereFormula = new SQLWhereFormula(formula, null, false);
        SQLJoin join = new SQLJoin(leftTablename, leftTableAlias, rightTablename, rightTableAlias, sqlWhereFormula, joinType, joinOrderKey);
        this.joins.add(join);
    }

    public boolean containsOuterJoins() {
        for (SQLJoin join : this.joins) {
            if (join.getJoinType() == JoinType.INNER_JOIN) continue;
            return true;
        }
        return false;
    }

    public boolean getDelayOuterJoinConditions() {
        return this.delayOuterJoinConditions;
    }

    public void setDelayOuterJoinConditions(boolean value) {
        this.delayOuterJoinConditions = value;
    }

    public static class SQLOrderBy {
        SQLSelection selection;
        OrderType order;

        public SQLOrderBy(SQLSelection selection, OrderType order) {
            this.selection = selection;
            this.order = order;
        }

        public SQLSelection getSelection() {
            return this.selection;
        }

        public OrderType getOrder() {
            return this.order;
        }
    }

    public static class SQLWhereFormula {
        String formula;
        String operator;
        String[] involvedTables;
        boolean containingAggregate;

        public SQLWhereFormula(String formula, String operator, boolean containingAggregate) {
            this(formula, operator, null, containingAggregate);
        }

        public SQLWhereFormula(String formula, String operator, String[] involvedTables, boolean containingAggregate) {
            this.formula = formula;
            this.operator = operator;
            this.involvedTables = involvedTables;
            if (this.operator == null) {
                this.operator = "AND";
            }
            this.containingAggregate = containingAggregate;
        }

        public String getFormula() {
            return this.formula;
        }

        public String getOperator() {
            return this.operator;
        }

        public String[] getInvolvedTables() {
            return this.involvedTables;
        }

        public void setInvolvedTables(String[] involvedTables) {
            this.involvedTables = involvedTables;
        }

        public boolean isContainingAggregate() {
            return this.containingAggregate;
        }

        public void setContainingAggregate(boolean containingAggregate) {
            this.containingAggregate = containingAggregate;
        }
    }

    public static class SQLTable {
        private String tableName;
        private String alias;

        public SQLTable(String tableName, String alias) {
            this.tableName = tableName;
            this.alias = alias;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getAlias() {
            return this.alias;
        }
    }

    public static class SQLSelection {
        private String formula;
        private String alias;

        public SQLSelection(String formula, String alias) {
            this.formula = formula;
            this.alias = alias;
        }

        public String getFormula() {
            return this.formula;
        }

        public String getAlias() {
            return this.alias;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OrderType {
        ASCENDING,
        DESCENDING;

    }
}

