/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql.graph;

import java.util.Iterator;
import java.util.PriorityQueue;
import org.pentaho.pms.mql.graph.GraphElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphElementQueue
extends PriorityQueue<GraphElement> {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean offer(GraphElement e) {
        if (e.isQueued()) {
            return false;
        }
        if (super.offer(e)) {
            e.setQueued(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        GraphElement e = (GraphElement)o;
        if (super.remove(e)) {
            e.setQueued(false);
            return true;
        }
        return false;
    }

    @Override
    public Iterator<GraphElement> iterator() {
        return new Iter(super.iterator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Iter
    implements Iterator<GraphElement> {
        private Iterator<GraphElement> parentIter;
        private GraphElement last;

        public Iter(Iterator<GraphElement> parentIter) {
            this.parentIter = parentIter;
        }

        @Override
        public boolean hasNext() {
            return this.parentIter.hasNext();
        }

        @Override
        public GraphElement next() {
            this.last = this.parentIter.next();
            return this.last;
        }

        @Override
        public void remove() {
            this.parentIter.remove();
            if (this.last != null) {
                this.last.setQueued(false);
            }
        }
    }
}

