/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema.concept.types.aggregation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.pms.messages.Messages;
import org.pentaho.pms.schema.concept.types.ConceptPropertyBase;
import org.pentaho.pms.schema.concept.types.ConceptPropertyType;
import org.pentaho.pms.schema.concept.types.aggregation.AggregationSettings;
import org.pentaho.pms.util.Const;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConceptPropertyAggregationList
extends ConceptPropertyBase
implements Cloneable {
    private List<AggregationSettings> value;

    public ConceptPropertyAggregationList(String name, List<AggregationSettings> value) {
        this(name, value, false);
    }

    public ConceptPropertyAggregationList(String name, List<AggregationSettings> value, boolean required) {
        super(name, required);
        this.setValue(value);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.getId()).append(this.isRequired()).append(this.value).toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ConceptPropertyAggregationList rtn = (ConceptPropertyAggregationList)super.clone();
        if (this.value != null) {
            rtn.value = new ArrayList<AggregationSettings>();
            rtn.value.addAll(this.value);
        }
        return rtn;
    }

    @Override
    public ConceptPropertyType getType() {
        return ConceptPropertyType.AGGREGATION_LIST;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("<aggregationlist>").append(Const.CR);
        for (AggregationSettings setting : this.value) {
            xml.append("  <aggregation>").append(setting.getCode());
            xml.append("</aggregation>").append(Const.CR);
        }
        xml.append("</aggregationlist>").append(Const.CR);
        return xml.toString();
    }

    public static List<AggregationSettings> fromXML(String value) throws Exception {
        try {
            Document doc = XMLHandler.loadXMLString((String)value);
            ArrayList<AggregationSettings> aggSettings = new ArrayList<AggregationSettings>();
            Node node = XMLHandler.getSubNode((Node)doc, (String)"aggregationlist");
            int nrAggs = XMLHandler.countNodes((Node)node, (String)"aggregation");
            for (int i = 0; i < nrAggs; ++i) {
                AggregationSettings setting;
                Node aggNode = XMLHandler.getSubNodeByNr((Node)node, (String)"aggregation", (int)i);
                String type = XMLHandler.getNodeValue((Node)aggNode);
                if (type == null || (setting = AggregationSettings.getType(type)) == null) continue;
                aggSettings.add(setting);
            }
            if (aggSettings.size() != 0) {
                return aggSettings;
            }
            return null;
        }
        catch (Exception e) {
            throw new Exception(Messages.getString("ConceptPropertyAggregationList.ERROR_0001_CANT_CREATE_AGGLIST_OBJECT"), e);
        }
    }

    @Override
    public void setValue(Object value) {
        this.value = value != null ? (List<Object>)value : new ArrayList<AggregationSettings>();
    }

    @Override
    public boolean equals(Object obj) {
        return ((Object)this.value).equals(obj);
    }

    @Override
    public int hashCode() {
        return ((Object)this.value).hashCode();
    }
}

