/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.pentaho.pms.util.ObjectAlreadyExistsException;
import org.pentaho.pms.util.UniqueList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueArrayList<E>
implements UniqueList<E> {
    private List<E> list;
    private static final long serialVersionUID = -4032535311575763475L;

    public UniqueArrayList() {
        this.list = new ArrayList();
    }

    public UniqueArrayList(Collection<E> c) {
        this.list = new ArrayList<E>(c);
    }

    public UniqueArrayList(int initialCapacity) {
        this.list = new ArrayList(initialCapacity);
    }

    @Override
    public boolean add(E o) throws ObjectAlreadyExistsException {
        if (this.list.contains(o)) {
            throw new ObjectAlreadyExistsException();
        }
        return this.list.add(o);
    }

    @Override
    public void add(int index, E element) throws ObjectAlreadyExistsException {
        if (this.list.contains(element)) {
            throw new ObjectAlreadyExistsException();
        }
        this.list.add(index, element);
    }

    @Override
    public boolean addAll(Collection<E> c) throws ObjectAlreadyExistsException {
        for (E element : c) {
            if (!this.list.contains(element)) continue;
            throw new ObjectAlreadyExistsException();
        }
        return this.list.addAll(c);
    }

    public boolean addAll(int index, Collection<E> c) throws ObjectAlreadyExistsException {
        for (E element : c) {
            if (!this.list.contains(element)) continue;
            throw new ObjectAlreadyExistsException();
        }
        return this.list.addAll(index, c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(E o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<E> c) {
        return this.list.containsAll(c);
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public int indexOf(E o) {
        return this.list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(E o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public E remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public boolean remove(E o) {
        return this.list.remove(o);
    }

    @Override
    public boolean removeAll(Collection<E> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<E> c) {
        return this.list.retainAll(c);
    }

    @Override
    public Object set(int index, E element) throws ObjectAlreadyExistsException {
        return this.list.set(index, element);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public List<E> getList() {
        return this.list;
    }
}

