/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.util.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.Log4JLayoutInterface;
import org.pentaho.di.core.logging.LogMessage;
import org.pentaho.pms.messages.Messages;

public class Log4jPMELayout
extends Layout
implements Log4JLayoutInterface {
    private boolean timeAdded;

    public Log4jPMELayout(boolean addTime) {
        this.timeAdded = addTime;
    }

    public String format(LoggingEvent event) {
        Object object;
        String line = "";
        String dateTimeString = "";
        if (this.timeAdded) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            dateTimeString = df.format(new Date(event.timeStamp)) + " - ";
        }
        if ((object = event.getMessage()) instanceof LogMessage) {
            LogMessage message = (LogMessage)object;
            String[] parts = message.getMessage().split(Const.CR);
            for (int i = 0; i < parts.length; ++i) {
                line = line + dateTimeString;
                if (message.getSubject() != null) {
                    line = line + message.getSubject() + " - ";
                }
                if (message.isError()) {
                    line = line + Messages.getString("Log4jPMELayout.ERROR_LOG4J_ERROR");
                }
                line = line + parts[i];
                if (i >= parts.length - 1) continue;
                line = line + Const.CR;
            }
        } else {
            line = line + dateTimeString + object.toString();
        }
        return line;
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public void activateOptions() {
    }

    public boolean isTimeAdded() {
        return this.timeAdded;
    }

    public void setTimeAdded(boolean addTime) {
        this.timeAdded = addTime;
    }
}

