/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.jface.tags;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.window.ApplicationWindow;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.containers.XulMenubar;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.jface.tags.ApplicationWindowLocal;
import org.pentaho.ui.xul.jface.tags.JfaceMenu;
import org.pentaho.ui.xul.jface.tags.JfaceMenuitem;
import org.pentaho.ui.xul.jface.tags.JfaceMenupopup;
import org.pentaho.ui.xul.swt.AbstractSwtXulContainer;

public class JfaceMenubar
extends AbstractSwtXulContainer
implements XulMenubar {
    private MenuManager menuManager = null;
    private static Log logger = LogFactory.getLog(JfaceMenubar.class);
    private XulComponent parent;

    public JfaceMenubar(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("menubar");
        ApplicationWindow window = ApplicationWindowLocal.getApplicationWindow();
        if (window == null) {
            logger.error((Object)"No ApplicationWindow available via ApplicationWindowLocal");
        } else {
            this.menuManager = window.getMenuBarManager();
        }
        logger.debug((Object)("JfaceMenubar grabbed window's MenuManager: " + this.menuManager));
        this.setManagedObject(this.menuManager);
        this.parent = parent;
    }

    public XulComponent getParent() {
        return this.parent;
    }

    public void addChild(Element c) {
        this.addChildAt(c, -1);
    }

    public void addChildAt(Element c, int pos) {
        IContributionItem[] items;
        if (pos != -1) {
            super.addChildAt(c, pos);
        } else {
            super.addChild(c);
        }
        if (this.menuManager == null) {
            return;
        }
        for (IContributionItem item : items = this.menuManager.getItems()) {
            if (item.getId() == null || !item.getId().equals(c.getAttributeValue("ID")) || item.isVisible()) continue;
            item.setVisible(true);
            return;
        }
        MenuManager item = ((JfaceMenu)c).getJfaceMenu();
        if (c instanceof JfaceMenu) {
            if (pos == 0 && pos < this.menuManager.getItems().length) {
                String id = this.menuManager.getItems()[1].getId();
                this.menuManager.insertBefore(id, (IContributionItem)item);
            } else if (pos > 0 && pos < this.menuManager.getItems().length) {
                String id = this.menuManager.getItems()[pos].getId();
                this.menuManager.insertBefore(id, (IContributionItem)item);
            } else {
                this.menuManager.add((IContributionItem)item);
            }
        }
    }

    public void layout() {
        this.initialized = true;
    }

    public void removeChild(Element e) {
        if (e instanceof JfaceMenuitem) {
            ((JfaceMenuitem)e).setVisible(false);
        }
        if (e instanceof JfaceMenupopup) {
            ((JfaceMenupopup)e).setVisible(false);
        }
        if (e instanceof JfaceMenu) {
            ((JfaceMenu)e).setVisible(false);
        }
    }
}

