/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulContainer;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulDomException;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.containers.XulDeck;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulRoot;
import org.pentaho.ui.xul.dnd.DataTransfer;
import org.pentaho.ui.xul.dnd.DropEffectType;
import org.pentaho.ui.xul.dnd.DropEvent;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.impl.AbstractXulComponent;
import org.pentaho.ui.xul.swt.AbstractSwtXulContainer;
import org.pentaho.ui.xul.swt.SwtAlign;
import org.pentaho.ui.xul.util.Orient;
import org.pentaho.ui.xul.util.SwtDragManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwtElement
extends AbstractXulComponent {
    private static final long serialVersionUID = -4407080035694005764L;
    private static final Log logger = LogFactory.getLog(SwtElement.class);
    private SwtAlign align = SwtAlign.STRETCH;
    protected Orient orient = Orient.HORIZONTAL;
    private int flex = 0;
    protected PropertyChangeSupport changeSupport = new PropertyChangeSupport((Object)this);
    private boolean disabled;
    private static Map<String, Object> dndObjects = new WeakHashMap<String, Object>();
    private static Map<String, SwtElement> dndSources = new WeakHashMap<String, SwtElement>();

    public SwtElement(String tagName) {
        super(tagName);
    }

    public void addChild(Element e) {
        super.addChild(e);
        if (e instanceof XulContainer) {
            AbstractSwtXulContainer container = (AbstractSwtXulContainer)e;
            if (!container.initialized) {
                container.layout();
            }
        }
        XulComponent comp = (XulComponent)e;
        Object mo = comp.getManagedObject();
        if (!(this instanceof XulRoot) && mo != null) {
            if (mo instanceof Control) {
                if ((Control)mo != this.getManagedObject() && this.getManagedObject() instanceof Composite) {
                    ((Control)mo).setParent((Composite)this.getManagedObject());
                }
            } else if (mo instanceof Viewer && ((Viewer)mo).getControl() != this.getManagedObject() && this.getManagedObject() instanceof Composite) {
                ((Viewer)mo).getControl().setParent((Composite)this.getManagedObject());
            }
        }
        if (this.initialized && mo != null && !(mo instanceof String)) {
            this.layout();
            ((XulComponent)e).onDomReady();
        }
    }

    public void addChildAt(Element c, int pos) {
        super.addChildAt(c, pos);
        if (this.initialized) {
            this.layout();
        }
    }

    public void removeChild(Element ele) {
        Widget thisWidget;
        XulComponent comp;
        super.removeChild(ele);
        if (ele instanceof XulComponent && (comp = (XulComponent)ele).getManagedObject() instanceof Widget && (thisWidget = (Widget)comp.getManagedObject()) != null && !thisWidget.isDisposed()) {
            thisWidget.dispose();
        }
        if (this.initialized) {
            this.layout();
        }
    }

    public int getFlex() {
        return this.flex;
    }

    public void setFlex(int flex) {
        this.flex = flex;
    }

    public void setOrient(String orientation) {
        this.orient = Orient.valueOf((String)orientation.toUpperCase());
    }

    public String getOrient() {
        return this.orient.toString();
    }

    public Orient getOrientation() {
        return Orient.valueOf((String)this.getOrient());
    }

    public int getPadding() {
        return super.getPadding() > -1 ? super.getPadding() : 2;
    }

    public int getSpacing() {
        return super.getSpacing() > -1 ? super.getSpacing() : 2;
    }

    public void layout() {
        super.layout();
        if (this instanceof XulDeck) {
            return;
        }
        if (!(this.getManagedObject() instanceof Composite)) {
            return;
        }
        Composite container = (Composite)this.getManagedObject();
        int totalFlex = 0;
        int thisFlex = 0;
        boolean everyChildIsFlexing = true;
        for (XulComponent child : this.getChildNodes()) {
            thisFlex = ((SwtElement)child).getFlex();
            if (thisFlex <= 0) {
                everyChildIsFlexing = false;
            }
            totalFlex += thisFlex;
        }
        switch (this.orient) {
            case HORIZONTAL: {
                int columnCount = this.getChildNodes().size() + totalFlex;
                GridLayout layout = new GridLayout(columnCount, everyChildIsFlexing);
                if (this.getPadding() > -1) {
                    layout.marginWidth = this.getPadding();
                    layout.marginHeight = this.getPadding();
                }
                if (this.getSpacing() > -1) {
                    layout.horizontalSpacing = this.getSpacing();
                    layout.verticalSpacing = this.getSpacing();
                }
                container.setLayout((Layout)layout);
                break;
            }
            case VERTICAL: {
                GridLayout layout = new GridLayout();
                if (this.getPadding() > -1) {
                    layout.marginWidth = this.getPadding();
                    layout.marginHeight = this.getPadding();
                }
                if (this.getSpacing() > -1) {
                    layout.horizontalSpacing = this.getSpacing();
                    layout.verticalSpacing = this.getSpacing();
                }
                container.setLayout((Layout)layout);
            }
        }
        for (XulComponent child : this.getChildNodes()) {
            SwtElement swtChild = (SwtElement)child;
            Object mo = swtChild.getManagedObject();
            if (mo == null || !(mo instanceof Control) && !(mo instanceof Viewer) || swtChild instanceof XulDialog) continue;
            Control c = null;
            if (mo instanceof Control) {
                c = (Control)mo;
            } else if (mo instanceof Viewer) {
                c = ((Viewer)mo).getControl();
            }
            GridData data = new GridData();
            data.horizontalSpan = this.orient.equals((Object)Orient.HORIZONTAL) ? swtChild.getFlex() + 1 : 1;
            data.verticalSpan = this.orient.equals((Object)Orient.VERTICAL) ? swtChild.getFlex() + 1 : 1;
            switch (this.orient) {
                case HORIZONTAL: {
                    data.verticalAlignment = 4;
                    data.grabExcessVerticalSpace = true;
                    break;
                }
                case VERTICAL: {
                    data.horizontalAlignment = 4;
                    data.grabExcessHorizontalSpace = true;
                }
            }
            if (swtChild.getFlex() > 0) {
                if (swtChild.getWidth() == 0) {
                    data.grabExcessHorizontalSpace = true;
                    data.horizontalAlignment = 4;
                }
                if (swtChild.getHeight() == 0) {
                    data.grabExcessVerticalSpace = true;
                    data.verticalAlignment = 4;
                }
            }
            if (swtChild.getWidth() > 0) {
                data.widthHint = swtChild.getWidth();
            }
            if (swtChild.getHeight() > 0) {
                data.heightHint = swtChild.getHeight();
            }
            if (swtChild.getAlign() != null) {
                SwtAlign swtAlign = SwtAlign.valueOf(((XulContainer)swtChild).getAlign().toString());
                if (this.orient.equals((Object)Orient.HORIZONTAL)) {
                    if (swtChild.getHeight() < 0) {
                        data.grabExcessVerticalSpace = true;
                    }
                } else if (swtChild.getWidth() < 0) {
                    data.grabExcessHorizontalSpace = true;
                }
            }
            if (c.getLayoutData() instanceof FormData) {
                boolean z = false;
            }
            c.setLayoutData((Object)data);
        }
        container.layout(true);
    }

    public void replaceChild(XulComponent oldElement, XulComponent newElement) throws XulDomException {
        super.replaceChild(oldElement, newElement);
        Widget thisWidget = (Widget)oldElement.getManagedObject();
        if (!thisWidget.isDisposed()) {
            thisWidget.dispose();
        }
        ((Control)newElement.getManagedObject()).setParent((Composite)this.getManagedObject());
        this.layout();
    }

    public void setOnblur(String method) {
        throw new NotImplementedException();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void adoptAttributes(XulComponent component) {
        throw new NotImplementedException();
    }

    public void setMenu(IMenuManager menu) {
        if (this.getManagedObject() instanceof Control) {
            Control c = (Control)this.getManagedObject();
            c.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent evt) {
                    Control source = (Control)evt.getSource();
                    Point pt = source.getDisplay().map(source, null, new Point(evt.x, evt.y));
                    Menu menu = source.getMenu();
                    menu.setLocation(pt.x, pt.y);
                    menu.setVisible(true);
                }
            });
        }
    }

    public void setPopup(IMenuManager menu) {
        if (this.getManagedObject() instanceof Control) {
            Control control = (Control)this.getManagedObject();
            if (menu instanceof MenuManager) {
                Menu m = ((MenuManager)menu).createContextMenu(control);
                menu.update(true);
            }
        }
    }

    public void onDomReady() {
        XulComponent pop;
        super.onDomReady();
        if (this.context != null) {
            pop = this.getDocument().getElementById(this.context);
            if (pop == null) {
                logger.error((Object)("could not find popup menu (" + this.context + ") to add to this component"));
            } else {
                this.setPopup((IMenuManager)pop.getManagedObject());
            }
        }
        if (this.menu != null) {
            pop = this.getDocument().getElementById(this.menu);
            if (pop == null) {
                logger.error((Object)("could not find popup menu (" + this.context + ") to add to this component"));
            } else {
                this.setMenu((IMenuManager)pop.getManagedObject());
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.getManagedObject() instanceof Control) {
            Control control = (Control)this.getManagedObject();
            Object data = control.getLayoutData();
            if (data instanceof GridData) {
                ((GridData)data).exclude = !visible;
            }
            control.setLayoutData(data);
            control.setVisible(visible);
            control.getParent().layout(true);
        }
    }

    protected void enableDrag(DropEffectType effect) {
        DragSource source = new DragSource(this.getDndObject(), this.lookupEffect(effect));
        Transfer[] types = new Transfer[]{SwtDndTypeTransfer.getInstance()};
        source.setTransfer(types);
        source.addDragListener(new DragSourceListener(){

            public void dragFinished(DragSourceEvent nativeEvent) {
            }

            public void dragSetData(DragSourceEvent nativeEvent) {
                if (SwtDndTypeTransfer.getInstance().isSupportedType(nativeEvent.dataType)) {
                    List<Object> obj = SwtElement.this.getSwtDragData();
                    XulSwtDndType[] types = new XulSwtDndType[obj.size()];
                    for (int i = 0; i < obj.size(); ++i) {
                        types[i] = new XulSwtDndType("xultype", obj.get(i), SwtElement.this);
                    }
                    nativeEvent.data = types;
                }
            }

            public void dragStart(DragSourceEvent nativeEvent) {
                DropEvent event = new DropEvent();
                DataTransfer dt = new DataTransfer();
                event.setDataTransfer(dt);
                dt.setData(SwtElement.this.getSwtDragData());
                event.setAccepted(true);
                String method = SwtElement.this.getOndrag();
                if (method != null) {
                    try {
                        Document doc = SwtElement.this.getDocument();
                        XulRoot window = (XulRoot)doc.getRootElement();
                        XulDomContainer con = window.getXulDomContainer();
                        con.invoke(method, new Object[]{event});
                    }
                    catch (XulException e) {
                        logger.error((Object)("Error calling ondrop event: " + method), (Throwable)e);
                    }
                }
                if (!event.isAccepted()) {
                    nativeEvent.doit = false;
                }
                SwtDragManager.getInstance().setCurrentDropEvent(event);
            }
        });
    }

    protected Control getDndObject() {
        return (Control)this.getManagedObject();
    }

    protected void onSwtDragFinished(DropEffectType effect, DropEvent event) {
        throw new UnsupportedOperationException("unsupported element type: " + ((Object)((Object)this)).getClass());
    }

    protected List<Object> getSwtDragData() {
        throw new UnsupportedOperationException("unsupported element type: " + ((Object)((Object)this)).getClass());
    }

    protected void enableDrop() {
        DropTarget target = new DropTarget(this.getDndObject(), 19);
        target.setTransfer(new Transfer[]{SwtDndTypeTransfer.getInstance()});
        target.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent arg0) {
                arg0.detail = arg0.operations;
            }

            public void dragLeave(DropTargetEvent arg0) {
            }

            public void dragOperationChanged(DropTargetEvent arg0) {
            }

            public void dragOver(DropTargetEvent event) {
                SwtElement.this.onSwtDragOver(event);
            }

            public void drop(DropTargetEvent nativeEvent) {
                DropEvent event = new DropEvent();
                DataTransfer dataTransfer = new DataTransfer();
                XulSwtDndType[] types = (XulSwtDndType[])nativeEvent.data;
                SwtElement xulDndSource = null;
                try {
                    ArrayList<Object> objs;
                    if (types != null) {
                        objs = new ArrayList<Object>();
                        for (int i = 0; i < types.length; ++i) {
                            if (i == 0) {
                                xulDndSource = types[i].getXulSource();
                            }
                            objs.add(types[i].getValue());
                        }
                    } else {
                        nativeEvent.detail = 0;
                        return;
                    }
                    dataTransfer.setData(objs);
                    dataTransfer.setDropEffect(SwtElement.this.lookupXulEffect(nativeEvent.detail));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                event.setDataTransfer(dataTransfer);
                event.setAccepted(true);
                event.setNativeEvent((Object)nativeEvent);
                SwtElement.this.resolveDndParentAndIndex(event);
                String method = SwtElement.this.getOndrop();
                if (method != null) {
                    try {
                        Document doc = SwtElement.this.getDocument();
                        XulRoot window = (XulRoot)doc.getRootElement();
                        XulDomContainer con = window.getXulDomContainer();
                        con.invoke(method, new Object[]{event});
                    }
                    catch (XulException e) {
                        logger.error((Object)("Error calling ondrop event: " + method), (Throwable)e);
                    }
                }
                if (!event.isAccepted()) {
                    nativeEvent.detail = 0;
                    return;
                }
                if (xulDndSource == null) {
                    throw new RuntimeException("DND Source is null");
                }
                xulDndSource.onSwtDragFinished(SwtElement.this.lookupXulEffect(nativeEvent.detail), event);
                SwtElement.this.onSwtDragDropAccepted(event);
            }

            public void dropAccept(DropTargetEvent arg0) {
            }
        });
    }

    protected void resolveDndParentAndIndex(DropEvent event) {
    }

    protected void onSwtDragOver(DropTargetEvent nativeEvent) {
    }

    protected void onSwtDragDropAccepted(DropEvent event) {
        throw new UnsupportedOperationException("unsupported element type: " + ((Object)((Object)this)).getClass());
    }

    private int lookupEffect(DropEffectType effect) {
        switch (effect) {
            case NONE: {
                return 0;
            }
            case MOVE: {
                return 2;
            }
            case LINK: {
                return 4;
            }
        }
        return 1;
    }

    private DropEffectType lookupXulEffect(int effect) {
        switch (effect) {
            case 0: {
                return DropEffectType.NONE;
            }
            case 2: {
                return DropEffectType.MOVE;
            }
            case 4: {
                return DropEffectType.LINK;
            }
        }
        return DropEffectType.COPY;
    }

    public void setTooltiptext(String tooltip) {
        super.setTooltiptext(tooltip);
        if (this.getManagedObject() instanceof Control) {
            ((Control)this.getManagedObject()).setToolTipText(tooltip);
        }
    }

    private static class SwtDndTypeTransfer
    extends ByteArrayTransfer {
        private static final String TYPENAME = "xul-transfer";
        private static final int TYPEID = SwtDndTypeTransfer.registerType((String)"xul-transfer");
        private static SwtDndTypeTransfer _instance = new SwtDndTypeTransfer();

        private SwtDndTypeTransfer() {
        }

        public static SwtDndTypeTransfer getInstance() {
            return _instance;
        }

        protected String[] getTypeNames() {
            return new String[]{TYPENAME};
        }

        protected int[] getTypeIds() {
            return new int[]{TYPEID};
        }

        protected boolean validate(Object object) {
            return object instanceof XulSwtDndType;
        }

        public void javaToNative(Object object, TransferData transferData) {
            if (object == null || !(object instanceof XulSwtDndType[])) {
                return;
            }
            if (this.isSupportedType(transferData)) {
                XulSwtDndType[] myTypes = (XulSwtDndType[])object;
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ObjectOutputStream writeOut = new ObjectOutputStream(out);
                    writeOut.writeInt(myTypes.length);
                    for (int i = 0; i < myTypes.length; ++i) {
                        writeOut.writeObject(myTypes[i]);
                    }
                    byte[] buffer = out.toByteArray();
                    writeOut.close();
                    super.javaToNative((Object)buffer, transferData);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nativeToJava(TransferData transferData) {
            if (this.isSupportedType(transferData)) {
                byte[] buffer = (byte[])super.nativeToJava(transferData);
                if (buffer == null) {
                    return null;
                }
                ObjectInputStream readIn = null;
                try {
                    readIn = new ObjectInputStream(new ByteArrayInputStream(buffer));
                    int c = readIn.readInt();
                    XulSwtDndType[] myData = new XulSwtDndType[c];
                    for (int i = 0; i < c; ++i) {
                        myData[i] = (XulSwtDndType)readIn.readObject();
                    }
                    readIn.close();
                    XulSwtDndType[] i = myData;
                    return i;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Object var5_7 = null;
                    return var5_7;
                }
                finally {
                    if (readIn != null) {
                        try {
                            readIn.close();
                        }
                        catch (IOException ignored) {}
                    }
                }
            }
            return null;
        }
    }

    protected static class XulSwtDndType
    implements Serializable {
        private static final long serialVersionUID = 7356053006903234787L;
        String xultype;
        Object value;

        XulSwtDndType(String xultype, Object value, SwtElement xulSource) {
            this.xultype = xultype;
            UUID uuid = UUID.randomUUID();
            dndObjects.put(uuid.toString(), value);
            dndSources.put(uuid.toString(), xulSource);
            this.value = uuid.toString();
        }

        public Object getValue() {
            return dndObjects.get(this.value);
        }

        public SwtElement getXulSource() {
            return (SwtElement)((Object)dndSources.get(this.value));
        }
    }
}

