/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulMenuitem;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swt.SwtElement;
import org.pentaho.ui.xul.util.XulUtil;

public class SwtMenuitem
extends SwtElement
implements XulMenuitem {
    private static final Log logger = LogFactory.getLog(SwtMenuitem.class);
    private String onCommand;
    private boolean disabled = false;
    private MenuItem item;
    private XulDomContainer domContainer;
    private XulComponent parent;
    private String acceltext = "";
    private String accesskey = "";
    private String label = "";
    private String image = "";
    private boolean selected = false;

    public SwtMenuitem(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("menuitem");
        this.parent = parent;
        this.setManagedObject("empty");
        this.domContainer = domContainer;
        if (parent.getManagedObject() != null && parent.getManagedObject() instanceof Menu) {
            this.createItem(self, parent, -1);
        }
    }

    public SwtMenuitem(XulComponent parent, XulDomContainer domContainer, String tagName, int pos) {
        super("menuitem");
        this.parent = parent;
        this.setManagedObject("empty");
        this.domContainer = domContainer;
        if (parent.getManagedObject() != null && parent.getManagedObject() instanceof Menu) {
            this.createItem(null, parent, pos);
        }
    }

    private void createItem(Element self, XulComponent parent, int pos) {
        int style = 8;
        if (self != null && self.getAttributeValue("type") != null && self.getAttributeValue("type").equals("checkbox")) {
            style = 32;
        }
        this.item = pos > -1 ? new MenuItem((Menu)parent.getManagedObject(), style, pos) : new MenuItem((Menu)parent.getManagedObject(), style);
        this.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String command = SwtMenuitem.this.onCommand;
                if (command != null) {
                    SwtMenuitem.this.invoke(command);
                }
            }
        });
        this.setManagedObject(this.item);
    }

    public String getAcceltext() {
        return this.acceltext;
    }

    public String getAccesskey() {
        return this.accesskey;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String getLabel() {
        return this.label;
    }

    public void setAcceltext(String accel) {
        this.acceltext = accel;
        this.setText();
    }

    private void setText() {
        if (this.item != null && !this.item.isDisposed()) {
            String text = "";
            if (this.label != null) {
                text = text + this.label;
            }
            text = text + "\t" + this.acceltext;
            this.item.setText(text);
        }
    }

    public void setAccesskey(String accessKey) {
        if (this.item != null && !this.item.isDisposed()) {
            String remainder;
            int mask = 0;
            if (accessKey.indexOf("ctrl") > -1) {
                mask += 262144;
            }
            if (accessKey.indexOf("shift") > -1) {
                mask += 131072;
            }
            if (accessKey.indexOf("alt") > -1) {
                mask += 65536;
            }
            if (accessKey.indexOf("pageup") > -1) {
                mask += 0x1000005;
            }
            if (accessKey.indexOf("pagedown") > -1) {
                mask += 0x1000006;
            }
            if (accessKey.indexOf("home") > -1) {
                mask += 0x1000007;
            }
            if (accessKey.indexOf("esc") > -1) {
                mask += 27;
            }
            if ((remainder = accessKey.replaceAll("ctrl", "").replaceAll("shift", "").replaceAll("alt", "").replaceAll("-", "").trim()).length() == 1) {
                mask += remainder.toUpperCase().charAt(0);
            } else if (remainder.length() > 1 && remainder.startsWith("f")) {
                mask += LegacyActionTools.findKeyCode((String)remainder);
            }
            this.item.setAccelerator(mask);
        }
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        if (this.item != null && !this.item.isDisposed()) {
            this.item.setEnabled(!disabled);
        }
    }

    public void setLabel(String label) {
        this.label = label;
        this.setText();
    }

    public String getImage() {
        return this.image;
    }

    public boolean isSelected() {
        return this.item != null && !this.item.isDisposed() ? this.item.getSelection() : this.selected;
    }

    public void setSelected(boolean val) {
        this.selected = val;
        if (this.item != null && !this.item.isDisposed()) {
            this.item.setSelection(this.selected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(String image) {
        this.image = image;
        if (StringUtils.isNotEmpty((String)image)) {
            InputStream in = null;
            try {
                int pixelIndex;
                in = XulUtil.loadResourceAsStream((String)image, (XulDomContainer)this.domContainer);
                Image img = new Image((Device)this.item.getDisplay(), in);
                img.getImageData().transparentPixel = pixelIndex = img.getImageData().palette.getPixel(new RGB(255, 255, 255));
                Image tempImage = new Image((Device)this.item.getDisplay(), img.getImageData());
                img.dispose();
                img = tempImage;
                if (this.item != null && !this.item.isDisposed()) {
                    this.item.setImage(img);
                }
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getCommand() {
        return this.onCommand;
    }

    public void setCommand(String command) {
        this.onCommand = command;
    }

    public String toString() {
        return this.getLabel();
    }

    public void reposition(int position) {
        int accel = this.item.getAccelerator();
        this.item.dispose();
        this.createItem((Element)this, this.parent, position);
        this.setDisabled(this.isDisabled());
        this.setImage(this.getImage());
        this.setSelected(this.isSelected());
        this.item.setAccelerator(accel);
        this.setAcceltext(this.getAcceltext());
    }
}

