/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulScale;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swt.SwtElement;
import org.pentaho.ui.xul.util.Orient;

public class SwtScale
extends SwtElement
implements XulScale {
    private Scale scale;
    private Composite parentComposite;
    private int inc;
    private int min;
    private int max;
    private int pageInc;
    private int value;
    private String dir;

    public SwtScale(Element self, XulComponent parent, XulDomContainer container, String tagName) {
        super(tagName);
        this.parentComposite = (Composite)parent.getManagedObject();
    }

    public void layout() {
        int hvOrient = this.getOrientation() == Orient.VERTICAL ? 512 : 256;
        this.scale = new Scale(this.parentComposite, hvOrient);
        this.scale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int perspectiveValue = SwtScale.this.scale.getSelection();
                SwtScale.this.setValue(perspectiveValue);
            }
        });
        this.setManagedObject(this.scale);
        this.setMin(this.getMin());
        this.setMax(this.getMax());
        this.setPageincrement(this.getPageincrement());
        this.setValue(this.getValue());
        this.setDir(this.getDir());
    }

    public String getDir() {
        return this.dir;
    }

    public int getInc() {
        return this.inc;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public int getPageincrement() {
        return this.pageInc;
    }

    public int getValue() {
        return this.scale.getSelection();
    }

    public void setDir(String direction) {
        this.dir = direction;
    }

    public void setInc(int increment) {
        this.inc = increment;
        if (this.scale != null) {
            this.scale.setIncrement(this.inc);
        }
    }

    public void setMax(int max) {
        this.max = max;
        if (this.scale != null) {
            this.scale.setMaximum(max);
        }
    }

    public void setMin(int min) {
        this.min = min;
        if (this.scale != null) {
            this.scale.setMinimum(min);
        }
    }

    public void setPageincrement(int increment) {
        this.pageInc = increment;
        if (this.scale != null) {
            this.scale.setPageIncrement(this.pageInc);
        }
    }

    public void setValue(int value) {
        int prevVal = this.value;
        this.value = value;
        if (this.scale != null) {
            this.scale.setSelection(value);
        }
        this.changeSupport.firePropertyChange("value", prevVal, value);
    }
}

