/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.dnd.DropEvent;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swt.SwtElement;
import org.pentaho.ui.xul.util.TextType;

public class SwtTextbox
extends SwtElement
implements XulTextbox {
    private static final long serialVersionUID = 4928464432190672877L;
    protected Text textBox;
    protected Composite parentComposite = null;
    private boolean disabled = false;
    private boolean multiLine = false;
    private boolean readOnly = false;
    private int maxLength;
    private String text;
    private TextType type = TextType.NORMAL;
    private int max;
    private int min;
    private String oldValue = "";
    private String command;

    public SwtTextbox(Element self, XulComponent parent, XulDomContainer container, String tagName) {
        super(tagName);
        this.parentComposite = (Composite)parent.getManagedObject();
        this.textBox = this.createNewText();
        this.setManagedObject(this.textBox);
    }

    public Text createNewText() {
        this.textBox = new Text(this.parentComposite, 2048);
        this.addKeyListener(this.textBox);
        return this.textBox;
    }

    protected void addKeyListener(final Text box) {
        if (box == null) {
            return;
        }
        box.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (!SwtTextbox.this.oldValue.equals(SwtTextbox.this.getValue())) {
                    SwtTextbox.this.changeSupport.firePropertyChange("value", null, SwtTextbox.this.getValue());
                    SwtTextbox.this.oldValue = box.getText();
                }
            }
        });
        box.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                if (SwtTextbox.this.command != null) {
                    SwtTextbox.this.invoke(SwtTextbox.this.command);
                }
            }
        });
    }

    public void setValue(String text) {
        if (text == null) {
            text = "";
        }
        if (this.text == null || !this.text.equals(text) || !this.textBox.isDisposed() && !text.equals(this.textBox.getText())) {
            this.text = text;
            if (!this.textBox.isDisposed()) {
                int pos = this.textBox.getCaretPosition();
                this.textBox.setText(text);
                this.textBox.setSelection(pos);
            }
        }
    }

    public String getValue() {
        if (!this.textBox.isDisposed()) {
            this.text = this.textBox.getText();
        }
        return this.text;
    }

    public boolean isDisabled() {
        if (!this.textBox.isDisposed()) {
            this.disabled = !this.textBox.isEnabled();
        }
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        if (!this.textBox.isDisposed()) {
            this.textBox.setEnabled(!disabled);
        }
    }

    public int getMaxlength() {
        return this.maxLength;
    }

    public void setMaxlength(int length) {
        this.maxLength = length;
        if (!this.textBox.isDisposed() && this.maxLength > 0) {
            this.textBox.setTextLimit(this.maxLength);
        }
    }

    public boolean isMultiline() {
        return this.multiLine;
    }

    public void setMultiline(boolean multi) {
        if (multi == this.multiLine) {
            return;
        }
        this.multiLine = multi;
        this.textBox.dispose();
    }

    public Object getManagedObject() {
        if (this.textBox.isDisposed()) {
            int style = this.isMultiline() ? 2626 : 2048;
            this.textBox = new Text(this.parentComposite, style);
            this.setDisabled(this.disabled);
            this.setMaxlength(this.maxLength);
            this.setValue(this.text);
            this.setReadonly(this.readOnly);
            this.setType(this.type);
            this.setManagedObject(this.textBox);
            this.addKeyListener(this.textBox);
        }
        return super.getManagedObject();
    }

    public boolean isReadonly() {
        if (!this.textBox.isDisposed()) {
            this.readOnly = !this.textBox.getEditable();
        }
        return this.readOnly;
    }

    public void setReadonly(boolean readOnly) {
        this.readOnly = readOnly;
        if (!this.textBox.isDisposed()) {
            this.textBox.setEditable(!readOnly);
        }
    }

    public String getType() {
        if (this.type == null) {
            return null;
        }
        return this.type.toString();
    }

    public void setType(String type) {
        if (type == null) {
            return;
        }
        this.setType(TextType.valueOf((String)type.toUpperCase()));
    }

    public void setType(TextType type) {
        this.type = type;
        if (this.type == null) {
            return;
        }
        if (!this.textBox.isDisposed()) {
            switch (this.type) {
                case PASSWORD: {
                    this.textBox.setEchoChar('*');
                    break;
                }
            }
        }
    }

    public void selectAll() {
        this.textBox.selectAll();
    }

    public void setFocus() {
        this.textBox.setFocus();
    }

    public Object getTextControl() {
        return this.getManagedObject();
    }

    public void setOninput(String method) {
    }

    public String getMin() {
        return "" + this.min;
    }

    public void setMin(String min) {
        this.min = Integer.parseInt(min);
    }

    public String getMax() {
        return "" + this.max;
    }

    public void setMax(String max) {
        this.max = Integer.parseInt(max);
    }

    protected void onSwtDragDropAccepted(DropEvent event) {
        String text = "";
        for (int i = 0; i < event.getDataTransfer().getData().size(); ++i) {
            if (i != 0) {
                text = text + ", ";
            }
            text = text + event.getDataTransfer().getData().get(i).toString();
        }
        this.textBox.setText(text);
    }

    public void setOndrop(String ondrop) {
        super.setOndrop(ondrop);
        super.enableDrop();
    }

    public void setCommand(String command) {
        this.command = command;
    }
}

