/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulToolbarspacer;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swt.AbstractSwtXulContainer;

public class SwtToolbarspacer
extends AbstractSwtXulContainer
implements XulToolbarspacer {
    private ToolItem spacer;
    private ToolBar toolbar;
    private final int MARGIN_VALUE = 3;

    public SwtToolbarspacer(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("toolbarspacer");
        this.toolbar = (ToolBar)parent.getManagedObject();
        this.spacer = new ToolItem(this.toolbar, 2);
        Composite box = new Composite((Composite)this.toolbar, 0);
        box.setBackgroundMode(1);
        this.spacer.setControl((Control)box);
        this.setManagedObject(this.spacer);
    }

    public void setWidth(int width) {
        super.setWidth(width);
        this.spacer.setWidth(width);
    }

    public void setFlex(int flex) {
        super.setFlex(flex);
        if (this.getFlex() > 0) {
            this.toolbar.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent arg0) {
                    SwtToolbarspacer.this.recalculateSize();
                }
            });
        }
    }

    void recalculateSize() {
        int totalWidth = this.toolbar.getBounds().width;
        int childTotalWidth = 0;
        for (ToolItem item : this.toolbar.getItems()) {
            if (item == this.spacer) continue;
            childTotalWidth += item.getBounds().width + 3;
        }
        this.spacer.setWidth(Math.max(0, totalWidth - childTotalWidth));
    }
}

