/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.platform.api.engine.IActionCompleteListener;
import org.pentaho.platform.api.engine.IActionRequestHandler;
import org.pentaho.platform.api.engine.ICreateFeedbackParameterCallback;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.engine.ISolutionEngine;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.util.logging.Logger;

public class BaseRequestHandler
implements IActionRequestHandler,
IActionCompleteListener {
    public static final int ON_TIMEOUT_CANCEL = 0;
    public static final int ON_TIMEOUT_RETURN = 1;
    protected IPentahoUrlFactory urlFactory;
    private String solutionName;
    private String actionName;
    private String actionPath;
    protected String processId;
    private String instanceId;
    protected IPentahoSession session;
    private IOutputHandler outputHandler;
    private HashMap parameterProviders;
    protected boolean instanceEnds;
    protected boolean forcePrompt = false;
    protected String parameterXsl = null;
    ArrayList messages;
    protected IRuntimeContext runtime = null;
    protected ICreateFeedbackParameterCallback createFeedbackParameterCallback;

    public BaseRequestHandler(IPentahoSession session, String instanceId, IOutputHandler outputHandler, IParameterProvider parameterProvider, IPentahoUrlFactory urlFactory) {
        this.session = session;
        this.outputHandler = outputHandler;
        this.urlFactory = urlFactory;
        this.instanceId = instanceId;
        this.parameterProviders = new HashMap();
        this.messages = new ArrayList();
        if (parameterProvider != null) {
            this.parameterProviders.put("request", parameterProvider);
        }
        this.instanceEnds = true;
    }

    public List getMessages() {
        return this.messages;
    }

    public void setInstanceEnds(boolean instanceEnds) {
        this.instanceEnds = instanceEnds;
    }

    public void setParameterProvider(String name, IParameterProvider parameterProvider) {
        this.parameterProviders.put(name, parameterProvider);
    }

    public HashMap getParameterProviders() {
        return this.parameterProviders;
    }

    public void setOutputHandler(IOutputHandler outputHandler) {
        this.outputHandler = outputHandler;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setAction(String actionPath, String actionName) {
        this.actionName = actionName;
        this.actionPath = actionPath;
    }

    public void setSolutionName(String solutionName) {
        this.solutionName = solutionName;
    }

    public String getSolutionName() {
        return this.solutionName;
    }

    public IRuntimeContext handleActionRequest(int timeout, int timeoutType) {
        ISolutionEngine solutionEngine = (ISolutionEngine)PentahoSystem.get(ISolutionEngine.class, (IPentahoSession)this.session);
        solutionEngine.setCreateFeedbackParameterCallback(this.createFeedbackParameterCallback);
        if (solutionEngine == null) {
            Logger.error((Object)this, (String)Messages.getErrorString("BaseRequestHandler.ERROR_0001_NO_SOLUTION_ENGINE"));
            return null;
        }
        solutionEngine.setLoggingLevel(2);
        solutionEngine.init(this.session);
        solutionEngine.setForcePrompt(this.forcePrompt);
        if (this.parameterXsl != null) {
            solutionEngine.setParameterXsl(this.parameterXsl);
        }
        this.dispose();
        this.runtime = solutionEngine.execute(this.solutionName, this.actionPath, this.actionName, this.processId, false, this.instanceEnds, this.instanceId, true, (Map)this.parameterProviders, this.outputHandler, (IActionCompleteListener)this, this.urlFactory, (List)this.messages);
        return this.runtime;
    }

    public void dispose() {
        if (this.runtime != null) {
            this.runtime.dispose();
        }
    }

    public IRuntimeContext handleActionAsyncRequest() {
        return null;
    }

    public IRuntimeContext getRuntime(String requestHandle) {
        return this.runtime;
    }

    public void actionComplete(IRuntimeContext completedRuntime) {
    }

    public IOutputHandler getOutputHandler() {
        return this.outputHandler;
    }

    public void setForcePrompt(boolean forcePrompt) {
        this.forcePrompt = forcePrompt;
    }

    public void setParameterXsl(String xsl) {
        this.parameterXsl = xsl;
    }

    public String getActionName() {
        return this.actionName;
    }

    public String getActionPath() {
        return this.actionPath;
    }

    public void setActionPath(String actionPath) {
        this.actionPath = actionPath;
    }

    public void setCreateFeedbackParameterCallback(ICreateFeedbackParameterCallback createFeedbackParameterCallback) {
        this.createFeedbackParameterCallback = createFeedbackParameterCallback;
    }
}

