/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.List;
import org.pentaho.platform.api.engine.ActionSequenceException;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;

public abstract class PentahoMessenger
extends PentahoBase {
    private List messages;
    DateFormat dateFormat = LocaleHelper.getFullDateFormat((boolean)true, (boolean)true);

    public List getMessages() {
        return this.messages;
    }

    public void setMessages(List messages) {
        this.messages = messages;
    }

    public void trace(String message) {
        if (this.loggingLevel <= 1) {
            if (this.messages != null) {
                this.messages.add(Messages.getString("Message.USER_DEBUG", message, ((Object)((Object)this)).getClass().getName()));
            }
            super.trace(message);
        }
    }

    public void debug(String message) {
        if (this.loggingLevel <= 2) {
            if (this.messages != null) {
                this.messages.add(Messages.getString("Message.USER_DEBUG", message, ((Object)((Object)this)).getClass().getName()));
            }
            super.debug(message);
        }
    }

    public void info(String message) {
        if (this.loggingLevel <= 3) {
            if (this.messages != null) {
                this.messages.add(Messages.getString("Message.USER_INFO", message, ((Object)((Object)this)).getClass().getName()));
            }
            super.info(message);
        }
    }

    public void warn(String message) {
        if (this.loggingLevel <= 4) {
            if (this.messages != null) {
                this.messages.add(Messages.getString("Message.USER_WARNING", message, ((Object)((Object)this)).getClass().getName()));
            }
            super.warn(message);
        }
    }

    public void error(ActionSequenceException exception) {
        if (this.loggingLevel <= 5) {
            if (this.messages != null) {
                this.messages.add(exception);
            }
            CharArrayWriter charWriter = new CharArrayWriter();
            PrintWriter printWriter = new PrintWriter(charWriter);
            printWriter.println(this.getLogId() + Messages.getString("MessageFormatter.ACTION_SEQUENCE_EXECUTION_FAILED"));
            printWriter.println(Messages.getString("MessageFormatter.LOG_EXCEPTION_TIME", this.dateFormat.format(exception.getDate())));
            printWriter.println(Messages.getString("MessageFormatter.LOG_EXCEPTION_SESSION_ID", exception.getSessionId() == null ? "" : exception.getSessionId()));
            printWriter.println(Messages.getString("MessageFormatter.LOG_EXCEPTION_INSTANCE_ID", exception.getInstanceId() == null ? "" : exception.getInstanceId()));
            printWriter.println(Messages.getString("MessageFormatter.LOG_EXCEPTION_ACTION_SEQUENCE", exception.getActionSequenceName() == null ? "" : exception.getActionSequenceName()));
            printWriter.println(Messages.getString("MessageFormatter.LOG_EXCEPTION_ACTION_SEQUENCE_EXECUTION_STACK"));
            exception.printActionExecutionStack(printWriter);
            printWriter.println(Messages.getString("MessageFormatter.LOG_EXCEPTION_ACTION_CLASS", exception.getActionClass() == null ? Messages.getString("MessageFormatter.EXCEPTION_FIELD_NOT_APPLICABLE") : exception.getActionClass()));
            printWriter.println(Messages.getString("MessageFormatter.LOG_EXCEPTION_ACTION_DESC", exception.getStepDescription() == null ? "" : exception.getStepDescription()));
            printWriter.println(Messages.getString("MessageFormatter.LOG_EXCEPTION_LOOP_INDEX", exception.getLoopIndex() == null ? Messages.getString("MessageFormatter.EXCEPTION_FIELD_NOT_APPLICABLE") : exception.getLoopIndex().toString()));
            printWriter.print(Messages.getString("MessageFormatter.EXCEPTION_STACK_TRACE"));
            exception.printStackTrace(printWriter);
            this.getLogger().error((Object)charWriter.toString());
        }
    }

    public void error(String message) {
        if (this.loggingLevel <= 5) {
            if (this.messages != null) {
                this.messages.add(Messages.getString("Message.USER_ERROR", message, ((Object)((Object)this)).getClass().getName()));
            }
            super.error(message);
        }
    }

    public void fatal(String message) {
        if (this.loggingLevel <= 6) {
            if (this.messages != null) {
                this.messages.add(Messages.getString("Message.USER_ERROR", message, ((Object)((Object)this)).getClass().getName()));
            }
            super.fatal(message);
        }
    }

    public void trace(String message, Throwable error) {
        if (this.loggingLevel <= 1) {
            if (this.messages != null) {
                this.messages.add(Messages.getString("Message.USER_DEBUG", message, ((Object)((Object)this)).getClass().getName()));
            }
            super.trace(message, error);
        }
    }

    public void debug(String message, Throwable error) {
        if (this.loggingLevel <= 2) {
            if (this.messages != null) {
                this.messages.add(Messages.getString("Message.USER_DEBUG", message, ((Object)((Object)this)).getClass().getName()));
            }
            super.debug(message, error);
        }
    }

    public void info(String message, Throwable error) {
        if (this.loggingLevel <= 3) {
            if (this.messages != null) {
                this.messages.add(Messages.getString("Message.USER_INFO", message, ((Object)((Object)this)).getClass().getName()));
            }
            super.info(message, error);
        }
    }

    public void warn(String message, Throwable error) {
        if (this.loggingLevel <= 4) {
            if (this.messages != null) {
                this.messages.add(Messages.getString("Message.USER_WARNING", message, ((Object)((Object)this)).getClass().getName()));
            }
            super.warn(message, error);
        }
    }

    public void error(String message, Throwable error) {
        if (this.loggingLevel <= 5) {
            if (this.messages != null) {
                this.messages.add(Messages.getString("Message.USER_ERROR_EX", message, ((Object)((Object)this)).getClass().getName(), error.toString()));
            }
            super.error(message, error);
        }
    }

    public void fatal(String message, Throwable error) {
        if (this.loggingLevel <= 6) {
            if (this.messages != null) {
                this.messages.add(Messages.getString("Message.USER_ERROR_EX", message, ((Object)((Object)this)).getClass().getName(), error.toString()));
            }
            super.fatal(message, error);
        }
    }

    public static String getUserString(String type) {
        return Messages.getString("Message.USER_" + type);
    }
}

