/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.engine.core.output.SimpleOutputHandler;
import org.pentaho.platform.engine.services.PentahoMessenger;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;

public class SoapHelper {
    private static final Log logger = LogFactory.getLog(SoapHelper.class);

    public static void generateSoapResponse(IRuntimeContext context, OutputStream outputStream, SimpleOutputHandler outputHandler, OutputStream contentStream, List messages) {
        StringBuffer messageBuffer = new StringBuffer();
        SoapHelper.generateSoapResponse(context, outputHandler, contentStream, messageBuffer, messages);
        try {
            outputStream.write(messageBuffer.toString().getBytes(LocaleHelper.getSystemEncoding()));
        }
        catch (IOException e) {
            logger.error(null, (Throwable)e);
        }
    }

    public static String getSoapHeader() {
        return "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n <SOAP-ENV:Body>\n";
    }

    public static String getSoapFooter() {
        return "</SOAP-ENV:Body>\n</SOAP-ENV:Envelope>";
    }

    public static void generateSoapError(StringBuffer messageBuffer, List messages) {
        String message = null;
        String errorStart = PentahoMessenger.getUserString("ERROR");
        int pos = errorStart.indexOf(123);
        if (pos != -1) {
            errorStart = errorStart.substring(0, pos);
        }
        for (String msg : messages) {
            if (msg.indexOf(errorStart) != 0) continue;
            message = msg;
        }
        messageBuffer.append("<SOAP-ENV:Fault>\n");
        if (message == null) {
            message = Messages.getErrorString("SoapHelper.ERROR_0001_UNKNOWN_ERROR");
        }
        boolean senderFault = message.indexOf("SolutionEngine.ERROR_0002") != -1 || message.indexOf("SolutionEngine.ERROR_0003") != -1 || message.indexOf("SolutionEngine.ERROR_0004") != -1 || message.indexOf("SolutionEngine.ERROR_0005") != -1;
        messageBuffer.append("<SOAP-ENV:faultcode>\n <SOAP-ENV:Subcode>\n<SOAP-ENV:Value><![CDATA[" + message + "]]></SOAP-ENV:Value>\n </SOAP-ENV:Subcode>\n </SOAP-ENV:faultcode>");
        if (senderFault) {
            messageBuffer.append("<SOAP-ENV:faultactor>SOAP-ENV:Client</SOAP-ENV:faultactor>\n");
        } else {
            messageBuffer.append("<SOAP-ENV:faultactor>SOAP-ENV:Server</SOAP-ENV:faultactor>\n");
        }
        messageBuffer.append("<SOAP-ENV:faultstring><SOAP-ENV:Text xml:lang=\"" + LocaleHelper.getDefaultLocale().toString() + "\"><![CDATA[" + message + "]]></SOAP-ENV:Text>\n </SOAP-ENV:faultstring>\n");
        messageBuffer.append("<SOAP-ENV:Detail>");
        Iterator messageIterator = messages.iterator();
        while (messageIterator.hasNext()) {
            messageBuffer.append("<message name=\"trace\"><![CDATA[" + (String)messageIterator.next() + "]]></message>\n");
        }
        messageBuffer.append("</SOAP-ENV:Detail>");
        messageBuffer.append("</SOAP-ENV:Fault>\n");
    }

    public static String openSoapResponse() {
        return "<ExecuteActivityResponse xmlns:m=\"http://pentaho.org\">\n";
    }

    public static String closeSoapResponse() {
        return "</ExecuteActivityResponse>\n";
    }

    public static void generateSoapResponse(IRuntimeContext context, SimpleOutputHandler outputHandler, OutputStream contentStream, StringBuffer messageBuffer, List messages) {
        if (context == null || context.getStatus() != 6) {
            SoapHelper.generateSoapError(messageBuffer, messages);
        } else {
            messageBuffer.append(SoapHelper.openSoapResponse());
            IContentItem contentItem = outputHandler.getFeedbackContentItem();
            Set outputNames = context.getOutputNames();
            for (String outputName : outputNames) {
                contentItem = outputHandler.getOutputContentItem("response", "content", context.getSolutionName(), context.getInstanceId(), "text/xml");
                if (outputNames.size() == 1 && contentItem != null) {
                    String mimeType = contentItem.getMimeType();
                    if (mimeType != null && mimeType.startsWith("text/")) {
                        if (mimeType.equals("text/xml")) {
                            messageBuffer.append("<").append(outputName).append(">").append(contentStream.toString()).append("</").append(outputName).append(">");
                            continue;
                        }
                        if (!mimeType.startsWith("text/")) continue;
                        messageBuffer.append("<").append(outputName).append("><![CDATA[").append(contentStream.toString()).append("]]></").append(outputName).append(">");
                        continue;
                    }
                    Object value = context.getOutputParameter(outputName).getValue();
                    if (value == null) {
                        value = "";
                    }
                    messageBuffer.append(SoapHelper.toSOAP(outputName, value));
                    continue;
                }
                Object value = context.getOutputParameter(outputName).getValue();
                if (value == null) {
                    value = "";
                }
                messageBuffer.append(SoapHelper.toSOAP(outputName, value));
            }
            messageBuffer.append(SoapHelper.closeSoapResponse());
        }
    }

    public static String toSOAP(String name, Object item) {
        if (item instanceof String) {
            return SoapHelper.toSOAP(name, (String)item);
        }
        if (item instanceof List) {
            return SoapHelper.toSOAP(name, (List)item);
        }
        if (item instanceof IPentahoResultSet) {
            return SoapHelper.toSOAP(name, (IPentahoResultSet)item);
        }
        if (item instanceof IContentItem) {
            return SoapHelper.toSOAP(name, ((IContentItem)item).getId());
        }
        return null;
    }

    private static String toSOAP(String name, IPentahoResultSet resultSet) {
        int column;
        boolean hasRowHeaders;
        StringBuffer messageBuffer = new StringBuffer();
        messageBuffer.append("<" + name + ">\n");
        Object[][] columnHeaders = resultSet.getMetaData().getColumnHeaders();
        Object[][] rowHeaders = resultSet.getMetaData().getRowHeaders();
        boolean hasColumnHeaders = columnHeaders != null;
        boolean bl = hasRowHeaders = rowHeaders != null;
        if (hasColumnHeaders) {
            for (Object[] element : columnHeaders) {
                messageBuffer.append("<COLUMN-HDR-ROW>\n");
                for (column = 0; column < element.length; ++column) {
                    messageBuffer.append("<COLUMN-HDR-ITEM><![CDATA[").append(element[column]).append("]]></COLUMN-HDR-ITEM>\n");
                }
                messageBuffer.append("</COLUMN-HDR-ROW>\n");
            }
        }
        if (hasRowHeaders) {
            for (Object[] element : rowHeaders) {
                messageBuffer.append("<ROW-HDR-ROW>\n");
                for (column = 0; column < element.length; ++column) {
                    messageBuffer.append("<ROW-HDR-ITEM><![CDATA[").append(element[column]).append("]]></ROW-HDR-ITEM>\n");
                }
                messageBuffer.append("</ROW-HDR-ROW>\n");
            }
        }
        Object[] dataRow = resultSet.next();
        while (dataRow != null) {
            messageBuffer.append("<DATA-ROW>\n");
            for (Object element : dataRow) {
                messageBuffer.append("<DATA-ITEM><![CDATA[").append(element).append("]]></DATA-ITEM>\n");
            }
            messageBuffer.append("</DATA-ROW>\n");
            dataRow = resultSet.next();
        }
        messageBuffer.append("</" + name + ">\n");
        return messageBuffer.toString();
    }

    public static String toSOAP(String name, String value) {
        return "<" + name + "><![CDATA[" + value + "]]></" + name + ">";
    }

    public static String toSOAP(String name, long value) {
        return "<" + name + "><![CDATA[" + value + "]]></" + name + ">";
    }

    public static String toSOAP(String name, Date value) {
        return "<" + name + "><![CDATA[" + value + "]]></" + name + ">";
    }

    public static String toSOAP(String name, List list) {
        return "<" + name + "><![CDATA[" + list.toString() + "]]></" + name + ">";
    }
}

