/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.pentaho.platform.api.engine.IDocumentResourceLoader;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.logging.Logger;
import org.xml.sax.InputSource;

public class SolutionURIResolver
implements URIResolver,
IDocumentResourceLoader {
    IPentahoSession session = null;
    ISolutionRepository repository = null;

    public SolutionURIResolver(IPentahoSession session) {
        this.session = session;
        this.repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)session);
    }

    public SolutionURIResolver(ISolutionRepository repository) {
        this.repository = repository;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        if (this.repository != null) {
            InputStream xslIS = null;
            try {
                if (systemId.toLowerCase().indexOf(".dtd") >= 0) {
                    return this.resolveDTDEntity(publicId, systemId);
                }
                xslIS = this.repository.getResourceInputStream(systemId, true, 1);
                return new InputSource(xslIS);
            }
            catch (IOException e) {
                Logger.error((Object)this, (String)e.getLocalizedMessage());
            }
        }
        return null;
    }

    public InputSource resolveDTDEntity(String publicId, String systemId) throws IOException {
        int idx = systemId.lastIndexOf(47);
        String dtdName = systemId.substring(idx + 1);
        String fullPath = PentahoSystem.getApplicationContext().getSolutionPath("system/dtd/" + dtdName);
        File theFile = new File(fullPath);
        if (theFile.canRead()) {
            BufferedInputStream xslIS = new BufferedInputStream(new FileInputStream(theFile));
            InputSource source = new InputSource(xslIS);
            return source;
        }
        return null;
    }

    public Source resolve(String href, String base) {
        StreamSource xslSrc = null;
        if (this.repository != null) {
            InputStream xslIS = null;
            try {
                xslIS = this.repository.getResourceInputStream(href, true, 1);
            }
            catch (FileNotFoundException e) {
                Logger.error((Object)this, (String)e.getLocalizedMessage());
                return null;
            }
            xslSrc = new StreamSource(xslIS);
        }
        return xslSrc;
    }

    public InputStream loadXsl(String name) {
        InputStream xslIS = null;
        if (this.repository != null) {
            try {
                xslIS = this.repository.getResourceInputStream(name, true, 1);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return xslIS;
    }
}

