/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Document;
import org.pentaho.platform.engine.services.SoapHelper;
import org.pentaho.platform.util.messages.LocaleHelper;

public class WebServiceUtil {
    public static void writeDocument(OutputStream outputStream, org.w3c.dom.Document doc, boolean wrapWithSOAP) throws IOException, TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError {
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(new StringWriter());
        TransformerFactory.newInstance().newTransformer().transform(source, result);
        String theXML = result.getWriter().toString();
        WebServiceUtil.writeString(outputStream, theXML, wrapWithSOAP);
    }

    public static void writeDocument(OutputStream outputStream, Document doc, boolean wrapWithSOAP) throws IOException {
        WebServiceUtil.writeString(outputStream, doc.asXML(), wrapWithSOAP);
    }

    public static void writeDocument(OutputStream outputStream, Document doc) throws IOException {
        WebServiceUtil.writeString(outputStream, doc.asXML(), false);
    }

    public static void writeString(OutputStream outputStream, String strXml) throws IOException {
        WebServiceUtil.writeString(outputStream, strXml, false);
    }

    public static void writeString(OutputStream outputStream, String strXml, boolean wrapWithSOAP) throws IOException {
        String xmlProcessingInstruction = null;
        int headerPos = strXml.indexOf("?>");
        if (headerPos > -1) {
            xmlProcessingInstruction = strXml.substring(0, headerPos + 2);
            strXml = strXml.substring(headerPos + 2);
        }
        if (null != xmlProcessingInstruction) {
            outputStream.write(xmlProcessingInstruction.getBytes(LocaleHelper.getSystemEncoding()));
        }
        if (wrapWithSOAP) {
            outputStream.write(SoapHelper.getSoapHeader().getBytes(LocaleHelper.getSystemEncoding()));
            outputStream.write(SoapHelper.openSoapResponse().getBytes(LocaleHelper.getSystemEncoding()));
            outputStream.write("<content>".getBytes(LocaleHelper.getSystemEncoding()));
        }
        outputStream.write(strXml.getBytes(LocaleHelper.getSystemEncoding()));
        if (wrapWithSOAP) {
            outputStream.write("</content>".getBytes(LocaleHelper.getSystemEncoding()));
            outputStream.write(SoapHelper.closeSoapResponse().getBytes(LocaleHelper.getSystemEncoding()));
            outputStream.write(SoapHelper.getSoapFooter().getBytes(LocaleHelper.getSystemEncoding()));
        }
    }

    public static String getStatusXml(String statusMsg) {
        statusMsg = StringEscapeUtils.escapeXml((String)statusMsg);
        return "<web-service><status msg=\"" + statusMsg + "\"/></web-service>";
    }

    public static String getErrorXml(String errorMsg) {
        errorMsg = StringEscapeUtils.escapeXml((String)errorMsg);
        return "<web-service><error msg=\"" + errorMsg + "\"/></web-service>";
    }
}

