/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.actionsequence;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.engine.services.messages.Messages;

public class ActionResource
implements IActionSequenceResource {
    private String name;
    private String mimeType;
    private String address;
    private int sourceType;

    public ActionResource(String name, int sourceType, String mimeType, String address) {
        this.name = name;
        this.mimeType = mimeType;
        this.sourceType = sourceType;
        this.address = address;
    }

    public ActionResource(String name, int sourceType, String mimeType, String solutionName, String solutionPath, String location) {
        this(name, sourceType, mimeType, null);
        this.address = sourceType == 1 ? ActionResource.getLocationInSolution(solutionName, solutionPath, location) : location;
    }

    private static String getLocationInSolution(String solutionName, String solutionPath, String location) {
        if (StringUtils.isEmpty((String)location)) {
            return null;
        }
        if (location.charAt(0) == '\\' || location.charAt(0) == '/') {
            return solutionName + File.separator + location;
        }
        if (location.startsWith("..", 0)) {
            assert (false) : Messages.getErrorString("ActionResource.ERROR_0001_FEATURE_NOT_IMPLEMENTED");
            return null;
        }
        if ("".equals(solutionPath)) {
            return solutionName + File.separator + location;
        }
        return solutionName + File.separator + solutionPath + File.separator + location;
    }

    public static int getResourceType(String sourceTypeName) {
        if ("solution-file".equals(sourceTypeName)) {
            return 1;
        }
        if ("file".equals(sourceTypeName)) {
            return 3;
        }
        if ("url".equals(sourceTypeName)) {
            return 2;
        }
        if ("xml".equals(sourceTypeName)) {
            return 6;
        }
        if ("string".equals(sourceTypeName)) {
            return 5;
        }
        return 4;
    }

    public String getName() {
        return this.name;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public int getSourceType() {
        return this.sourceType;
    }

    public String getAddress() {
        return this.address;
    }
}

