/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.actionsequence;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.IActionResource;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;
import org.pentaho.commons.connection.IPentahoStreamSource;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.IParameterResolver;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.repository.IContentItem;

public class ActionSequenceParameterMgr
implements IActionParameterMgr {
    IRuntimeContext runtimeContext;
    IPentahoSession pentahoSession;
    IParameterResolver parameterResolver;

    public ActionSequenceParameterMgr(IRuntimeContext runtimeContext, IPentahoSession session) {
        this(runtimeContext, session, null);
    }

    public ActionSequenceParameterMgr(IRuntimeContext runtimeContext, IPentahoSession session, IParameterResolver parameterResolver) {
        this.runtimeContext = runtimeContext;
        this.pentahoSession = session;
        this.parameterResolver = parameterResolver;
    }

    public Object getInputValue(IActionInput actionInput) {
        Object value = null;
        String variableName = actionInput.getName();
        if (this.runtimeContext.getInputNames().contains(variableName)) {
            value = this.runtimeContext.getInputParameterValue(variableName);
        }
        if (value instanceof IContentItem) {
            value = ((IContentItem)value).getInputStream();
        }
        return value;
    }

    public String replaceParameterReferences(String inputString) {
        return this.runtimeContext.applyInputsToFormat(inputString, this.parameterResolver);
    }

    public IPentahoStreamSource getDataSource(IActionResource actionResource) throws FileNotFoundException {
        IPentahoStreamSource dataSrc = null;
        IActionSequenceResource resource = this.runtimeContext.getResourceDefintion(actionResource.getName());
        if (resource != null) {
            dataSrc = this.runtimeContext.getResourceDataSource(resource);
        }
        return dataSrc;
    }

    public String getString(IActionResource actionResource) throws IOException {
        String resourceString = null;
        IActionSequenceResource resource = this.runtimeContext.getResourceDefintion(actionResource.getName());
        if (resource != null) {
            resourceString = this.runtimeContext.getResourceAsString(resource);
        }
        return resourceString;
    }

    public IPentahoStreamSource getDataSource(IActionInput actionInput) {
        return this.runtimeContext.getDataSource(actionInput.getName());
    }

    public void setOutputValue(IActionOutput actionOutput, Object value) {
        this.runtimeContext.setOutputValue(actionOutput.getName(), value);
    }

    public InputStream getInputStream(IActionResource resource) throws FileNotFoundException {
        return null;
    }
}

