/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.audit;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.pentaho.platform.api.engine.AuditException;
import org.pentaho.platform.api.engine.IAuditEntry;
import org.pentaho.platform.engine.core.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.logging.Logger;

public class AuditFileEntry
implements IAuditEntry {
    private static final String auditDirPath = "system/logs/audit";
    private static final String auditFileName = PentahoSystem.getSystemSetting((String)"audit/auditLogFile", (String)"/PentahoAuditLog.log");
    private static File auditFile = null;
    private static String ID_SEPARATOR = PentahoSystem.getSystemSetting((String)"audit/id_separator", (String)"\t");
    private static final SimpleDateFormat auditDateFormat = new SimpleDateFormat(PentahoSystem.getSystemSetting((String)"audit/auditDateFormat", (String)"yyyy/MM/dd k:mm:ss"));

    public AuditFileEntry() {
        File auditDir = new File(PentahoSystem.getApplicationContext().getFileOutputPath(auditDirPath));
        if (!auditDir.exists()) {
            auditDir.mkdirs();
        } else if (!auditDir.isDirectory()) {
            Logger.error((Object)this, (String)Messages.getErrorString((String)"AUDFILEENT.ERROR_0001_AUDIT_PATH_NOT_DIRECTORY", (String)auditDirPath));
            return;
        }
        auditFile = new File(auditDir, auditFileName);
        if ("\\t".equals(ID_SEPARATOR)) {
            ID_SEPARATOR = "\t";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void auditAll(String jobId, String instId, String objId, String objType, String actor, String messageType, String messageName, String messageTxtValue, BigDecimal messageNumValue, double duration) throws AuditException {
        if (auditFile == null) {
            return;
        }
        try {
            BufferedWriter fw = new BufferedWriter(new FileWriter(auditFile, true));
            try {
                Date dt = new Date();
                fw.write(auditDateFormat.format(dt));
                fw.write(ID_SEPARATOR);
                fw.write(this.getWritable(jobId));
                fw.write(ID_SEPARATOR);
                fw.write(this.getWritable(instId));
                fw.write(ID_SEPARATOR);
                fw.write(this.getWritable(objId));
                fw.write(ID_SEPARATOR);
                fw.write(this.getWritable(objType));
                fw.write(ID_SEPARATOR);
                fw.write(this.getWritable(actor));
                fw.write(ID_SEPARATOR);
                fw.write(this.getWritable(messageType));
                fw.write(ID_SEPARATOR);
                fw.write(this.getWritable(messageName));
                fw.write(ID_SEPARATOR);
                fw.write(this.getWritable(messageTxtValue));
                fw.write(ID_SEPARATOR);
                fw.write(this.getWritable(messageNumValue));
                fw.write(ID_SEPARATOR);
                fw.write(this.getWritable(duration));
                fw.newLine();
            }
            finally {
                fw.flush();
                fw.close();
            }
        }
        catch (IOException ex) {
            throw new AuditException((Throwable)ex);
        }
    }

    private String getWritable(Object obj) {
        if (obj instanceof BigDecimal) {
            DecimalFormat format = new DecimalFormat("#.###");
            return format.format(obj);
        }
        return obj != null ? obj.toString() : "";
    }
}

