/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.connection.datasource.dbcp;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.pentaho.platform.api.data.DatasourceServiceException;
import org.pentaho.platform.api.data.IDatasourceService;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public abstract class BaseDatasourceService
implements IDatasourceService {
    ICacheManager cacheManager = PentahoSystem.getCacheManager(null);

    public void clearCache() {
        this.cacheManager.removeRegionCache("DataSource");
    }

    public void clearDataSource(String dsName) {
        this.cacheManager.removeFromRegionCache("DataSource", (Object)dsName);
    }

    protected DataSource getJndiDataSource(String dsName) throws DatasourceServiceException {
        Object foundDs = null;
        if (!this.cacheManager.cacheEnabled("DataSource")) {
            this.cacheManager.addCacheRegion("DataSource");
        }
        if ((foundDs = this.cacheManager.getFromRegionCache("DataSource", (Object)dsName)) != null) {
            return (DataSource)foundDs;
        }
        try {
            InitialContext ctx = new InitialContext();
            Object lkup = null;
            DataSource rtn = null;
            NamingException firstNe = null;
            try {
                lkup = ctx.lookup(dsName);
                if (lkup != null) {
                    rtn = (DataSource)lkup;
                    this.cacheManager.putInRegionCache("DataSource", (Object)dsName, (Object)rtn);
                    return rtn;
                }
            }
            catch (NamingException ignored) {
                firstNe = ignored;
            }
            try {
                lkup = ctx.lookup("java:" + dsName);
                if (lkup != null) {
                    rtn = (DataSource)lkup;
                    this.cacheManager.putInRegionCache("DataSource", (Object)dsName, (Object)rtn);
                    return rtn;
                }
            }
            catch (NamingException ignored) {
                // empty catch block
            }
            try {
                lkup = ctx.lookup("java:comp/env/jdbc/" + dsName);
                if (lkup != null) {
                    rtn = (DataSource)lkup;
                    this.cacheManager.putInRegionCache("DataSource", (Object)dsName, (Object)rtn);
                    return rtn;
                }
            }
            catch (NamingException ignored) {
                // empty catch block
            }
            try {
                lkup = ctx.lookup("jdbc/" + dsName);
                if (lkup != null) {
                    rtn = (DataSource)lkup;
                    this.cacheManager.putInRegionCache("DataSource", (Object)dsName, (Object)rtn);
                    return rtn;
                }
            }
            catch (NamingException ignored) {
                // empty catch block
            }
            if (firstNe != null) {
                throw new DatasourceServiceException((Throwable)firstNe);
            }
            throw new DatasourceServiceException(dsName);
        }
        catch (NamingException ne) {
            throw new DatasourceServiceException((Throwable)ne);
        }
    }

    public String getDSBoundName(String dsName) throws DatasourceServiceException {
        try {
            InitialContext ctx = new InitialContext();
            Object lkup = null;
            NamingException firstNe = null;
            String rtn = dsName;
            try {
                lkup = ctx.lookup(rtn);
                if (lkup != null) {
                    return rtn;
                }
            }
            catch (NamingException ignored) {
                firstNe = ignored;
            }
            try {
                rtn = "java:" + dsName;
                lkup = ctx.lookup(rtn);
                if (lkup != null) {
                    return rtn;
                }
            }
            catch (NamingException ignored) {
                // empty catch block
            }
            try {
                rtn = "java:comp/env/jdbc/" + dsName;
                lkup = ctx.lookup(rtn);
                if (lkup != null) {
                    return rtn;
                }
            }
            catch (NamingException ignored) {
                // empty catch block
            }
            try {
                rtn = "jdbc/" + dsName;
                lkup = ctx.lookup(rtn);
                if (lkup != null) {
                    return rtn;
                }
            }
            catch (NamingException ignored) {
                // empty catch block
            }
            if (firstNe != null) {
                throw new DatasourceServiceException((Throwable)firstNe);
            }
            throw new DatasourceServiceException(dsName);
        }
        catch (NamingException ne) {
            throw new DatasourceServiceException((Throwable)ne);
        }
    }

    public String getDSUnboundName(String dsName) {
        if (null == dsName) {
            return null;
        }
        String PREFIX_TOMCAT = "java:comp/env/jdbc/";
        String PREFIX_JBOSS = "java:";
        String PREFIX_OTHER = "jdbc/";
        if (dsName.startsWith("java:comp/env/jdbc/")) {
            return dsName.substring("java:comp/env/jdbc/".length());
        }
        if (dsName.startsWith("java:")) {
            return dsName.substring("java:".length());
        }
        if (dsName.startsWith("jdbc/")) {
            return dsName.substring("jdbc/".length());
        }
        int last = dsName.lastIndexOf("/");
        if (last < dsName.lastIndexOf(":")) {
            last = dsName.lastIndexOf(":");
        }
        if (last != -1) {
            return dsName.substring(last + 1);
        }
        return dsName;
    }
}

