/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.connection.datasource.dbcp;

import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.pentaho.platform.api.data.DatasourceServiceException;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.repository.datasource.DatasourceMgmtServiceException;
import org.pentaho.platform.api.repository.datasource.IDatasource;
import org.pentaho.platform.api.repository.datasource.IDatasourceMgmtService;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.BaseDatasourceService;
import org.pentaho.platform.engine.services.messages.Messages;

public class NonPooledDatasourceService
extends BaseDatasourceService {
    public DataSource getDataSource(String dsName) throws DatasourceServiceException {
        DataSource dataSource = null;
        Object foundDs = null;
        if (!this.cacheManager.cacheEnabled("DataSource")) {
            this.cacheManager.addCacheRegion("DataSource");
        }
        if ((foundDs = this.cacheManager.getFromRegionCache("DataSource", (Object)dsName)) != null) {
            return (DataSource)foundDs;
        }
        try {
            IDatasourceMgmtService datasourceMgmtSvc = (IDatasourceMgmtService)PentahoSystem.getObjectFactory().get(IDatasourceMgmtService.class, null);
            IDatasource datasource = datasourceMgmtSvc.getDatasource(dsName);
            if (datasource == null) {
                throw new DatasourceServiceException(Messages.getErrorString("NonPooledDatasourceService.ERROR_0002_UNABLE_TO_GET_DATASOURCE"));
            }
            dataSource = this.convert(datasource);
            this.cacheManager.putInRegionCache("DataSource", (Object)dsName, (Object)dataSource);
        }
        catch (ObjectFactoryException objface) {
            throw new DatasourceServiceException(Messages.getErrorString("NonPooledDatasourceService.ERROR_0001_UNABLE_TO_INSTANTIATE_OBJECT"), (Throwable)objface);
        }
        catch (DatasourceMgmtServiceException daoe) {
            throw new DatasourceServiceException(Messages.getErrorString("NonPooledDatasourceService.ERROR_0002_UNABLE_TO_GET_DATASOURCE"), (Throwable)daoe);
        }
        return dataSource;
    }

    public String getDSBoundName(String dsName) throws DatasourceServiceException {
        return dsName;
    }

    public String getDSUnboundName(String dsName) {
        return dsName;
    }

    private DataSource convert(IDatasource datasource) {
        BasicDataSource basicDatasource = new BasicDataSource();
        basicDatasource.setDriverClassName(datasource.getDriverClass());
        basicDatasource.setMaxActive(datasource.getMaxActConn());
        basicDatasource.setMaxIdle(datasource.getIdleConn());
        basicDatasource.setMaxWait(datasource.getWait());
        basicDatasource.setUrl(datasource.getUrl());
        basicDatasource.setUsername(datasource.getUserName());
        basicDatasource.setPassword(datasource.getPassword());
        basicDatasource.setValidationQuery(datasource.getQuery());
        return basicDatasource;
    }
}

