/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.connection.datasource.dbcp;

import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.repository.datasource.DatasourceMgmtServiceException;
import org.pentaho.platform.api.repository.datasource.IDatasource;
import org.pentaho.platform.api.repository.datasource.IDatasourceMgmtService;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.util.logging.Logger;

public class NonPooledDatasourceSystemListener
implements IPentahoSystemListener {
    public static final String DATASOURCE_REGION = "DATASOURCE";

    public boolean startup(IPentahoSession session) {
        try {
            ICacheManager cacheManager = PentahoSystem.getCacheManager(null);
            Logger.debug((Object)this, (String)"NonPooledDatasourceSystemListener: called for startup");
            boolean cachingAvailable = cacheManager != null && cacheManager.cacheEnabled();
            IDatasourceMgmtService datasourceMgmtSvc = (IDatasourceMgmtService)PentahoSystem.getObjectFactory().get(IDatasourceMgmtService.class, session);
            if (cachingAvailable && !cacheManager.cacheEnabled("DataSource")) {
                cacheManager.addCacheRegion("DataSource");
            }
            List datasources = datasourceMgmtSvc.getDatasources();
            for (IDatasource datasource : datasources) {
                Logger.debug((Object)this, (String)("(storing DataSource under key \"DataSource" + datasource.getName() + "\")"));
                cacheManager.putInRegionCache("DataSource", (Object)datasource.getName(), (Object)this.convert(datasource));
            }
            Logger.debug((Object)this, (String)"NonPooledDatasourceSystemListener: done with init");
            return true;
        }
        catch (ObjectFactoryException objface) {
            Logger.error((Object)this, (String)Messages.getErrorString("NonPooledDatasourceSystemListener.ERROR_0001_UNABLE_TO_INSTANTIATE_OBJECT", NonPooledDatasourceSystemListener.class.getName()), (Throwable)objface);
            return false;
        }
        catch (DatasourceMgmtServiceException dmse) {
            Logger.error((Object)this, (String)Messages.getErrorString("NonPooledDatasourceSystemListener.ERROR_0002_UNABLE_TO_GET_DATASOURCE", NonPooledDatasourceSystemListener.class.getName()), (Throwable)dmse);
            return false;
        }
    }

    public void shutdown() {
        ICacheManager cacheManager = PentahoSystem.getCacheManager(null);
        Logger.debug((Object)this, (String)"NonPooledDatasourceSystemListener: called for shutdown");
        cacheManager.removeRegionCache("DataSource");
        Logger.debug((Object)this, (String)"NonPooledDatasourceSystemListener: completed shutdown");
    }

    private DataSource convert(IDatasource datasource) {
        BasicDataSource basicDatasource = new BasicDataSource();
        basicDatasource.setDriverClassName(datasource.getDriverClass());
        basicDatasource.setMaxActive(datasource.getMaxActConn());
        basicDatasource.setMaxIdle(datasource.getIdleConn());
        basicDatasource.setMaxWait(datasource.getWait());
        basicDatasource.setUrl(datasource.getUrl());
        basicDatasource.setUsername(datasource.getUserName());
        basicDatasource.setPassword(datasource.getPassword());
        basicDatasource.setValidationQuery(datasource.getQuery());
        return basicDatasource;
    }
}

