/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.connection.datasource.dbcp;

import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.pentaho.platform.api.data.DatasourceServiceException;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.repository.datasource.IDatasource;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.platform.util.logging.Logger;

public class PooledDatasourceHelper {
    public static PoolingDataSource setupPooledDataSource(IDatasource datasource) throws DatasourceServiceException {
        try {
            int maxIdleConnection;
            PoolingDataSource poolingDataSource = null;
            ICacheManager cacheManager = PentahoSystem.getCacheManager(null);
            String maxdleConn = PentahoSystem.getSystemSetting((String)"dbcp-defaults/max-idle-conn", null);
            String minIdleConn = PentahoSystem.getSystemSetting((String)"dbcp-defaults/min-idle-conn", null);
            String maxActConn = PentahoSystem.getSystemSetting((String)"dbcp-defaults/max-act-conn", null);
            String numIdleConn = PentahoSystem.getSystemSetting((String)"dbcp-defaults/num-idle-conn", null);
            String validQuery = null;
            String whenExhaustedAction = PentahoSystem.getSystemSetting((String)"dbcp-defaults/when-exhausted-action", null);
            String wait = PentahoSystem.getSystemSetting((String)"dbcp-defaults/wait", null);
            String testWhileIdleValue = PentahoSystem.getSystemSetting((String)"dbcp-defaults/test-while-idle", null);
            String testOnBorrowValue = PentahoSystem.getSystemSetting((String)"dbcp-defaults/test-on-borrow", null);
            String testOnReturnValue = PentahoSystem.getSystemSetting((String)"dbcp-defaults/test-on-return", null);
            boolean testWhileIdle = !StringUtil.isEmpty((String)testWhileIdleValue) ? Boolean.parseBoolean(testWhileIdleValue) : false;
            boolean testOnBorrow = !StringUtil.isEmpty((String)testOnBorrowValue) ? Boolean.parseBoolean(testOnBorrowValue) : false;
            boolean testOnReturn = !StringUtil.isEmpty((String)testOnReturnValue) ? Boolean.parseBoolean(testOnReturnValue) : false;
            int maxActiveConnection = -1;
            int numIdleConnection = -1;
            long waitTime = -1L;
            byte whenExhaustedActionType = -1;
            int minIdleConnection = !StringUtil.isEmpty((String)minIdleConn) ? Integer.parseInt(minIdleConn) : -1;
            int n = maxIdleConnection = !StringUtil.isEmpty((String)maxdleConn) ? Integer.parseInt(maxdleConn) : -1;
            if (datasource.getMaxActConn() > 0) {
                maxActiveConnection = datasource.getMaxActConn();
            } else if (!StringUtil.isEmpty((String)maxActConn)) {
                maxActiveConnection = Integer.parseInt(maxActConn);
            }
            if (datasource.getIdleConn() > 0) {
                numIdleConnection = datasource.getIdleConn();
            } else if (!StringUtil.isEmpty((String)numIdleConn)) {
                numIdleConnection = Integer.parseInt(numIdleConn);
            }
            if (datasource.getWait() > 0L) {
                waitTime = datasource.getWait();
            } else if (!StringUtil.isEmpty((String)wait)) {
                waitTime = Long.parseLong(wait);
            }
            if (!StringUtil.isEmpty((String)datasource.getQuery())) {
                validQuery = datasource.getQuery();
            }
            whenExhaustedActionType = !StringUtil.isEmpty((String)whenExhaustedAction) ? (byte)Byte.parseByte(whenExhaustedAction) : (byte)1;
            poolingDataSource = new PoolingDataSource();
            Class.forName(datasource.getDriverClass());
            GenericObjectPool pool = new GenericObjectPool(null);
            pool.setWhenExhaustedAction(whenExhaustedActionType);
            pool.setMaxActive(maxActiveConnection);
            pool.setMaxIdle(maxIdleConnection);
            pool.setMaxWait(waitTime);
            pool.setMinIdle(minIdleConnection);
            pool.setTestWhileIdle(testWhileIdle);
            pool.setTestOnReturn(testOnReturn);
            pool.setTestOnBorrow(testOnBorrow);
            pool.setTestWhileIdle(testWhileIdle);
            DriverManagerConnectionFactory factory = new DriverManagerConnectionFactory(datasource.getUrl(), datasource.getUserName(), datasource.getPassword());
            PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)factory, (ObjectPool)pool, null, validQuery, false, true);
            Logger.debug(PooledDatasourceHelper.class, (String)("Pool defaults to " + maxActiveConnection + " max active/" + maxIdleConnection + "max idle" + "with " + waitTime + "wait time" + " idle connections."));
            for (int i = 0; i < maxIdleConnection; ++i) {
                pool.addObject();
            }
            Logger.debug(PooledDatasourceHelper.class, (String)("Pool now has " + pool.getNumActive() + " active/" + pool.getNumIdle() + " idle connections."));
            poolingDataSource.setPool((ObjectPool)pool);
            cacheManager.putInRegionCache("JDBC_POOL", (Object)datasource.getName(), (Object)pool);
            return poolingDataSource;
        }
        catch (Exception e) {
            throw new DatasourceServiceException((Throwable)e);
        }
    }
}

