/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.connection.datasource.dbcp;

import javax.sql.DataSource;
import org.apache.commons.dbcp.PoolingDataSource;
import org.pentaho.platform.api.data.DatasourceServiceException;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.repository.datasource.DatasourceMgmtServiceException;
import org.pentaho.platform.api.repository.datasource.IDatasource;
import org.pentaho.platform.api.repository.datasource.IDatasourceMgmtService;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.BaseDatasourceService;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.PooledDatasourceHelper;
import org.pentaho.platform.engine.services.messages.Messages;

public class PooledDatasourceService
extends BaseDatasourceService {
    DataSource retrieve(String datasource) throws DatasourceServiceException {
        PoolingDataSource ds = null;
        try {
            IDatasourceMgmtService datasourceMgmtSvc = (IDatasourceMgmtService)PentahoSystem.getObjectFactory().get(IDatasourceMgmtService.class, null);
            IDatasource dataSource = datasourceMgmtSvc.getDatasource(datasource);
            if (datasource == null) {
                throw new DatasourceServiceException(Messages.getErrorString("PooledDatasourceService.ERROR_0002_UNABLE_TO_GET_DATASOURCE"));
            }
            ds = PooledDatasourceHelper.setupPooledDataSource(dataSource);
            this.cacheManager.putInRegionCache("DataSource", (Object)datasource, (Object)ds);
        }
        catch (ObjectFactoryException objface) {
            throw new DatasourceServiceException(Messages.getErrorString("PooledDatasourceService.ERROR_0001_UNABLE_TO_INSTANTIATE_OBJECT"), (Throwable)objface);
        }
        catch (DatasourceMgmtServiceException daoe) {
            throw new DatasourceServiceException(Messages.getErrorString("PooledDatasourceService.ERROR_0002_UNABLE_TO_GET_DATASOURCE"), (Throwable)daoe);
        }
        return ds;
    }

    public void clearCache() {
        this.cacheManager.removeRegionCache("DataSource");
    }

    public void clearDataSource(String dsName) {
        this.cacheManager.removeFromRegionCache("DataSource", (Object)dsName);
    }

    public DataSource getDataSource(String dsName) throws DatasourceServiceException {
        DataSource dataSource = null;
        if (this.cacheManager != null) {
            Object foundDs = this.cacheManager.getFromRegionCache("DataSource", (Object)dsName);
            dataSource = foundDs != null ? (DataSource)foundDs : this.retrieve(dsName);
        }
        return dataSource;
    }

    public String getDSBoundName(String dsName) throws DatasourceServiceException {
        return dsName;
    }

    public String getDSUnboundName(String dsName) {
        return dsName;
    }
}

