/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.connection.datasource.dbcp;

import java.util.List;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.pentaho.platform.api.data.DatasourceServiceException;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.repository.datasource.DatasourceMgmtServiceException;
import org.pentaho.platform.api.repository.datasource.IDatasource;
import org.pentaho.platform.api.repository.datasource.IDatasourceMgmtService;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.PooledDatasourceHelper;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.util.logging.Logger;

public class PooledDatasourceSystemListener
implements IPentahoSystemListener {
    public static final String DATASOURCE_REGION = "DATASOURCE";

    public boolean startup(IPentahoSession session) {
        try {
            ICacheManager cacheManager = PentahoSystem.getCacheManager(null);
            Logger.debug((Object)this, (String)"PooledDatasourceSystemListener: called for startup");
            IDatasourceMgmtService datasourceMgmtSvc = (IDatasourceMgmtService)PentahoSystem.getObjectFactory().get(IDatasourceMgmtService.class, session);
            if (!cacheManager.cacheEnabled("JDBC_POOL")) {
                cacheManager.addCacheRegion("JDBC_POOL");
            }
            if (!cacheManager.cacheEnabled("DataSource")) {
                cacheManager.addCacheRegion("DataSource");
            }
            List datasources = datasourceMgmtSvc.getDatasources();
            for (IDatasource datasource : datasources) {
                try {
                    Logger.debug((Object)this, (String)("  Setting up pooled Data Source - " + datasource));
                    PoolingDataSource ds = PooledDatasourceHelper.setupPooledDataSource(datasource);
                    Logger.debug((Object)this, (String)("(storing DataSource under key \"DataSource" + datasource.getName() + "\")"));
                    cacheManager.putInRegionCache("DataSource", (Object)datasource.getName(), (Object)ds);
                }
                catch (DatasourceServiceException dse) {
                    Logger.error((Object)this, (String)Messages.getErrorString("PooledDatasourceSystemListener.ERROR_0003_UNABLE_TO_POOL_DATASOURCE", datasource.getName(), dse.getMessage()));
                }
            }
            Logger.debug((Object)this, (String)"PooledDatasourceSystemListener: done with init");
            return true;
        }
        catch (ObjectFactoryException objface) {
            Logger.error((Object)this, (String)Messages.getErrorString("PooledDatasourceSystemListener.ERROR_0001_UNABLE_TO_INSTANTIATE_OBJECT"), (Throwable)objface);
            return false;
        }
        catch (DatasourceMgmtServiceException dmse) {
            Logger.error((Object)this, (String)Messages.getErrorString("PooledDatasourceSystemListener.ERROR_0002_UNABLE_TO_GET_DATASOURCE"), (Throwable)dmse);
            return false;
        }
    }

    public void shutdown() {
        ICacheManager cacheManager = PentahoSystem.getCacheManager(null);
        List objectPools = null;
        objectPools = cacheManager.getAllValuesFromRegionCache("JDBC_POOL");
        Logger.debug((Object)this, (String)"PooledDatasourceSystemListener: called for shutdown");
        try {
            if (objectPools != null) {
                for (ObjectPool objectPool : objectPools) {
                    if (null == objectPool) continue;
                    objectPool.clear();
                }
            }
        }
        catch (Throwable ignored) {
            Logger.error((Object)this, (String)("Failed to clear connection pool: " + ignored.getMessage()), (Throwable)ignored);
        }
        cacheManager.removeRegionCache("JDBC_POOL");
        cacheManager.removeRegionCache("DataSource");
        Logger.debug((Object)this, (String)"PooledDatasourceSystemListener: completed shutdown");
    }
}

