/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.connection.datasource.dbcp;

import javax.sql.DataSource;
import org.pentaho.platform.api.data.DatasourceServiceException;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.repository.datasource.DatasourceMgmtServiceException;
import org.pentaho.platform.api.repository.datasource.IDatasource;
import org.pentaho.platform.api.repository.datasource.IDatasourceMgmtService;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.BaseDatasourceService;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.PooledDatasourceHelper;
import org.pentaho.platform.engine.services.messages.Messages;

public class PooledOrJndiDatasourceService
extends BaseDatasourceService {
    DataSource retrieve(String datasource) throws DatasourceServiceException {
        Object ds = null;
        try {
            IDatasourceMgmtService datasourceMgmtSvc = (IDatasourceMgmtService)PentahoSystem.getObjectFactory().get(IDatasourceMgmtService.class, null);
            IDatasource dataSource = datasourceMgmtSvc.getDatasource(datasource);
            ds = dataSource != null ? PooledDatasourceHelper.setupPooledDataSource(dataSource) : this.getJndiDataSource(datasource);
            if (ds != null) {
                this.cacheManager.putInRegionCache("DataSource", (Object)datasource, ds);
            }
        }
        catch (ObjectFactoryException objface) {
            try {
                return this.getJndiDataSource(datasource);
            }
            catch (DatasourceServiceException dse) {
                throw new DatasourceServiceException(Messages.getErrorString("PooledOrJndiDatasourceService.ERROR_0003_UNABLE_TO_GET_JNDI_DATASOURCE"), (Throwable)dse);
            }
        }
        catch (DatasourceMgmtServiceException daoe) {
            try {
                return this.getJndiDataSource(datasource);
            }
            catch (DatasourceServiceException dse) {
                throw new DatasourceServiceException(Messages.getErrorString("PooledOrJndiDatasourceService.ERROR_0003_UNABLE_TO_GET_JNDI_DATASOURCE"), (Throwable)dse);
            }
        }
        return ds;
    }

    public void clearCache() {
        this.cacheManager.removeRegionCache("DataSource");
    }

    public void clearDataSource(String dsName) {
        this.cacheManager.removeFromRegionCache("DataSource", (Object)dsName);
    }

    public DataSource getDataSource(String dsName) throws DatasourceServiceException {
        DataSource dataSource = null;
        if (this.cacheManager != null) {
            Object foundDs;
            if (!this.cacheManager.cacheEnabled("DataSource")) {
                this.cacheManager.addCacheRegion("DataSource");
            }
            dataSource = (foundDs = this.cacheManager.getFromRegionCache("DataSource", (Object)dsName)) != null ? (DataSource)foundDs : this.retrieve(dsName);
        }
        return dataSource;
    }
}

