/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.metadata;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.BasePublisher;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.messages.Messages;

public class MetadataPublisher
extends BasePublisher {
    private static final long serialVersionUID = 1843038346011563927L;
    private static final Log logger = LogFactory.getLog(MetadataPublisher.class);
    public static final int NO_ERROR = 0;
    public static final int UNABLE_TO_DELETE = (int)Math.pow(2.0, 0.0);
    public static final int UNABLE_TO_IMPORT = (int)Math.pow(2.0, 1.0);
    public static final int NO_META = (int)Math.pow(2.0, 2.0);
    public static String XMI_FILENAME = "metadata.xmi";
    private static int numberUpdated = 0;

    public Log getLogger() {
        return logger;
    }

    public String getName() {
        return Messages.getString("MetadataPublisher.USER_PUBLISHER_NAME");
    }

    public String getDescription() {
        return Messages.getString("MetadataPublisher.USER_PUBLISHER_DESCRIPTION");
    }

    public String publish(IPentahoSession session) {
        numberUpdated = 0;
        ArrayList<String> messages = new ArrayList<String>();
        try {
            IMetadataDomainRepository repo = (IMetadataDomainRepository)PentahoSystem.get(IMetadataDomainRepository.class, (IPentahoSession)session);
            repo.reloadDomains();
            numberUpdated = repo.getDomainIds().size();
            return Messages.getString("MetadataPublisher.USER_METADATA_RELOADED", Integer.toString(numberUpdated));
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("MetadataPublisher.ERROR_0001_USER_IMPORT_META_FAILED"), (Throwable)e);
            messages.add(Messages.getString("MetadataPublisher.ERROR_0001_USER_IMPORT_META_FAILED"));
            StringBuffer buffer = new StringBuffer();
            buffer.append("<small>");
            for (String str : messages) {
                buffer.append("<br/>" + str);
            }
            buffer.append("<br/><b>" + Messages.getString("MetadataPublisher.INFO_0001_CHECK_LOG") + "</b></small>");
            return buffer.toString();
        }
    }
}

