/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.metadata.cwm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pentaho.platform.api.engine.IUserDetailsRoleListService;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.acls.PentahoAclEntry;
import org.pentaho.pms.schema.security.SecurityACL;
import org.pentaho.pms.schema.security.SecurityService;

public class PlatformSecurityService
extends SecurityService {
    List users = null;
    List roles = null;
    List acls = null;

    public PlatformSecurityService() {
        IUserDetailsRoleListService service = PentahoSystem.getUserDetailsRoleListService();
        this.users = service.getAllUsers();
        this.roles = service.getAllRoles();
        this.acls = new ArrayList();
        Map validPermissionsNameMap = PentahoAclEntry.getValidPermissionsNameMap((String)"all");
        if (validPermissionsNameMap != null) {
            Set aclsKeySet = validPermissionsNameMap.keySet();
            Iterator aclsIterator = aclsKeySet.iterator();
            while (aclsIterator.hasNext()) {
                String aclName = aclsIterator.next().toString();
                int aclMask = null != validPermissionsNameMap.get(aclName) ? Integer.parseInt(validPermissionsNameMap.get(aclName).toString()) : 0;
                this.acls.add(new SecurityACL(aclName, aclMask));
            }
        }
    }

    protected void doUsers(StringBuffer buf) {
        IUserDetailsRoleListService service = PentahoSystem.getUserDetailsRoleListService();
        buf.append("<users>");
        if (service != null) {
            List users = service.getAllUsers();
            Iterator usersIterator = users.iterator();
            while (usersIterator.hasNext()) {
                String username = usersIterator.next().toString();
                if (null == username || username.length() <= 0) continue;
                buf.append("<user>" + username + "</user>");
            }
        }
        buf.append("</users>");
    }

    protected void doRoles(StringBuffer buf) {
        IUserDetailsRoleListService service = PentahoSystem.getUserDetailsRoleListService();
        buf.append("<roles>");
        if (service != null) {
            List roles = service.getAllRoles();
            Iterator rolesIterator = roles.iterator();
            while (rolesIterator.hasNext()) {
                String roleName = rolesIterator.next().toString();
                if (null == roleName || roleName.length() <= 0) continue;
                buf.append("<role>" + roleName + "</role>");
            }
        }
        buf.append("</roles>");
    }

    protected void doACLs(StringBuffer buf) {
        Map validPermissionsNameMap = PentahoAclEntry.getValidPermissionsNameMap((String)"all");
        buf.append("<acls>");
        if (validPermissionsNameMap != null) {
            Set aclsKeySet = validPermissionsNameMap.keySet();
            Iterator aclsIterator = aclsKeySet.iterator();
            while (aclsIterator.hasNext()) {
                String aclMask;
                String aclName = aclsIterator.next().toString();
                String string = aclMask = null != validPermissionsNameMap.get(aclName) ? validPermissionsNameMap.get(aclName).toString() : null;
                if (null == aclName || aclName.length() <= 0 || null == aclMask || aclMask.length() <= 0) continue;
                buf.append("<acl>");
                buf.append("<name>");
                buf.append(aclName);
                buf.append("</name>");
                buf.append("<mask>");
                buf.append(aclMask);
                buf.append("</mask>");
                buf.append("</acl>");
            }
        }
        buf.append("</acls>");
    }

    public List getAcls() {
        return this.acls;
    }

    public List getUsers() {
        return this.users;
    }

    public List getRoles() {
        return this.roles;
    }
}

