/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.metadata.cwm;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IAclHolder;
import org.pentaho.platform.api.engine.IPentahoInitializer;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.engine.services.metadata.cwm.CWMAclHolder;
import org.pentaho.platform.engine.services.metadata.cwm.PlatformCWMSchemaFactory;
import org.pentaho.pms.schema.BusinessModel;
import org.pentaho.pms.schema.concept.ConceptUtilityInterface;
import org.pentaho.pms.schema.security.RowLevelSecurity;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;

public class SecurityAwareCwmSchemaFactory
extends PlatformCWMSchemaFactory
implements IPentahoInitializer {
    private static final Log logger = LogFactory.getLog(SecurityAwareCwmSchemaFactory.class);
    IPentahoSession session;
    public static final int[] AccessTypeMap = new int[]{0, 1, 2, 3, 4, 4};

    public void init(IPentahoSession inSession) {
        this.session = inSession;
    }

    public void setSession(IPentahoSession value) {
        this.session = value;
    }

    public IPentahoSession getSession() {
        return this.session;
    }

    public boolean hasAccess(int accessType, ConceptUtilityInterface aclHolder) {
        if (aclHolder != null) {
            CWMAclHolder newHolder = new CWMAclHolder(aclHolder);
            int mappedActionOperation = AccessTypeMap[accessType];
            return SecurityHelper.hasAccess((IAclHolder)newHolder, (int)mappedActionOperation, (IPentahoSession)this.session);
        }
        if (accessType == 5) {
            return SecurityHelper.isPentahoAdministrator((IPentahoSession)this.session);
        }
        return true;
    }

    public String generateRowLevelSecurityConstraint(BusinessModel businessModel) {
        RowLevelSecurity rls = businessModel.getRowLevelSecurity();
        if (rls.getType() == RowLevelSecurity.Type.NONE) {
            return null;
        }
        Authentication auth = SecurityHelper.getAuthentication((IPentahoSession)this.getSession(), (boolean)true);
        if (auth == null) {
            logger.info((Object)Messages.getString("SecurityAwareCwmSchemaFactory.INFO_AUTH_NULL_CONTINUE"));
            return "FALSE()";
        }
        String username = auth.getName();
        ArrayList<String> roles = new ArrayList<String>();
        for (GrantedAuthority role : auth.getAuthorities()) {
            roles.add(role.getAuthority());
        }
        return rls.getMQLFormula(username, roles);
    }
}

