/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IActionSequence;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.IParameterManager;
import org.pentaho.platform.api.engine.ISolutionActionDefinition;
import org.pentaho.platform.engine.services.actionsequence.ActionParameter;
import org.pentaho.platform.engine.services.actionsequence.ActionParameterSource;
import org.pentaho.platform.engine.services.messages.Messages;

public class ParameterManager
implements IParameterManager {
    private static final String[] EMPTY_ARRAY = new String[0];
    private ListOrderedMap allParams = new ListOrderedMap();
    private ListOrderedMap allResources = new ListOrderedMap();
    private List<IActionParameter> waitingToDieParams = new ArrayList<IActionParameter>();
    private ListOrderedMap currentInputs = new ListOrderedMap();
    private ListOrderedMap currentOutputs;
    private ListOrderedMap currentResources = new ListOrderedMap();
    private String[] sequenceInputNames;
    private String[] sequenceResourceNames;
    private static final Log logger = LogFactory.getLog(ParameterManager.class);
    private Map sequenceOutputDefs;

    ParameterManager() {
        this.currentOutputs = new ListOrderedMap();
        this.sequenceOutputDefs = new ListOrderedMap();
        this.sequenceInputNames = EMPTY_ARRAY;
    }

    ParameterManager(IActionSequence actionSequence) {
        this();
        this.allParams.putAll(actionSequence.getInputDefinitions());
        this.sequenceInputNames = actionSequence.getInputDefinitions().keySet().toArray(EMPTY_ARRAY);
        this.allResources.putAll(actionSequence.getResourceDefinitions());
        this.sequenceResourceNames = actionSequence.getResourceDefinitions().keySet().toArray(EMPTY_ARRAY);
        this.sequenceOutputDefs.putAll(actionSequence.getOutputDefinitions());
    }

    public Map getAllParameters() {
        return this.allParams;
    }

    public IActionParameter getCurrentInput(String inputName) {
        return (IActionParameter)this.currentInputs.get((Object)inputName);
    }

    public IActionParameter getCurrentOutput(String outputName) {
        return (IActionParameter)this.currentOutputs.get((Object)outputName);
    }

    public IActionSequenceResource getCurrentResource(String resourceName) {
        return (IActionSequenceResource)this.currentResources.get((Object)resourceName);
    }

    public Set getCurrentInputNames() {
        return this.currentInputs.keySet();
    }

    public IActionParameter getLoopParameter(String inputName) {
        return (IActionParameter)this.allParams.get((Object)inputName);
    }

    public Set getCurrentOutputNames() {
        return this.currentOutputs.keySet();
    }

    public Set getCurrentResourceNames() {
        return this.currentResources.keySet();
    }

    protected boolean disposeParameter(ActionParameter param) {
        try {
            if (param != null) {
                param.dispose();
                return true;
            }
        }
        catch (Throwable th) {
            logger.error((Object)Messages.getErrorString("ParameterManager.ERROR_0001_DISPOSE_ERROR", param.getName()), th);
        }
        return false;
    }

    public void dispose() {
        this.dispose(null);
    }

    public void dispose(List exceptParameters) {
        if (this.allParams != null) {
            for (ActionParameter actionParameter : this.allParams.values()) {
                if (exceptParameters != null && exceptParameters.contains(actionParameter.getValue())) continue;
                this.disposeParameter(actionParameter);
            }
            for (ActionParameter actionParameter : this.waitingToDieParams) {
                if (exceptParameters != null && exceptParameters.contains(actionParameter.getValue())) continue;
                this.disposeParameter(actionParameter);
            }
        }
    }

    public void resetParameters() {
        this.dispose();
        this.currentInputs.clear();
        this.currentOutputs.clear();
        this.currentResources.clear();
        this.allParams = this.resetMap(this.sequenceInputNames, this.allParams);
        this.allResources = this.resetMap(this.sequenceResourceNames, this.allResources);
    }

    private ListOrderedMap resetMap(String[] names, ListOrderedMap oldMap) {
        ListOrderedMap newMap = new ListOrderedMap();
        for (String element : names) {
            newMap.put((Object)element, oldMap.get((Object)element));
        }
        return newMap;
    }

    public void setCurrentParameters(ISolutionActionDefinition actionDefinition) {
        Object value;
        this.currentInputs.clear();
        this.currentOutputs.clear();
        this.currentResources.clear();
        if (actionDefinition == null) {
            this.currentInputs = this.resetMap(this.sequenceInputNames, this.allParams);
            this.currentResources = this.resetMap(this.sequenceResourceNames, this.allParams);
            for (Map.Entry entry : this.sequenceOutputDefs.entrySet()) {
                String outputName = (String)entry.getKey();
                IActionParameter param = (IActionParameter)this.allParams.get((Object)outputName);
                if (!((IActionParameter)entry.getValue()).isOutputParameter()) continue;
                if (param == null) {
                    this.currentOutputs.put((Object)outputName, entry.getValue());
                    continue;
                }
                this.currentOutputs.put((Object)outputName, (Object)param);
            }
            return;
        }
        for (String key : actionDefinition.getActionInputDefinitions().keySet()) {
            value = this.allParams.get((Object)actionDefinition.getMappedInputName(key));
            if (value == null && !((ActionParameter)(value = actionDefinition.getActionInputDefinitions().get(key))).hasDefaultValue()) {
                value = null;
            }
            if (value == null) continue;
            this.currentInputs.put((Object)key, value);
        }
        Map outParams = actionDefinition.getActionOutputDefinitions();
        for (Object outKey : outParams.keySet()) {
            ActionParameter param = (ActionParameter)outParams.get(outKey);
            if (!param.isOutputParameter()) continue;
            this.currentOutputs.put(outKey, (Object)param);
        }
        if (!actionDefinition.hasActionResources()) {
            this.currentResources.putAll((Map)this.allResources);
        } else {
            for (String key : actionDefinition.getActionResourceDefinitionNames()) {
                String key2 = actionDefinition.getMappedResourceName(key);
                value = this.allResources.get((Object)key2);
                this.currentResources.put((Object)key, value);
            }
        }
    }

    public void addToAllInputs(String key, IActionParameter param) {
        IActionParameter old = (IActionParameter)this.allParams.put((Object)key, (Object)param);
        if (old != null && !this.allParams.containsValue((Object)old)) {
            this.waitingToDieParams.add(old);
        }
    }

    public void addToCurrentInputs(String key, IActionParameter param) {
        if (this.currentInputs.containsKey((Object)key)) {
            this.currentInputs.remove((Object)key);
        }
        this.currentInputs.put((Object)key, (Object)param);
    }

    public boolean addOutputParameters(ISolutionActionDefinition actionDefinition) {
        for (String key : actionDefinition.getActionOutputDefinitions().keySet()) {
            IActionParameter outputParam = (IActionParameter)this.currentOutputs.get((Object)key);
            IActionParameter param = (IActionParameter)this.allParams.get((Object)(key = actionDefinition.getMappedOutputName(key)));
            if (param != null) {
                if (param == outputParam) continue;
                param.dispose();
                param.setValue(outputParam.getValue());
                continue;
            }
            this.addToAllInputs(key, outputParam);
        }
        return true;
    }

    public Map getReturnParameters() {
        ListOrderedMap returnMap = new ListOrderedMap();
        for (Map.Entry entry : this.sequenceOutputDefs.entrySet()) {
            String outputName = (String)entry.getKey();
            IActionParameter outputParam = (IActionParameter)entry.getValue();
            if (!outputParam.isOutputParameter()) continue;
            IActionParameter inputParam = (IActionParameter)this.allParams.get((Object)outputName);
            if (inputParam == null) {
                returnMap.put((Object)outputParam.getName(), null);
                continue;
            }
            for (ActionParameterSource src : outputParam.getVariables()) {
                returnMap.put((Object)outputParam.getName(), (Object)new ReturnParameter(src.getSourceName(), src.getValue(), inputParam.getValue()));
            }
        }
        return returnMap;
    }

    public String getActualRequestParameterName(String fieldName) {
        IActionParameter actionParameter = this.getCurrentInput(fieldName);
        if (actionParameter != null) {
            List vars = actionParameter.getVariables();
            for (int i = 0; i < vars.size(); ++i) {
                ActionParameterSource source = (ActionParameterSource)vars.get(i);
                if (!source.getSourceName().equals("request")) continue;
                return source.getValue();
            }
        }
        return fieldName;
    }

    public IActionParameter getInput(String inputName) {
        return (IActionParameter)this.allParams.get((Object)inputName);
    }

    public class ReturnParameter {
        public String destinationName;
        public String destinationParameter;
        public Object value;

        public ReturnParameter(String destinationName, String destinationParameter, Object value) {
            this.destinationName = destinationName;
            this.destinationParameter = destinationParameter;
            this.value = value;
        }
    }
}

