/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.solution;

import java.io.OutputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.actionsequence.dom.IActionDefinition;
import org.pentaho.platform.api.engine.IActionSequence;
import org.pentaho.platform.api.engine.ICreateFeedbackParameterCallback;
import org.pentaho.platform.api.engine.IMessageFormatter;
import org.pentaho.platform.api.engine.IMimeTypeListener;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.engine.ISolutionEngine;
import org.pentaho.platform.api.engine.ISystemSettings;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.engine.services.solution.BaseContentGenerator;
import org.pentaho.platform.util.messages.LocaleHelper;

public class ActionSequenceContentGenerator
extends BaseContentGenerator {
    private static final long serialVersionUID = 458870144807597675L;

    public Log getLogger() {
        return LogFactory.getLog(ActionSequenceContentGenerator.class);
    }

    protected void setupListeners(ISolutionEngine solutionEngine) {
        ICreateFeedbackParameterCallback feedbackParameterCallback = (ICreateFeedbackParameterCallback)this.getCallback(ICreateFeedbackParameterCallback.class);
        if (feedbackParameterCallback != null) {
            solutionEngine.setCreateFeedbackParameterCallback(feedbackParameterCallback);
        }
    }

    protected ISolutionEngine getSolutionEngine() {
        return (ISolutionEngine)PentahoSystem.get(ISolutionEngine.class, (IPentahoSession)this.userSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createContent() throws Exception {
        ISolutionEngine solutionEngine = this.getSolutionEngine();
        if (solutionEngine == null) {
            String message = Messages.getErrorString("BaseRequestHandler.ERROR_0001_NO_SOLUTION_ENGINE");
            this.error(message);
            throw new ObjectFactoryException(message);
        }
        this.setupListeners(solutionEngine);
        IParameterProvider requestParams = (IParameterProvider)this.parameterProviders.get("request");
        IRuntimeContext runtime = null;
        try {
            ISystemSettings systemSettings = PentahoSystem.getSystemSettings();
            String processId = ((Object)((Object)this)).getClass().getName();
            boolean instanceEnds = "true".equalsIgnoreCase(requestParams.getStringParameter("instanceends", "true"));
            String parameterXsl = systemSettings.getSystemSetting("default-parameter-xsl", "DefaultParameterForm.xsl");
            boolean forcePrompt = "true".equalsIgnoreCase(requestParams.getStringParameter("prompt", "false"));
            boolean doSubscribe = "yes".equalsIgnoreCase(requestParams.getStringParameter("subscribepage", "no"));
            String solutionName = requestParams.getStringParameter("solution", null);
            String actionPath = requestParams.getStringParameter("path", null);
            String actionName = requestParams.getStringParameter("action2", null);
            this.createOutputFileName(solutionName, actionPath, actionName);
            if (actionName == null) {
                actionName = requestParams.getStringParameter("action", null);
            }
            int outputPreference = 3;
            if (doSubscribe) {
                forcePrompt = true;
                this.parameterProviders.put("PRO_EDIT_SUBSCRIPTION", requestParams);
                outputPreference = 1;
            }
            this.outputHandler.setOutputPreference(outputPreference);
            solutionEngine.setLoggingLevel(2);
            solutionEngine.init(this.userSession);
            solutionEngine.setForcePrompt(forcePrompt);
            if (parameterXsl != null) {
                solutionEngine.setParameterXsl(parameterXsl);
            }
            runtime = solutionEngine.execute(solutionName, actionPath, actionName, processId, false, instanceEnds, this.instanceId, false, this.parameterProviders, this.outputHandler, null, this.urlFactory, this.messages);
            boolean doMessages = "true".equalsIgnoreCase(requestParams.getStringParameter("debug", "false"));
            boolean doWrapper = "true".equalsIgnoreCase(requestParams.getStringParameter("wrapper", "true"));
            this.postExecute(runtime, doMessages, doWrapper);
        }
        finally {
            if (runtime != null) {
                runtime.dispose();
            }
        }
    }

    protected void createOutputFileName(String solutionName, String actionPath, String actionName) {
        IMimeTypeListener mimeTypeListener;
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.userSession);
        IActionSequence actionSequence = repository.getActionSequence(solutionName, actionPath, actionName, PentahoSystem.loggingLevel, 1);
        String fileName = "content";
        if (actionSequence != null) {
            String title = actionSequence.getTitle();
            if (title != null && title.length() > 0) {
                fileName = title;
            } else {
                String sequenceName = actionSequence.getSequenceName();
                if (sequenceName != null && sequenceName.length() > 0) {
                    fileName = sequenceName;
                } else {
                    List actionDefinitionsList = actionSequence.getActionDefinitionsAndSequences();
                    int i = 0;
                    boolean done = false;
                    while (actionDefinitionsList.size() > i && !done) {
                        IActionDefinition actionDefinition = (IActionDefinition)actionDefinitionsList.get(i);
                        String componentName = actionDefinition.getComponentName();
                        if (componentName != null && componentName.length() > 0) {
                            fileName = componentName;
                            done = true;
                            continue;
                        }
                        ++i;
                    }
                }
            }
        }
        if ((mimeTypeListener = this.outputHandler.getMimeTypeListener()) != null) {
            mimeTypeListener.setName(fileName);
        }
    }

    protected void setup(ISolutionEngine solutionEngine) {
        IParameterProvider requestParams = (IParameterProvider)this.parameterProviders.get("request");
        ISystemSettings systemSettings = PentahoSystem.getSystemSettings();
        String parameterXsl = systemSettings.getSystemSetting("default-parameter-xsl", "DefaultParameterForm.xsl");
        boolean forcePrompt = "true".equalsIgnoreCase(requestParams.getStringParameter("prompt", "false"));
        boolean doSubscribe = "yes".equalsIgnoreCase(requestParams.getStringParameter("subscribepage", "no"));
        String solutionName = requestParams.getStringParameter("solution", null);
        String actionPath = requestParams.getStringParameter("path", null);
        String actionName = requestParams.getStringParameter("action2", null);
        this.createOutputFileName(solutionName, actionPath, actionName);
        if (actionName == null) {
            actionName = requestParams.getStringParameter("action", null);
        }
        int outputPreference = 3;
        if (doSubscribe) {
            forcePrompt = true;
            this.parameterProviders.put("PRO_EDIT_SUBSCRIPTION", requestParams);
            outputPreference = 1;
        }
        this.outputHandler.setOutputPreference(outputPreference);
        solutionEngine.setLoggingLevel(2);
        solutionEngine.init(this.userSession);
        solutionEngine.setForcePrompt(forcePrompt);
        if (parameterXsl != null) {
            solutionEngine.setParameterXsl(parameterXsl);
        }
    }

    protected void postExecute(IRuntimeContext runtime, boolean doMessages, boolean doWrapper) throws Exception {
        if (!this.outputHandler.contentDone() || doMessages) {
            IParameterProvider requestParams = (IParameterProvider)this.parameterProviders.get("request");
            String solutionName = requestParams.getStringParameter("solution", null);
            String actionName = requestParams.getStringParameter("action", null);
            IContentItem contentItem = this.outputHandler.getOutputContentItem("response", "content", solutionName, null, "text/html");
            OutputStream outputStream = contentItem.getOutputStream(actionName);
            if (outputStream != null) {
                StringBuffer buffer = new StringBuffer();
                if (runtime != null && runtime.getStatus() == 6) {
                    ((IMessageFormatter)PentahoSystem.get(IMessageFormatter.class, (IPentahoSession)this.userSession)).formatSuccessMessage("text/html", runtime, buffer, doMessages, doWrapper);
                } else {
                    ((IMessageFormatter)PentahoSystem.get(IMessageFormatter.class, (IPentahoSession)this.userSession)).formatFailureMessage("text/html", runtime, buffer, this.messages);
                }
                outputStream.write(buffer.toString().getBytes(LocaleHelper.getSystemEncoding()));
                contentItem.closeOutputStream();
            }
        }
    }
}

