/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.solution;

import java.io.File;
import java.io.InputStream;
import org.dom4j.Document;
import org.pentaho.platform.api.engine.IActionSequence;
import org.pentaho.platform.api.engine.IFileInfo;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.engine.SolutionFileMetaAdapter;
import org.pentaho.platform.engine.core.solution.FileInfo;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.actionsequence.SequenceDefinition;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;

public class ActionSequenceFileInfo
extends SolutionFileMetaAdapter {
    private ILogger logger;

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public IFileInfo getFileInfo(ISolutionFile solutionFile, InputStream in) {
        try {
            String solution;
            String path;
            Document actionSequenceDocument = XmlDom4JHelper.getDocFromStream((InputStream)in);
            if (actionSequenceDocument == null) {
                return null;
            }
            String filename = solutionFile.getFileName();
            IActionSequence actionSequence = SequenceDefinition.ActionSequenceFactory(actionSequenceDocument, filename, path = solutionFile.getSolutionPath(), solution = solutionFile.getSolution(), this.logger, PentahoSystem.getApplicationContext(), Logger.getLogLevel());
            if (actionSequence == null) {
                Logger.error((String)((Object)((Object)this)).getClass().toString(), (String)Messages.getErrorString("SolutionRepository.ERROR_0016_FAILED_TO_CREATE_ACTION_SEQUENCE", solution + File.separator + path + File.separator + filename));
                return null;
            }
            FileInfo info = new FileInfo();
            info.setAuthor(actionSequence.getAuthor());
            info.setDescription(actionSequence.getDescription());
            info.setDisplayType(actionSequence.getResultType());
            info.setIcon(actionSequence.getIcon());
            info.setTitle(actionSequence.getTitle());
            return info;
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.error(((Object)((Object)this)).getClass().toString(), (Throwable)e);
            }
            return null;
        }
    }
}

