/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.solution;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.system.BasePublisher;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.messages.Messages;

public class SolutionPublisher
extends BasePublisher {
    private static final long serialVersionUID = -209000084524120620L;
    private static final Log logger = LogFactory.getLog(SolutionPublisher.class);

    public Log getLogger() {
        return logger;
    }

    public String publish(IPentahoSession session) {
        try {
            ((ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)session)).reloadSolutionRepository(session, this.getLoggingLevel());
        }
        catch (Throwable t) {
            this.error(Messages.getErrorString("SolutionPublisher.ERROR_0001_PUBLISH_FAILED"), t);
            return Messages.getString("SolutionPublisher.USER_ERROR_PUBLISH_FAILED") + t.getLocalizedMessage();
        }
        return Messages.getString("SolutionPublisher.USER_SOLUTION_REPOSITORY_UPDATED");
    }

    public String getName() {
        return Messages.getString("SolutionRepository.USER_PUBLISH_TITLE");
    }

    public String getDescription() {
        return Messages.getString("SolutionRepository.USER_PUBLISH_DESCRIPTION");
    }
}

