/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.solution;

import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.pentaho.platform.api.engine.ISolutionAttributeContributor;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.engine.ISolutionFilter;
import org.pentaho.platform.api.repository.ISolutionRepository;

public class SolutionReposHelper {
    public static final String TREE_NODE_NAME = "tree";
    public static final String ENTRY_NODE_NAME = "entry";
    public static final String TYPE_ATTR_NAME = "type";
    public static final String NAME_ATTR_NAME = "name";
    public static final String DIRECTORY_ATTR = "directory";
    public static final String FILE_ATTR = "file";
    public static final String BRANCH_NODE_NAME = "branch";
    public static final String BRANCH_TEXT_NODE_NAME = "branchText";
    public static final String ID_ATTR_NAME = "id";
    public static final String IS_DIR_ATTR_NAME = "isDir";
    public static final String LEAF_NODE_NAME = "leaf";
    public static final String LEAF_TEXT_NODE_NAME = "leafText";
    public static final String LINK_NODE_NAME = "link";
    public static final String PATH_TEXT_NODE_NAME = "path";
    public static final ISolutionFilter KEEP_ALL_FILTER = new ISolutionFilter(){

        public boolean keepFile(ISolutionFile solutionFile, int actionOperation) {
            return solutionFile != null;
        }
    };
    public static final ISolutionFilter DEFAULT_FILTER = new ISolutionFilter(){

        public boolean keepFile(ISolutionFile solutionFile, int actionOperation) {
            return solutionFile != null && !SolutionReposHelper.ignoreFile(solutionFile);
        }
    };
    public static final ISolutionAttributeContributor ADD_NOTHING_CONTRIBUTOR = new ISolutionAttributeContributor(){

        public void contributeAttributes(ISolutionFile solutionFile, Element childNode) {
        }
    };
    static List ignoreDirectories = new ArrayList();
    static List ignoreFiles = new ArrayList();
    private static final ThreadLocal threadSolutionRepositories;

    private SolutionReposHelper() {
    }

    public static boolean ignoreFile(ISolutionFile solutionFile) {
        if (solutionFile.isDirectory()) {
            return ignoreDirectories.contains(solutionFile.getFileName().toLowerCase());
        }
        return ignoreFiles.contains(solutionFile.getFileName().toLowerCase());
    }

    public static boolean ignoreFile(String fileName) {
        return ignoreFiles.contains(fileName.toLowerCase());
    }

    public static boolean ignoreDirectory(String dirName) {
        return ignoreDirectories.contains(dirName.toLowerCase());
    }

    public static boolean isActionSequence(ISolutionFile solutionFile) {
        String fileName = solutionFile.getFileName();
        return fileName != null ? fileName.toLowerCase().endsWith(".xaction") : false;
    }

    public static Document getActionSequences(ISolutionFile targetFile, int actionOperation) {
        return SolutionReposHelper.getActionSequences(targetFile, ADD_NOTHING_CONTRIBUTOR, actionOperation);
    }

    public static Document getActionSequences(ISolutionFile targetFile, ISolutionAttributeContributor contributor, final int actionOperation) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(TREE_NODE_NAME);
        SolutionReposHelper.processSolutionTree(root, targetFile, new ISolutionFilter(){

            public boolean keepFile(ISolutionFile solutionFile, int actOperation) {
                return (solutionFile.isDirectory() || SolutionReposHelper.isActionSequence(solutionFile)) && DEFAULT_FILTER.keepFile(solutionFile, actionOperation);
            }
        }, contributor, actionOperation);
        return document;
    }

    public static Document processSolutionTree(ISolutionFile targetFile, int actionOperation) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(TREE_NODE_NAME);
        SolutionReposHelper.processSolutionTree(root, targetFile, null, actionOperation);
        return document;
    }

    public static void processSolutionTree(Element parentNode, ISolutionFile targetFile, int actionOperation) {
        SolutionReposHelper.processSolutionTree(parentNode, targetFile, null, actionOperation);
    }

    public static void processSolutionStructure(Element parentNode, ISolutionFile targetFile, int actionOperation) {
        SolutionReposHelper.processSolutionStructure(parentNode, targetFile, null, actionOperation);
    }

    public static void processSolutionTree(Element parentNode, ISolutionFile targetFile, ISolutionFilter solutionFilter, int actionOperation) {
        SolutionReposHelper.processSolutionTree(parentNode, targetFile, solutionFilter, ADD_NOTHING_CONTRIBUTOR, actionOperation);
    }

    public static void processSolutionTree(Element parentNode, ISolutionFile targetFile, ISolutionFilter solutionFilter, ISolutionAttributeContributor contributor, int actionOperation) {
        ISolutionFilter sFilter;
        ISolutionFilter iSolutionFilter = sFilter = solutionFilter == null ? DEFAULT_FILTER : solutionFilter;
        if (targetFile != null && sFilter.keepFile(targetFile, actionOperation)) {
            if (targetFile.isDirectory()) {
                ISolutionFile[] files;
                Element childNode = parentNode.addElement(BRANCH_NODE_NAME).addAttribute(ID_ATTR_NAME, targetFile.getFullPath()).addAttribute(IS_DIR_ATTR_NAME, "true");
                contributor.contributeAttributes(targetFile, childNode);
                if (targetFile.isRoot()) {
                    childNode.addElement(BRANCH_TEXT_NODE_NAME).setText("/");
                } else {
                    childNode.addElement(BRANCH_TEXT_NODE_NAME).setText(targetFile.getFileName());
                }
                for (ISolutionFile file : files = targetFile.listFiles()) {
                    SolutionReposHelper.processSolutionTree(childNode, file, sFilter, contributor, actionOperation);
                }
            } else {
                Element childNode = parentNode.addElement(LEAF_NODE_NAME).addAttribute(IS_DIR_ATTR_NAME, "false");
                contributor.contributeAttributes(targetFile, childNode);
                childNode.addElement(LEAF_TEXT_NODE_NAME).setText(targetFile.getFileName());
                childNode.addElement(PATH_TEXT_NODE_NAME).setText(targetFile.getFullPath());
                childNode.addElement(LINK_NODE_NAME).setText("#");
            }
        }
    }

    public static void setSolutionRepositoryThreadVariable(ISolutionRepository repository) {
        threadSolutionRepositories.set(repository);
    }

    public static ISolutionRepository getSolutionRepositoryThreadVariable() {
        return (ISolutionRepository)threadSolutionRepositories.get();
    }

    public static void processSolutionStructure(Element parentNode, ISolutionFile targetFile, ISolutionFilter solutionFilter, int actionOperation) {
        SolutionReposHelper.processSolutionStructure(parentNode, targetFile, solutionFilter, ADD_NOTHING_CONTRIBUTOR, actionOperation);
    }

    public static void processSolutionStructure(Element parentNode, ISolutionFile targetFile, ISolutionFilter solutionFilter, ISolutionAttributeContributor contributor, int actionOperation) {
        ISolutionFilter sFilter;
        ISolutionFilter iSolutionFilter = sFilter = solutionFilter == null ? DEFAULT_FILTER : solutionFilter;
        if (targetFile.isDirectory()) {
            if (!ignoreDirectories.contains(targetFile.getFileName()) && sFilter.keepFile(targetFile, actionOperation)) {
                ISolutionFile[] files;
                Element childNode = parentNode.addElement(ENTRY_NODE_NAME).addAttribute(TYPE_ATTR_NAME, DIRECTORY_ATTR).addAttribute(NAME_ATTR_NAME, targetFile.getFileName());
                contributor.contributeAttributes(targetFile, childNode);
                for (ISolutionFile file : files = targetFile.listFiles()) {
                    SolutionReposHelper.processSolutionStructure(childNode, file, actionOperation);
                }
            }
        } else if (!ignoreFiles.contains(targetFile.getFileName()) && sFilter.keepFile(targetFile, actionOperation)) {
            Element childNode = parentNode.addElement(ENTRY_NODE_NAME).addAttribute(TYPE_ATTR_NAME, FILE_ATTR).addAttribute(NAME_ATTR_NAME, targetFile.getFileName());
            contributor.contributeAttributes(targetFile, childNode);
        }
    }

    static {
        ignoreDirectories.add("cvs");
        ignoreDirectories.add("system");
        ignoreDirectories.add(".svn");
        ignoreFiles.add(".cvsignore");
        threadSolutionRepositories = new ThreadLocal();
    }
}

