/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.geo.model;

import com.pentaho.geo.model.PlaceElement;
import com.pentaho.geo.model.Point;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Place
implements Serializable {
    private static final long serialVersionUID = 696557149062696618L;
    private Point point;
    private String type;
    private PlaceElement[] elements;

    public Point getPoint() {
        return this.point;
    }

    public void setPoint(Point point) {
        this.point = point;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public PlaceElement[] getElements() {
        return this.elements;
    }

    public void setElements(PlaceElement[] elements) {
        this.elements = elements;
    }

    public static Place copyAndAlias(Place p, String type, String alias) {
        PlaceElement placeElement = new PlaceElement();
        placeElement.setType(type);
        placeElement.setValue(alias);
        return Place.copyAndAlias(p, Arrays.asList(placeElement));
    }

    public static Place copyAndAlias(Place p, Collection<PlaceElement> aliasedPlaceElements) {
        Place place = new Place();
        place.setType(p.getType());
        place.setPoint(p.getPoint());
        PlaceElement[] placeElementArray = new PlaceElement[p.getElements().length];
        block0: for (int i = 0; i < p.getElements().length; ++i) {
            placeElementArray[i] = new PlaceElement();
            placeElementArray[i].setType(p.getElements()[i].getType());
            placeElementArray[i].setValue(p.getElements()[i].getValue());
            for (PlaceElement placeElement : aliasedPlaceElements) {
                if (!placeElementArray[i].getType().equals(placeElement.getType())) continue;
                placeElementArray[i].setValue(placeElement.getValue());
                continue block0;
            }
        }
        place.setElements(placeElementArray);
        return place;
    }

    public String toString() {
        return String.format("Place{Type: %s, Point:%s, Elements: (%s)}", this.type, this.point != null ? this.point.toString() : "null", this.elementsToString());
    }

    private String elementsToString() {
        if (this.elements != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            for (int i = 0; i < this.elements.length; ++i) {
                stringBuffer.append("[").append(this.elements[i].toString()).append("],");
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
        return "null";
    }
}

