/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.geo.service;

import com.pentaho.geo.messages.Messages;
import com.pentaho.geo.model.Place;
import com.pentaho.geo.model.PlaceElement;
import com.pentaho.geo.model.Point;
import com.pentaho.geo.service.IGeoImporter;
import com.pentaho.geo.service.___;
import com.pentaho.geo.service.____;
import com.pentaho.geo.storage.IGeoStorage;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.fixedinput.FixedInputMeta;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputMeta;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class CsvReader
extends PentahoBase
implements IGeoImporter,
RowListener {
    private static final long serialVersionUID = 4973180809726312336L;
    public static final String y = "custom";
    public static final String ___ = "pentaho-geo/settings.xml";
    public static final String z = "type";
    public static final String A = "name";
    private static final String B = "system/pentaho-geo/dataimport/";
    private static final Log C = LogFactory.getLog(CsvReader.class);
    private int D;
    private int E;
    private boolean firstRow;
    private String F;
    private String[] G;
    private Integer[] H;
    private String[] I;
    private String[] J;
    private IGeoStorage K = com.pentaho.geo.service.___.getGeoStorage();
    private int L = -1;
    private int M = -1;
    private int N = -1;
    private String O = null;
    private int P;

    public int doImport(String[] features) {
        try {
            KettleEnvironment.init();
        }
        catch (KettleException kettleException) {
            this.error(Messages.getErrorString("CsvReader.ERROR_0001_BAD_PDI_INIT"), kettleException);
            return -1;
        }
        String string = PentahoSystem.getApplicationContext().getSolutionPath(B);
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            this.error(Messages.getErrorString("CsvReader.ERROR_0002_BAD_TRANS_DIR", string));
            return -1;
        }
        File[] fileArray = file.listFiles();
        this.P = 0;
        for (int i = 0; i < fileArray.length; ++i) {
            int n;
            if (!fileArray[i].isFile() || !fileArray[i].getAbsolutePath().toLowerCase().endsWith(".ktr") || (n = fileArray[i].getName().lastIndexOf("_")) == -1) continue;
            String string2 = fileArray[i].getName().substring(n + 1).toLowerCase();
            String string3 = string2.substring(0, string2.length() - 4);
            if ((string3 = ____.____(string3)) == null) continue;
            boolean bl = true;
            if (features != null && features.length > 0) {
                bl = false;
                for (int j = 0; j < features.length; ++j) {
                    if (!features[j].equalsIgnoreCase(string3)) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) continue;
            this.runTransform(fileArray[i].getAbsolutePath(), string3);
        }
        return this.P;
    }

    protected Result runTransform(String fileName, String type) {
        String string = new com.pentaho.geo.a.____(new long[]{702855845732441460L, -6321565744729121782L, -7582795149768102075L, 6031550919793048625L, 1561716089282401684L}).toString();
        int n = com.pentaho.geo.a.___._____(string);
        if ((type = ____.____(type)) == null) {
            return null;
        }
        this.L = -1;
        this.M = -1;
        this.N = -1;
        this.O = null;
        this.info(Messages.getString("CsvReader.INFO_RUNING_TRANS", fileName));
        this.F = type;
        Trans trans = null;
        TransMeta transMeta = new TransMeta();
        Result result = null;
        if (n < 1) {
            return null;
        }
        try {
            transMeta = new TransMeta(fileName);
            trans = new Trans(transMeta);
            if (C.isDebugEnabled()) {
                trans.setLogLevel(LogLevel.DETAILED);
            } else {
                trans.setLogLevel(LogLevel.ERROR);
            }
        }
        catch (Exception exception) {
            if (trans != null) {
                result = trans.getResult();
            }
            trans = null;
            transMeta = null;
            String string2 = Messages.getErrorString("CsvReader.ERROR_0003_TRANS_ERROR", fileName);
            this.error(string2, exception);
            return result;
        }
        if (trans == null) {
            String string3 = Messages.getErrorString("CsvReader.ERROR_0004_TRANS_LOADING", fileName);
            this.error(string3);
            return result;
        }
        try {
            trans.initializeVariablesFrom(null);
            trans.getTransMeta().setInternalKettleVariables((VariableSpace)trans);
            trans.setSafeModeEnabled(true);
            ArrayList arrayList = new ArrayList();
            trans.getTransMeta().checkSteps(arrayList, false, null);
            for (Object object2 : arrayList) {
                if (object2.getType() != 4) continue;
                this.error(Messages.getErrorString("CsvReader.ERROR_0005_TRANS_CHECK", fileName, object2.getErrorCode()));
            }
            try {
                String[] stringArray;
                TextFileInputMeta textFileInputMeta;
                Object object;
                Object object2;
                List list = transMeta.getSteps();
                object2 = PentahoSystem.getApplicationContext().getSolutionPath("system/pentaho-geo/");
                StepInterface stepInterface = list.iterator();
                while (stepInterface.hasNext()) {
                    object = (StepMeta)stepInterface.next();
                    if (object.getStepMetaInterface() instanceof TextFileInputMeta) {
                        textFileInputMeta = (TextFileInputMeta)object.getStepMetaInterface();
                        stringArray = textFileInputMeta.getFileName();
                        this.fixupPaths(stringArray, (String)object2);
                        textFileInputMeta.setFileName(stringArray);
                    }
                    if (!(object.getStepMetaInterface() instanceof FixedInputMeta)) continue;
                    textFileInputMeta = (FixedInputMeta)object.getStepMetaInterface();
                    stringArray = new String[]{textFileInputMeta.getFilename()};
                    this.fixupPaths(stringArray, (String)object2);
                    textFileInputMeta.setFilename(stringArray[0]);
                }
                trans.prepareExecution(null);
                stepInterface = null;
                object = trans.getSteps();
                textFileInputMeta = object.iterator();
                while (textFileInputMeta.hasNext()) {
                    stringArray = (String[])textFileInputMeta.next();
                    if (!stringArray.step.getStepname().equalsIgnoreCase("output")) continue;
                    stepInterface = stringArray.step;
                }
                if (stepInterface == null) {
                    this.error(Messages.getErrorString("CsvReader.ERROR_0006_NO_OUTPUT_STEP", fileName));
                    return null;
                }
                stepInterface.addRowListener((RowListener)this);
                this.D = 0;
                this.firstRow = true;
                trans.startThreads();
            }
            catch (Exception exception) {
                this.error(Messages.getErrorString("CsvReader.ERROR_0007_TRANS_PREPARE", fileName), exception);
                return null;
            }
            trans.waitUntilFinished();
            this.info(Messages.getString("CsvReader.INFO_TRANS_RESULT", Integer.toString(this.E), fileName));
            result = trans.getResult();
            trans.cleanup();
            result.setResult(result.getNrErrors() == 0L);
            ++this.P;
            return result;
        }
        catch (Exception exception) {
            this.error(Messages.getErrorString("CsvReader.ERROR_0008_UNEXPECTED_ERROR", fileName), exception);
            result.setResult(false);
            result.setNrErrors(1L);
            return result;
        }
    }

    protected void fixupPaths(String[] fileNames, String base) {
        for (int i = 0; i < fileNames.length; ++i) {
            int n = fileNames[i].indexOf("system/pentaho-geo/");
            if (n == -1) continue;
            fileNames[i] = base + fileNames[i].substring(n + 19);
        }
    }

    public void errorRowWrittenEvent(RowMetaInterface rowMeta, Object[] arg1) throws KettleStepException {
        ++this.D;
    }

    public void rowReadEvent(RowMetaInterface rowMeta, Object[] arg1) throws KettleStepException {
    }

    public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
        Serializable serializable;
        Object object;
        ++this.E;
        Place place = new Place();
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        place.setType(this.F);
        Double d = null;
        Double d2 = null;
        if (this.firstRow) {
            this.firstRow = false;
            this.I = rowMeta.getFieldNames();
            this.J = new String[this.I.length];
            for (int i = 0; i < this.I.length; ++i) {
                this.J[i] = ____.____(this.I[i]);
            }
            object = new ArrayList();
            serializable = new ArrayList();
            if (this.F.equals("Country")) {
                for (int i = 0; i < this.I.length; ++i) {
                    if ("Country".equals(this.J[i])) {
                        object.add("Country");
                        serializable.add(i);
                        continue;
                    }
                    if ("CountryCode".equals(this.J[i])) {
                        object.add("CountryCode");
                        serializable.add(i);
                        continue;
                    }
                    if (!"CountryCode3".equals(this.J[i])) continue;
                    object.add("CountryCode3");
                    serializable.add(i);
                }
            } else if (this.F.equals("CountrySubdivision")) {
                for (int i = 0; i < this.I.length; ++i) {
                    if ("CountrySubdivision".equals(this.J[i])) {
                        object.add("CountrySubdivision");
                        serializable.add(i);
                        continue;
                    }
                    if ("CountrySubdivisionCode".equals(this.J[i])) {
                        object.add("CountrySubdivisionCode");
                        serializable.add(i);
                        continue;
                    }
                    if (!"StateCode".equals(this.J[i])) continue;
                    object.add("StateCode");
                    serializable.add(i);
                }
            } else if (this.F.equals("PostalCode") || this.F.equals("CountrySecondarySubdivision") || this.F.equals("Municipality")) {
                for (int i = 0; i < this.I.length; ++i) {
                    if (!this.F.equals(this.J[i])) continue;
                    object.add(this.F);
                    serializable.add(i);
                }
            } else if (this.F.equalsIgnoreCase("Custom")) {
                this.L = -1;
                for (int i = 0; i < this.I.length; ++i) {
                    if (!z.equalsIgnoreCase(this.I[i])) continue;
                    this.L = i;
                    break;
                }
                if (this.L != -1) {
                    String string = row[this.L].toString();
                    for (int i = 0; i < this.I.length; ++i) {
                        if (!A.equalsIgnoreCase(this.I[i])) continue;
                        this.N = object.size();
                        object.add(string);
                        this.M = i;
                        serializable.add(i);
                        this.J[this.M] = string;
                        break;
                    }
                }
            }
            this.G = object.toArray(new String[object.size()]);
            this.H = serializable.toArray(new Integer[serializable.size()]);
        }
        if (this.L != -1) {
            object = row[this.L].toString();
            if (object != null && !((String)object).equalsIgnoreCase(this.O)) {
                this.K.defineCustomType((String)object);
                this.O = object;
                this.J[this.M] = object;
                this.G[this.N] = object;
            }
            place.setType((String)object);
        }
        for (int i = 0; i < this.I.length; ++i) {
            if (row[i] == null) continue;
            if ("Latitude".equals(this.J[i])) {
                d = new Double(row[i].toString());
                continue;
            }
            if ("Longitude".equals(this.J[i])) {
                d2 = new Double(row[i].toString());
                continue;
            }
            if (____.____(this.J[i]) != null) {
                serializable = new PlaceElement();
                ((PlaceElement)serializable).setType(this.J[i]);
                ((PlaceElement)serializable).setValue(row[i].toString());
                arrayList.add(serializable);
                continue;
            }
            if (this.O == null || !this.O.equalsIgnoreCase(this.J[i])) continue;
            serializable = new PlaceElement();
            ((PlaceElement)serializable).setType(this.J[i]);
            ((PlaceElement)serializable).setValue(row[i].toString());
            arrayList.add(serializable);
        }
        place.setElements(arrayList.toArray(new PlaceElement[arrayList.size()]));
        Point point = new Point();
        point.setLat(d);
        point.setLong(d2);
        place.setPoint(point);
        for (int i = 0; i < this.G.length; ++i) {
            this.K.addFeature((String)row[this.H[i]], this.G[i], place);
        }
    }

    public Log getLogger() {
        return C;
    }
}

