/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.geo.service;

import com.pentaho.geo.model.Address;
import com.pentaho.geo.model.GeoJsonFeature;
import com.pentaho.geo.model.GeoJsonFeatureCollection;
import com.pentaho.geo.model.GeoJsonPointGeometry;
import com.pentaho.geo.model.GeocodeRequest;
import com.pentaho.geo.model.GeocodeResponse;
import com.pentaho.geo.model.GeocodeResponseList;
import com.pentaho.geo.model.Place;
import com.pentaho.geo.model.PlaceElement;
import com.pentaho.geo.model.Point;
import com.pentaho.geo.service.IGeoService;
import com.pentaho.geo.service.___;
import com.pentaho.geo.service.____;
import com.pentaho.geo.storage.IGeoStorage;
import flexjson.JSONDeserializer;
import flexjson.JSONSerializer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class DefaultGeoService
implements IGeoService,
Serializable {
    private static final long serialVersionUID = 768155851092627310L;
    private IGeoStorage Q = ___.getGeoStorage();

    protected IGeoStorage getGeoStorage() {
        return this.Q;
    }

    public GeocodeResponse geocode(GeocodeRequest request) {
        String string = new com.pentaho.geo.a.____(new long[]{702855845732441460L, -6321565744729121782L, -7582795149768102075L, 6031550919793048625L, 1561716089282401684L}).toString();
        int n = com.pentaho.geo.a.___._____(string);
        String string2 = request.getAddress()[0].getType();
        String string3 = ____.x.get(string2.toLowerCase());
        if (string3 == null) {
            if (!this.Q.isCustomType(string2)) {
                return new GeocodeResponse();
            }
            string3 = string2;
        }
        if (n < 1) {
            return new GeocodeResponse();
        }
        GeocodeResponse geocodeResponse = this.doQuery(request.getAddress(), string3);
        return geocodeResponse;
    }

    public String geocodeResponseToJson(GeocodeResponse response) {
        JSONSerializer jSONSerializer = new JSONSerializer();
        String string = jSONSerializer.deepSerialize((Object)response);
        return string;
    }

    public String geocodeResponseToGeoJson(GeocodeResponse response) {
        Object object;
        GeoJsonFeatureCollection geoJsonFeatureCollection = new GeoJsonFeatureCollection();
        GeocodeResponseList[] geocodeResponseListArray = response.getGeocodeResponseList();
        ArrayList<GeoJsonFeature> arrayList = new ArrayList<GeoJsonFeature>();
        if (geocodeResponseListArray != null) {
            for (int i = 0; i < geocodeResponseListArray.length; ++i) {
                object = geocodeResponseListArray[i].getGeocodedAddresses();
                if (object == null) continue;
                for (int j = 0; j < ((Place[])object).length; ++j) {
                    Serializable serializable;
                    Place place = object[j];
                    GeoJsonFeature geoJsonFeature = new GeoJsonFeature();
                    PlaceElement[] placeElementArray = place.getElements();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (int k = 0; k < placeElementArray.length; ++k) {
                        serializable = placeElementArray[k];
                        String string = ((PlaceElement)serializable).getType();
                        String string2 = ((PlaceElement)serializable).getValue();
                        if (string.equalsIgnoreCase("Country")) {
                            hashMap.put("Country", string2);
                            continue;
                        }
                        if (string.equalsIgnoreCase("CountryCode")) {
                            hashMap.put("CountryCode", string2);
                            continue;
                        }
                        if (string.equalsIgnoreCase("CountryCode3")) {
                            hashMap.put("CountryCode3", string2);
                            continue;
                        }
                        if (string.equalsIgnoreCase("CountrySubdivision")) {
                            hashMap.put("CountrySubdivision", string2);
                            continue;
                        }
                        if (string.equalsIgnoreCase("CountrySubdivisionCode")) {
                            hashMap.put("CountrySubdivisionCode", string2);
                            continue;
                        }
                        if (string.equalsIgnoreCase("CountrySecondarySubdivision")) {
                            hashMap.put("CountrySecondarySubdivision", string2);
                            continue;
                        }
                        if (string.equalsIgnoreCase("Municipality")) {
                            hashMap.put("Municipality", string2);
                            continue;
                        }
                        if (string.equalsIgnoreCase("MunicipalitySubdivision")) {
                            hashMap.put("MunicipalitySubdivision", string2);
                            continue;
                        }
                        if (string.equalsIgnoreCase("PostalCode")) {
                            hashMap.put("PostalCode", string2);
                            continue;
                        }
                        hashMap.put(string, string2);
                    }
                    geoJsonFeature.setProperties(hashMap);
                    Point point = place.getPoint();
                    serializable = new GeoJsonPointGeometry();
                    ((GeoJsonPointGeometry)serializable).setCoordinates(new double[]{point.getLong(), point.getLat()});
                    geoJsonFeature.setGeometry((GeoJsonPointGeometry)serializable);
                    arrayList.add(geoJsonFeature);
                }
            }
        }
        geoJsonFeatureCollection.setFeatures(arrayList.toArray(new GeoJsonFeature[arrayList.size()]));
        JSONSerializer jSONSerializer = new JSONSerializer();
        object = jSONSerializer.deepSerialize((Object)geoJsonFeatureCollection);
        return object;
    }

    public GeocodeRequest geocodeRequestFromJson(String json) {
        GeocodeRequest geocodeRequest = (GeocodeRequest)new JSONDeserializer().deserialize(json);
        return geocodeRequest;
    }

    protected GeocodeResponse doQuery(Address[] addresses, String type) {
        GeocodeResponse geocodeResponse = new GeocodeResponse();
        ArrayList<GeocodeResponseList> arrayList = new ArrayList<GeocodeResponseList>();
        String string = new com.pentaho.geo.a.____(new long[]{-9204962187861913268L, -8281870165926103009L, -5768753771707075409L, 2996647805038725324L}).toString();
        int n = com.pentaho.geo.a.___._____(string);
        for (int i = 0; i < addresses.length; ++i) {
            GeocodeResponseList geocodeResponseList = new GeocodeResponseList();
            arrayList.add(geocodeResponseList);
            PlaceElement[] placeElementArray = addresses[i].getElements();
            if (placeElementArray == null) continue;
            for (int j = 0; j < placeElementArray.length; ++j) {
                if (placeElementArray[j] == null || !placeElementArray[j].getType().equalsIgnoreCase(type)) continue;
                String string2 = placeElementArray[j].getValue();
                List<Place> list = this.Q.getFeature(string2, type);
                if (placeElementArray.length > 1 && list != null) {
                    ArrayList<Place> arrayList2 = new ArrayList<Place>();
                    HashSet<Place> hashSet = new HashSet<Place>();
                    for (int k = 0; k < list.size(); ++k) {
                        Place place = list.get(k);
                        Boolean bl = true;
                        Boolean bl2 = false;
                        HashSet<PlaceElement> hashSet2 = new HashSet<PlaceElement>();
                        for (int i2 = 0; i2 < placeElementArray.length; ++i2) {
                            PlaceElement placeElement = placeElementArray[i2];
                            PlaceElement placeElement2 = this.getAliasedPlace(placeElement);
                            bl = this.compareToPlace(placeElement, place);
                            if (!(placeElement2 == null || bl != null && bl.booleanValue())) {
                                bl2 = this.compareToPlace(placeElement2, place);
                                if (bl2.booleanValue()) {
                                    hashSet2.add(placeElement);
                                }
                                bl = bl2;
                            }
                            if (bl == null) {
                                hashSet.add(place);
                                bl = false;
                                break;
                            }
                            if (!bl.booleanValue()) break;
                        }
                        if (bl2.booleanValue() && hashSet2.size() > 0) {
                            Place place2 = place;
                            arrayList2.add(Place.copyAndAlias(place2, hashSet2));
                            continue;
                        }
                        if (!bl.booleanValue()) continue;
                        arrayList2.add(place);
                    }
                    if (arrayList2.size() == 0 && hashSet.size() > 0) {
                        arrayList2.addAll(hashSet);
                    }
                    list = arrayList2;
                }
                if (list == null) continue;
                geocodeResponseList.setGeocodedAddresses(list);
            }
        }
        geocodeResponse.setGeocodeResponseList(arrayList.toArray(new GeocodeResponseList[arrayList.size()]));
        if (n >= 1) {
            return new GeocodeResponse();
        }
        return geocodeResponse;
    }

    private PlaceElement getAliasedPlace(PlaceElement wantedElement) {
        try {
            String string = this.getGeoStorage().getAliases().getProperty(wantedElement.getType() + "." + wantedElement.getValue());
            if (string != null) {
                PlaceElement placeElement = new PlaceElement();
                placeElement.setType(wantedElement.getType());
                placeElement.setValue(string);
                return placeElement;
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public boolean areEquivalentTypes(PlaceElement place1, PlaceElement place2) {
        return this.areEquivalentTypes(place1.getType(), place2.getType());
    }

    public boolean areEquivalentTypes(String type1, String type2) {
        if (this.isCountry(type1)) {
            return this.isCountry(type2);
        }
        if (this.isCountrySubdivision(type1)) {
            return this.isCountrySubdivision(type2);
        }
        return type1.equalsIgnoreCase(type2);
    }

    public Boolean compareToPlace(PlaceElement criterion, Place comparePlace) {
        int n;
        if (null == criterion) {
            return false;
        }
        Boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < comparePlace.getElements().length && !(bl2 = this.areEquivalentTypes(criterion, comparePlace.getElements()[n])); ++n) {
        }
        if (bl2) {
            for (n = 0; n < comparePlace.getElements().length; ++n) {
                boolean bl3 = this.areEquivalentTypes(criterion, comparePlace.getElements()[n]);
                if (!bl3) continue;
                String string = comparePlace.getElements()[n].getValue();
                if (criterion.getValue() == null) {
                    bl = string == null ? Boolean.valueOf(true) : null;
                } else {
                    if (!criterion.getValue().equalsIgnoreCase(string)) {
                        bl = false;
                        continue;
                    }
                    bl = true;
                }
                break;
            }
        } else {
            return true;
        }
        return bl;
    }

    private boolean isCountrySubdivision(String type) {
        return "CountrySubdivision".equals(type) || "CountrySubdivisionCode".equals(type) || "StateCode".equals(type);
    }

    private boolean isCountry(String type) {
        return "Country".equals(type) || "CountryCode".equals(type) || "CountryCode3".equals(type);
    }
}

